% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify.R
\name{classify}
\alias{classify}
\title{Identify colour classes in an image for adjacency analyses}
\usage{
classify(imgdat, kcols = NULL, refID = NULL, interactive = FALSE,
  plotnew = FALSE, col = "red", cores = getOption("mc.cores", 2L),
  ...)
}
\arguments{
\item{imgdat}{(required) image data. Either a single image, or a series of images
stored in a list. Preferably the result of \code{\link{getimg}}.}

\item{kcols}{the number of discrete colour classes present in the input image(s).
Can be a single integer when only a single image is present, or if kcols is identical for all
images. When passing a list of images, \code{kcols} can also be a vector the same length
as \code{imgdat}, or a data.frame with two columns specifying image file names and
corresponding kcols. This argument can optionally be disregarded when \code{interactive = TRUE},
and kcols will be inferred from the number of selections.}

\item{refID}{either the numeric index or name of a 'reference' image, for use when passing
a list of images. Other images will be k-means classified using centres identified
in the single reference image, thus helping to ensure that homologous pattern elements
will be reliably classified between images, if so desired.}

\item{interactive}{interactively specify the colour-category 'centers', for k-means clustering.
When \code{TRUE}, the user is asked to click a number of points (equal to \code{kcols},
if specified, otherwise user-determined) that represent the distinct colours of interest.
If a reference image is specified, it will be the only image presented.}

\item{plotnew}{Should plots be opened in a new window when \code{interactive = TRUE}?
Defaults to \code{FALSE}.}

\item{col}{the color of the marker points, when \code{interactive = TRUE}.}

\item{cores}{number of cores to be used in parallel processing. If \code{1}, parallel
computing will not be used. Defaults to \code{getOption("mc.cores", 2L)}. Not
available on Windows.}

\item{...}{additional graphical parameters when \code{interactive = TRUE}.
Also see \code{\link{par}}.}
}
\value{
A matrix, or list of matrices, of class \code{rimg} containing the colour
class classifications ID at each pixel location. The RGB values corresponding to
k-means centres (i.e. colour classes) are stored as object attributes.
}
\description{
Use k-means clustering to classify image pixels into discrete colour classes.
}
\note{
Since the \code{kmeans} process draws on random numbers to find initial
cluster centres when \code{interactive = FALSE}, use \code{set.seed} if reproducible
cluster ID's are desired between runs.
}
\examples{
# Single image
papilio <- getimg(system.file("testdata/images/papilio.png", package = "pavo"))
papilio_class <- classify(papilio, kcols = 4)

\dontrun{
# Multiple images, with interactive classification and a reference image
snakes <- getimg(system.file("testdata/images/snakes", package = "pavo"))
snakes_class <- classify(snakes, refID = "snake_01", interactive = TRUE)
}

}
\author{
Thomas E. White \email{thomas.white026@gmail.com}
}
