% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudsearch_operations.R
\name{cloudsearch_describe_index_fields}
\alias{cloudsearch_describe_index_fields}
\title{Gets information about the index fields configured for the search domain}
\usage{
cloudsearch_describe_index_fields(DomainName, FieldNames, Deployed)
}
\arguments{
\item{DomainName}{[required] The name of the domain you want to describe.}

\item{FieldNames}{A list of the index fields you want to describe. If not specified,
information is returned for all configured index fields.}

\item{Deployed}{Whether to display the deployed configuration (\code{true}) or include any
pending changes (\code{false}). Defaults to \code{false}.}
}
\description{
Gets information about the index fields configured for the search
domain. Can be limited to specific fields by name. By default, shows all
fields and includes any pending changes to the configuration. Set the
\code{Deployed} option to \code{true} to show the active configuration and exclude
pending changes. For more information, see \href{https://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html}{Getting Domain Information}
in the \emph{Amazon CloudSearch Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_index_fields(
  DomainName = "string",
  FieldNames = list(
    "string"
  ),
  Deployed = TRUE|FALSE
)
}
}

\keyword{internal}
