% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_update_schema}
\alias{glue_update_schema}
\title{Updates the description, compatibility setting, or version checkpoint
for a schema set}
\usage{
glue_update_schema(SchemaId, SchemaVersionNumber, Compatibility,
  Description)
}
\arguments{
\item{SchemaId}{[required] This is a wrapper structure to contain schema identity fields. The
structure contains:
\itemize{
\item SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
One of \code{SchemaArn} or \code{SchemaName} has to be provided.
\item SchemaId$SchemaName: The name of the schema. One of \code{SchemaArn} or
\code{SchemaName} has to be provided.
}}

\item{SchemaVersionNumber}{Version number required for check pointing. One of \code{VersionNumber} or
\code{Compatibility} has to be provided.}

\item{Compatibility}{The new compatibility setting for the schema.}

\item{Description}{The new description for the schema.}
}
\description{
Updates the description, compatibility setting, or version checkpoint
for a schema set.

For updating the compatibility setting, the call will not validate
compatibility for the entire set of schema versions with the new
compatibility setting. If the value for \code{Compatibility} is provided, the
\code{VersionNumber} (a checkpoint) is also required. The API will validate
the checkpoint version number for consistency.

If the value for the \code{VersionNumber} (checkpoint) is provided,
\code{Compatibility} is optional and this can be used to set/reset a
checkpoint for the schema.

This update will happen only if the schema is in the AVAILABLE state.
}
\section{Request syntax}{
\preformatted{svc$update_schema(
  SchemaId = list(
    SchemaArn = "string",
    SchemaName = "string",
    RegistryName = "string"
  ),
  SchemaVersionNumber = list(
    LatestVersion = TRUE|FALSE,
    VersionNumber = 123
  ),
  Compatibility = "NONE"|"DISABLED"|"BACKWARD"|"BACKWARD_ALL"|"FORWARD"|"FORWARD_ALL"|"FULL"|"FULL_ALL",
  Description = "string"
)
}
}

\keyword{internal}
