% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_namespace}
\alias{quicksight_create_namespace}
\title{(Enterprise edition only) Creates a new namespace for you to use with
Amazon QuickSight}
\usage{
quicksight_create_namespace(AwsAccountId, Namespace, IdentityStore,
  Tags)
}
\arguments{
\item{AwsAccountId}{[required] The ID for the AWS account that you want to create the QuickSight
namespace in.}

\item{Namespace}{[required] The name that you want to use to describe the new namespace.}

\item{IdentityStore}{[required] Specifies the type of your user identity directory. Currently, this
supports users with an identity type of \code{QUICKSIGHT}.}

\item{Tags}{The tags that you want to associate with the namespace that you're
creating.}
}
\description{
(Enterprise edition only) Creates a new namespace for you to use with
Amazon QuickSight.

A namespace allows you to isolate the QuickSight users and groups that
are registered for that namespace. Users that access the namespace can
share assets only with other users or groups in the same namespace. They
can't see users and groups in other namespaces. You can create a
namespace after your AWS account is subscribed to QuickSight. The
namespace must be unique within the AWS account. By default, there is a
limit of 100 namespaces per AWS account. To increase your limit, create
a ticket with AWS Support.
}
\section{Request syntax}{
\preformatted{svc$create_namespace(
  AwsAccountId = "string",
  Namespace = "string",
  IdentityStore = "QUICKSIGHT",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
