% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_update_iam_policy_assignment}
\alias{quicksight_update_iam_policy_assignment}
\title{Updates an existing IAM policy assignment}
\usage{
quicksight_update_iam_policy_assignment(AwsAccountId, AssignmentName,
  Namespace, AssignmentStatus, PolicyArn, Identities)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the AWS account that contains the IAM policy assignment.}

\item{AssignmentName}{[required] The name of the assignment, also called a rule. This name must be unique
within an AWS account.}

\item{Namespace}{[required] The namespace of the assignment.}

\item{AssignmentStatus}{The status of the assignment. Possible values are as follows:
\itemize{
\item \code{ENABLED} - Anything specified in this assignment is used when
creating the data source.
\item \code{DISABLED} - This assignment isn't used when creating the data
source.
\item \code{DRAFT} - This assignment is an unfinished draft and isn't used when
creating the data source.
}}

\item{PolicyArn}{The ARN for the IAM policy to apply to the QuickSight users and groups
specified in this assignment.}

\item{Identities}{The QuickSight users, groups, or both that you want to assign the policy
to.}
}
\description{
Updates an existing IAM policy assignment. This operation updates only
the optional parameter or parameters that are specified in the request.
This overwrites all of the users included in \code{Identities}.
}
\section{Request syntax}{
\preformatted{svc$update_iam_policy_assignment(
  AwsAccountId = "string",
  AssignmentName = "string",
  Namespace = "string",
  AssignmentStatus = "ENABLED"|"DRAFT"|"DISABLED",
  PolicyArn = "string",
  Identities = list(
    list(
      "string"
    )
  )
)
}
}

\keyword{internal}
