% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_delete_application_snapshot}
\alias{kinesisanalyticsv2_delete_application_snapshot}
\title{Deletes a snapshot of application state}
\usage{
kinesisanalyticsv2_delete_application_snapshot(ApplicationName,
  SnapshotName, SnapshotCreationTimestamp)
}
\arguments{
\item{ApplicationName}{[required] The name of an existing application.}

\item{SnapshotName}{[required] The identifier for the snapshot delete.}

\item{SnapshotCreationTimestamp}{[required] The creation timestamp of the application snapshot to delete. You can
retrieve this value using or .}
}
\value{
An empty list.
}
\description{
Deletes a snapshot of application state.
}
\section{Request syntax}{
\preformatted{svc$delete_application_snapshot(
  ApplicationName = "string",
  SnapshotName = "string",
  SnapshotCreationTimestamp = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\keyword{internal}
