# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ivs_service.R
NULL

#' Performs GetChannel on multiple ARNs simultaneously
#'
#' @description
#' Performs [`get_channel`][ivs_get_channel] on multiple ARNs simultaneously.
#'
#' See [https://paws-r.github.io/docs/ivs/batch_get_channel.html](https://paws-r.github.io/docs/ivs/batch_get_channel.html) for full documentation.
#'
#' @param arns &#91;required&#93; Array of ARNs, one per channel.
#'
#' @keywords internal
#'
#' @rdname ivs_batch_get_channel
ivs_batch_get_channel <- function(arns) {
  op <- new_operation(
    name = "BatchGetChannel",
    http_method = "POST",
    http_path = "/BatchGetChannel",
    paginator = list()
  )
  input <- .ivs$batch_get_channel_input(arns = arns)
  output <- .ivs$batch_get_channel_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$batch_get_channel <- ivs_batch_get_channel

#' Performs GetStreamKey on multiple ARNs simultaneously
#'
#' @description
#' Performs [`get_stream_key`][ivs_get_stream_key] on multiple ARNs simultaneously.
#'
#' See [https://paws-r.github.io/docs/ivs/batch_get_stream_key.html](https://paws-r.github.io/docs/ivs/batch_get_stream_key.html) for full documentation.
#'
#' @param arns &#91;required&#93; Array of ARNs, one per channel.
#'
#' @keywords internal
#'
#' @rdname ivs_batch_get_stream_key
ivs_batch_get_stream_key <- function(arns) {
  op <- new_operation(
    name = "BatchGetStreamKey",
    http_method = "POST",
    http_path = "/BatchGetStreamKey",
    paginator = list()
  )
  input <- .ivs$batch_get_stream_key_input(arns = arns)
  output <- .ivs$batch_get_stream_key_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$batch_get_stream_key <- ivs_batch_get_stream_key

#' Creates a new channel and an associated stream key to start streaming
#'
#' @description
#' Creates a new channel and an associated stream key to start streaming.
#'
#' See [https://paws-r.github.io/docs/ivs/create_channel.html](https://paws-r.github.io/docs/ivs/create_channel.html) for full documentation.
#'
#' @param authorized Whether the channel is private (enabled for playback authorization).
#' Default: `false`.
#' @param latencyMode Channel latency mode. Use `NORMAL` to broadcast and deliver live video
#' up to Full HD. Use `LOW` for near-real-time interaction with viewers.
#' (Note: In the Amazon IVS console, `LOW` and `NORMAL` correspond to
#' Ultra-low and Standard, respectively.) Default: `LOW`.
#' @param name Channel name.
#' @param recordingConfigurationArn Recording-configuration ARN. Default: "" (empty string, recording is
#' disabled).
#' @param tags Array of 1-50 maps, each of the form `string:string (key:value)`.
#' @param type Channel type, which determines the allowable resolution and bitrate. *If
#' you exceed the allowable resolution or bitrate, the stream probably will
#' disconnect immediately.* Default: `STANDARD`. Valid values:
#' 
#' -   `STANDARD`: Multiple qualities are generated from the original
#'     input, to automatically give viewers the best experience for their
#'     devices and network conditions. Resolution can be up to 1080p and
#'     bitrate can be up to 8.5 Mbps. Audio is transcoded only for
#'     renditions 360p and below; above that, audio is passed through.
#' 
#' -   `BASIC`: Amazon IVS delivers the original input to viewers. The
#'     viewer’s video-quality choice is limited to the original input.
#'     Resolution can be up to 480p and bitrate can be up to 1.5 Mbps.
#'
#' @keywords internal
#'
#' @rdname ivs_create_channel
ivs_create_channel <- function(authorized = NULL, latencyMode = NULL, name = NULL, recordingConfigurationArn = NULL, tags = NULL, type = NULL) {
  op <- new_operation(
    name = "CreateChannel",
    http_method = "POST",
    http_path = "/CreateChannel",
    paginator = list()
  )
  input <- .ivs$create_channel_input(authorized = authorized, latencyMode = latencyMode, name = name, recordingConfigurationArn = recordingConfigurationArn, tags = tags, type = type)
  output <- .ivs$create_channel_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$create_channel <- ivs_create_channel

#' Creates a new recording configuration, used to enable recording to
#' Amazon S3
#'
#' @description
#' Creates a new recording configuration, used to enable recording to Amazon S3.
#'
#' See [https://paws-r.github.io/docs/ivs/create_recording_configuration.html](https://paws-r.github.io/docs/ivs/create_recording_configuration.html) for full documentation.
#'
#' @param destinationConfiguration &#91;required&#93; A complex type that contains a destination configuration for where
#' recorded video will be stored.
#' @param name Recording-configuration name. The value does not need to be unique.
#' @param tags Array of 1-50 maps, each of the form `string:string (key:value)`.
#' @param thumbnailConfiguration A complex type that allows you to enable/disable the recording of
#' thumbnails for a live session and modify the interval at which
#' thumbnails are generated for the live session.
#'
#' @keywords internal
#'
#' @rdname ivs_create_recording_configuration
ivs_create_recording_configuration <- function(destinationConfiguration, name = NULL, tags = NULL, thumbnailConfiguration = NULL) {
  op <- new_operation(
    name = "CreateRecordingConfiguration",
    http_method = "POST",
    http_path = "/CreateRecordingConfiguration",
    paginator = list()
  )
  input <- .ivs$create_recording_configuration_input(destinationConfiguration = destinationConfiguration, name = name, tags = tags, thumbnailConfiguration = thumbnailConfiguration)
  output <- .ivs$create_recording_configuration_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$create_recording_configuration <- ivs_create_recording_configuration

#' Creates a stream key, used to initiate a stream, for the specified
#' channel ARN
#'
#' @description
#' Creates a stream key, used to initiate a stream, for the specified channel ARN.
#'
#' See [https://paws-r.github.io/docs/ivs/create_stream_key.html](https://paws-r.github.io/docs/ivs/create_stream_key.html) for full documentation.
#'
#' @param channelArn &#91;required&#93; ARN of the channel for which to create the stream key.
#' @param tags Array of 1-50 maps, each of the form `string:string (key:value)`.
#'
#' @keywords internal
#'
#' @rdname ivs_create_stream_key
ivs_create_stream_key <- function(channelArn, tags = NULL) {
  op <- new_operation(
    name = "CreateStreamKey",
    http_method = "POST",
    http_path = "/CreateStreamKey",
    paginator = list()
  )
  input <- .ivs$create_stream_key_input(channelArn = channelArn, tags = tags)
  output <- .ivs$create_stream_key_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$create_stream_key <- ivs_create_stream_key

#' Deletes the specified channel and its associated stream keys
#'
#' @description
#' Deletes the specified channel and its associated stream keys.
#'
#' See [https://paws-r.github.io/docs/ivs/delete_channel.html](https://paws-r.github.io/docs/ivs/delete_channel.html) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the channel to be deleted.
#'
#' @keywords internal
#'
#' @rdname ivs_delete_channel
ivs_delete_channel <- function(arn) {
  op <- new_operation(
    name = "DeleteChannel",
    http_method = "POST",
    http_path = "/DeleteChannel",
    paginator = list()
  )
  input <- .ivs$delete_channel_input(arn = arn)
  output <- .ivs$delete_channel_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$delete_channel <- ivs_delete_channel

#' Deletes a specified authorization key pair
#'
#' @description
#' Deletes a specified authorization key pair. This invalidates future viewer tokens generated using the key pair’s `privateKey`. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
#'
#' See [https://paws-r.github.io/docs/ivs/delete_playback_key_pair.html](https://paws-r.github.io/docs/ivs/delete_playback_key_pair.html) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the key pair to be deleted.
#'
#' @keywords internal
#'
#' @rdname ivs_delete_playback_key_pair
ivs_delete_playback_key_pair <- function(arn) {
  op <- new_operation(
    name = "DeletePlaybackKeyPair",
    http_method = "POST",
    http_path = "/DeletePlaybackKeyPair",
    paginator = list()
  )
  input <- .ivs$delete_playback_key_pair_input(arn = arn)
  output <- .ivs$delete_playback_key_pair_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$delete_playback_key_pair <- ivs_delete_playback_key_pair

#' Deletes the recording configuration for the specified ARN
#'
#' @description
#' Deletes the recording configuration for the specified ARN.
#'
#' See [https://paws-r.github.io/docs/ivs/delete_recording_configuration.html](https://paws-r.github.io/docs/ivs/delete_recording_configuration.html) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the recording configuration to be deleted.
#'
#' @keywords internal
#'
#' @rdname ivs_delete_recording_configuration
ivs_delete_recording_configuration <- function(arn) {
  op <- new_operation(
    name = "DeleteRecordingConfiguration",
    http_method = "POST",
    http_path = "/DeleteRecordingConfiguration",
    paginator = list()
  )
  input <- .ivs$delete_recording_configuration_input(arn = arn)
  output <- .ivs$delete_recording_configuration_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$delete_recording_configuration <- ivs_delete_recording_configuration

#' Deletes the stream key for the specified ARN, so it can no longer be
#' used to stream
#'
#' @description
#' Deletes the stream key for the specified ARN, so it can no longer be used to stream.
#'
#' See [https://paws-r.github.io/docs/ivs/delete_stream_key.html](https://paws-r.github.io/docs/ivs/delete_stream_key.html) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the stream key to be deleted.
#'
#' @keywords internal
#'
#' @rdname ivs_delete_stream_key
ivs_delete_stream_key <- function(arn) {
  op <- new_operation(
    name = "DeleteStreamKey",
    http_method = "POST",
    http_path = "/DeleteStreamKey",
    paginator = list()
  )
  input <- .ivs$delete_stream_key_input(arn = arn)
  output <- .ivs$delete_stream_key_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$delete_stream_key <- ivs_delete_stream_key

#' Gets the channel configuration for the specified channel ARN
#'
#' @description
#' Gets the channel configuration for the specified channel ARN. See also [`batch_get_channel`][ivs_batch_get_channel].
#'
#' See [https://paws-r.github.io/docs/ivs/get_channel.html](https://paws-r.github.io/docs/ivs/get_channel.html) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the channel for which the configuration is to be retrieved.
#'
#' @keywords internal
#'
#' @rdname ivs_get_channel
ivs_get_channel <- function(arn) {
  op <- new_operation(
    name = "GetChannel",
    http_method = "POST",
    http_path = "/GetChannel",
    paginator = list()
  )
  input <- .ivs$get_channel_input(arn = arn)
  output <- .ivs$get_channel_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$get_channel <- ivs_get_channel

#' Gets a specified playback authorization key pair and returns the arn and
#' fingerprint
#'
#' @description
#' Gets a specified playback authorization key pair and returns the `arn` and `fingerprint`. The `privateKey` held by the caller can be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
#'
#' See [https://paws-r.github.io/docs/ivs/get_playback_key_pair.html](https://paws-r.github.io/docs/ivs/get_playback_key_pair.html) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the key pair to be returned.
#'
#' @keywords internal
#'
#' @rdname ivs_get_playback_key_pair
ivs_get_playback_key_pair <- function(arn) {
  op <- new_operation(
    name = "GetPlaybackKeyPair",
    http_method = "POST",
    http_path = "/GetPlaybackKeyPair",
    paginator = list()
  )
  input <- .ivs$get_playback_key_pair_input(arn = arn)
  output <- .ivs$get_playback_key_pair_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$get_playback_key_pair <- ivs_get_playback_key_pair

#' Gets the recording configuration for the specified ARN
#'
#' @description
#' Gets the recording configuration for the specified ARN.
#'
#' See [https://paws-r.github.io/docs/ivs/get_recording_configuration.html](https://paws-r.github.io/docs/ivs/get_recording_configuration.html) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the recording configuration to be retrieved.
#'
#' @keywords internal
#'
#' @rdname ivs_get_recording_configuration
ivs_get_recording_configuration <- function(arn) {
  op <- new_operation(
    name = "GetRecordingConfiguration",
    http_method = "POST",
    http_path = "/GetRecordingConfiguration",
    paginator = list()
  )
  input <- .ivs$get_recording_configuration_input(arn = arn)
  output <- .ivs$get_recording_configuration_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$get_recording_configuration <- ivs_get_recording_configuration

#' Gets information about the active (live) stream on a specified channel
#'
#' @description
#' Gets information about the active (live) stream on a specified channel.
#'
#' See [https://paws-r.github.io/docs/ivs/get_stream.html](https://paws-r.github.io/docs/ivs/get_stream.html) for full documentation.
#'
#' @param channelArn &#91;required&#93; Channel ARN for stream to be accessed.
#'
#' @keywords internal
#'
#' @rdname ivs_get_stream
ivs_get_stream <- function(channelArn) {
  op <- new_operation(
    name = "GetStream",
    http_method = "POST",
    http_path = "/GetStream",
    paginator = list()
  )
  input <- .ivs$get_stream_input(channelArn = channelArn)
  output <- .ivs$get_stream_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$get_stream <- ivs_get_stream

#' Gets stream-key information for a specified ARN
#'
#' @description
#' Gets stream-key information for a specified ARN.
#'
#' See [https://paws-r.github.io/docs/ivs/get_stream_key.html](https://paws-r.github.io/docs/ivs/get_stream_key.html) for full documentation.
#'
#' @param arn &#91;required&#93; ARN for the stream key to be retrieved.
#'
#' @keywords internal
#'
#' @rdname ivs_get_stream_key
ivs_get_stream_key <- function(arn) {
  op <- new_operation(
    name = "GetStreamKey",
    http_method = "POST",
    http_path = "/GetStreamKey",
    paginator = list()
  )
  input <- .ivs$get_stream_key_input(arn = arn)
  output <- .ivs$get_stream_key_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$get_stream_key <- ivs_get_stream_key

#' Gets metadata on a specified stream
#'
#' @description
#' Gets metadata on a specified stream.
#'
#' See [https://paws-r.github.io/docs/ivs/get_stream_session.html](https://paws-r.github.io/docs/ivs/get_stream_session.html) for full documentation.
#'
#' @param channelArn &#91;required&#93; ARN of the channel resource
#' @param streamId Unique identifier for a live or previously live stream in the specified
#' channel. If no `streamId` is provided, this returns the most recent
#' stream session for the channel, if it exists.
#'
#' @keywords internal
#'
#' @rdname ivs_get_stream_session
ivs_get_stream_session <- function(channelArn, streamId = NULL) {
  op <- new_operation(
    name = "GetStreamSession",
    http_method = "POST",
    http_path = "/GetStreamSession",
    paginator = list()
  )
  input <- .ivs$get_stream_session_input(channelArn = channelArn, streamId = streamId)
  output <- .ivs$get_stream_session_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$get_stream_session <- ivs_get_stream_session

#' Imports the public portion of a new key pair and returns its arn and
#' fingerprint
#'
#' @description
#' Imports the public portion of a new key pair and returns its `arn` and `fingerprint`. The `privateKey` can then be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
#'
#' See [https://paws-r.github.io/docs/ivs/import_playback_key_pair.html](https://paws-r.github.io/docs/ivs/import_playback_key_pair.html) for full documentation.
#'
#' @param name Playback-key-pair name. The value does not need to be unique.
#' @param publicKeyMaterial &#91;required&#93; The public portion of a customer-generated key pair.
#' @param tags Any tags provided with the request are added to the playback key pair
#' tags.
#'
#' @keywords internal
#'
#' @rdname ivs_import_playback_key_pair
ivs_import_playback_key_pair <- function(name = NULL, publicKeyMaterial, tags = NULL) {
  op <- new_operation(
    name = "ImportPlaybackKeyPair",
    http_method = "POST",
    http_path = "/ImportPlaybackKeyPair",
    paginator = list()
  )
  input <- .ivs$import_playback_key_pair_input(name = name, publicKeyMaterial = publicKeyMaterial, tags = tags)
  output <- .ivs$import_playback_key_pair_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$import_playback_key_pair <- ivs_import_playback_key_pair

#' Gets summary information about all channels in your account, in the
#' Amazon Web Services region where the API request is processed
#'
#' @description
#' Gets summary information about all channels in your account, in the Amazon Web Services region where the API request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409 ConflictException).
#'
#' See [https://paws-r.github.io/docs/ivs/list_channels.html](https://paws-r.github.io/docs/ivs/list_channels.html) for full documentation.
#'
#' @param filterByName Filters the channel list to match the specified name.
#' @param filterByRecordingConfigurationArn Filters the channel list to match the specified recording-configuration
#' ARN.
#' @param maxResults Maximum number of channels to return. Default: 50.
#' @param nextToken The first channel to retrieve. This is used for pagination; see the
#' `nextToken` response field.
#'
#' @keywords internal
#'
#' @rdname ivs_list_channels
ivs_list_channels <- function(filterByName = NULL, filterByRecordingConfigurationArn = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListChannels",
    http_method = "POST",
    http_path = "/ListChannels",
    paginator = list()
  )
  input <- .ivs$list_channels_input(filterByName = filterByName, filterByRecordingConfigurationArn = filterByRecordingConfigurationArn, maxResults = maxResults, nextToken = nextToken)
  output <- .ivs$list_channels_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$list_channels <- ivs_list_channels

#' Gets summary information about playback key pairs
#'
#' @description
#' Gets summary information about playback key pairs. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
#'
#' See [https://paws-r.github.io/docs/ivs/list_playback_key_pairs.html](https://paws-r.github.io/docs/ivs/list_playback_key_pairs.html) for full documentation.
#'
#' @param maxResults The first key pair to retrieve. This is used for pagination; see the
#' `nextToken` response field. Default: 50.
#' @param nextToken Maximum number of key pairs to return.
#'
#' @keywords internal
#'
#' @rdname ivs_list_playback_key_pairs
ivs_list_playback_key_pairs <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListPlaybackKeyPairs",
    http_method = "POST",
    http_path = "/ListPlaybackKeyPairs",
    paginator = list()
  )
  input <- .ivs$list_playback_key_pairs_input(maxResults = maxResults, nextToken = nextToken)
  output <- .ivs$list_playback_key_pairs_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$list_playback_key_pairs <- ivs_list_playback_key_pairs

#' Gets summary information about all recording configurations in your
#' account, in the Amazon Web Services region where the API request is
#' processed
#'
#' @description
#' Gets summary information about all recording configurations in your account, in the Amazon Web Services region where the API request is processed.
#'
#' See [https://paws-r.github.io/docs/ivs/list_recording_configurations.html](https://paws-r.github.io/docs/ivs/list_recording_configurations.html) for full documentation.
#'
#' @param maxResults Maximum number of recording configurations to return. Default: 50.
#' @param nextToken The first recording configuration to retrieve. This is used for
#' pagination; see the `nextToken` response field.
#'
#' @keywords internal
#'
#' @rdname ivs_list_recording_configurations
ivs_list_recording_configurations <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListRecordingConfigurations",
    http_method = "POST",
    http_path = "/ListRecordingConfigurations",
    paginator = list()
  )
  input <- .ivs$list_recording_configurations_input(maxResults = maxResults, nextToken = nextToken)
  output <- .ivs$list_recording_configurations_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$list_recording_configurations <- ivs_list_recording_configurations

#' Gets summary information about stream keys for the specified channel
#'
#' @description
#' Gets summary information about stream keys for the specified channel.
#'
#' See [https://paws-r.github.io/docs/ivs/list_stream_keys.html](https://paws-r.github.io/docs/ivs/list_stream_keys.html) for full documentation.
#'
#' @param channelArn &#91;required&#93; Channel ARN used to filter the list.
#' @param maxResults Maximum number of streamKeys to return. Default: 50.
#' @param nextToken The first stream key to retrieve. This is used for pagination; see the
#' `nextToken` response field.
#'
#' @keywords internal
#'
#' @rdname ivs_list_stream_keys
ivs_list_stream_keys <- function(channelArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListStreamKeys",
    http_method = "POST",
    http_path = "/ListStreamKeys",
    paginator = list()
  )
  input <- .ivs$list_stream_keys_input(channelArn = channelArn, maxResults = maxResults, nextToken = nextToken)
  output <- .ivs$list_stream_keys_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$list_stream_keys <- ivs_list_stream_keys

#' Gets a summary of current and previous streams for a specified channel
#' in your account, in the AWS region where the API request is processed
#'
#' @description
#' Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where the API request is processed.
#'
#' See [https://paws-r.github.io/docs/ivs/list_stream_sessions.html](https://paws-r.github.io/docs/ivs/list_stream_sessions.html) for full documentation.
#'
#' @param channelArn &#91;required&#93; Channel ARN used to filter the list.
#' @param maxResults Maximum number of streams to return. Default: 50.
#' @param nextToken The first stream to retrieve. This is used for pagination; see the
#' `nextToken` response field.
#'
#' @keywords internal
#'
#' @rdname ivs_list_stream_sessions
ivs_list_stream_sessions <- function(channelArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListStreamSessions",
    http_method = "POST",
    http_path = "/ListStreamSessions",
    paginator = list()
  )
  input <- .ivs$list_stream_sessions_input(channelArn = channelArn, maxResults = maxResults, nextToken = nextToken)
  output <- .ivs$list_stream_sessions_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$list_stream_sessions <- ivs_list_stream_sessions

#' Gets summary information about live streams in your account, in the
#' Amazon Web Services region where the API request is processed
#'
#' @description
#' Gets summary information about live streams in your account, in the Amazon Web Services region where the API request is processed.
#'
#' See [https://paws-r.github.io/docs/ivs/list_streams.html](https://paws-r.github.io/docs/ivs/list_streams.html) for full documentation.
#'
#' @param filterBy Filters the stream list to match the specified criterion.
#' @param maxResults Maximum number of streams to return. Default: 50.
#' @param nextToken The first stream to retrieve. This is used for pagination; see the
#' `nextToken` response field.
#'
#' @keywords internal
#'
#' @rdname ivs_list_streams
ivs_list_streams <- function(filterBy = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListStreams",
    http_method = "POST",
    http_path = "/ListStreams",
    paginator = list()
  )
  input <- .ivs$list_streams_input(filterBy = filterBy, maxResults = maxResults, nextToken = nextToken)
  output <- .ivs$list_streams_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$list_streams <- ivs_list_streams

#' Gets information about Amazon Web Services tags for the specified ARN
#'
#' @description
#' Gets information about Amazon Web Services tags for the specified ARN.
#'
#' See [https://paws-r.github.io/docs/ivs/list_tags_for_resource.html](https://paws-r.github.io/docs/ivs/list_tags_for_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource to be retrieved.
#'
#' @keywords internal
#'
#' @rdname ivs_list_tags_for_resource
ivs_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .ivs$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .ivs$list_tags_for_resource_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$list_tags_for_resource <- ivs_list_tags_for_resource

#' Inserts metadata into the active stream of the specified channel
#'
#' @description
#' Inserts metadata into the active stream of the specified channel. At most 5 requests per second per channel are allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient for your needs, we recommend batching your data into a single PutMetadata call.) At most 155 requests per second per account are allowed. Also see [Embedding Metadata within a Video Stream](https://docs.aws.amazon.com/ivs/latest/userguide/metadata.html) in the *Amazon IVS User Guide*.
#'
#' See [https://paws-r.github.io/docs/ivs/put_metadata.html](https://paws-r.github.io/docs/ivs/put_metadata.html) for full documentation.
#'
#' @param channelArn &#91;required&#93; ARN of the channel into which metadata is inserted. This channel must
#' have an active stream.
#' @param metadata &#91;required&#93; Metadata to insert into the stream. Maximum: 1 KB per request.
#'
#' @keywords internal
#'
#' @rdname ivs_put_metadata
ivs_put_metadata <- function(channelArn, metadata) {
  op <- new_operation(
    name = "PutMetadata",
    http_method = "POST",
    http_path = "/PutMetadata",
    paginator = list()
  )
  input <- .ivs$put_metadata_input(channelArn = channelArn, metadata = metadata)
  output <- .ivs$put_metadata_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$put_metadata <- ivs_put_metadata

#' Disconnects the incoming RTMPS stream for the specified channel
#'
#' @description
#' Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with [`delete_stream_key`][ivs_delete_stream_key] to prevent further streaming to a channel.
#'
#' See [https://paws-r.github.io/docs/ivs/stop_stream.html](https://paws-r.github.io/docs/ivs/stop_stream.html) for full documentation.
#'
#' @param channelArn &#91;required&#93; ARN of the channel for which the stream is to be stopped.
#'
#' @keywords internal
#'
#' @rdname ivs_stop_stream
ivs_stop_stream <- function(channelArn) {
  op <- new_operation(
    name = "StopStream",
    http_method = "POST",
    http_path = "/StopStream",
    paginator = list()
  )
  input <- .ivs$stop_stream_input(channelArn = channelArn)
  output <- .ivs$stop_stream_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$stop_stream <- ivs_stop_stream

#' Adds or updates tags for the Amazon Web Services resource with the
#' specified ARN
#'
#' @description
#' Adds or updates tags for the Amazon Web Services resource with the specified ARN.
#'
#' See [https://paws-r.github.io/docs/ivs/tag_resource.html](https://paws-r.github.io/docs/ivs/tag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; ARN of the resource for which tags are to be added or updated.
#' @param tags &#91;required&#93; Array of tags to be added or updated.
#'
#' @keywords internal
#'
#' @rdname ivs_tag_resource
ivs_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .ivs$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .ivs$tag_resource_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$tag_resource <- ivs_tag_resource

#' Removes tags from the resource with the specified ARN
#'
#' @description
#' Removes tags from the resource with the specified ARN.
#'
#' See [https://paws-r.github.io/docs/ivs/untag_resource.html](https://paws-r.github.io/docs/ivs/untag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; ARN of the resource for which tags are to be removed.
#' @param tagKeys &#91;required&#93; Array of tags to be removed.
#'
#' @keywords internal
#'
#' @rdname ivs_untag_resource
ivs_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .ivs$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .ivs$untag_resource_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$untag_resource <- ivs_untag_resource

#' Updates a channel's configuration
#'
#' @description
#' Updates a channel's configuration. This does not affect an ongoing stream of this channel. You must stop and restart the stream for the changes to take effect.
#'
#' See [https://paws-r.github.io/docs/ivs/update_channel.html](https://paws-r.github.io/docs/ivs/update_channel.html) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the channel to be updated.
#' @param authorized Whether the channel is private (enabled for playback authorization).
#' @param latencyMode Channel latency mode. Use `NORMAL` to broadcast and deliver live video
#' up to Full HD. Use `LOW` for near-real-time interaction with viewers.
#' (Note: In the Amazon IVS console, `LOW` and `NORMAL` correspond to
#' Ultra-low and Standard, respectively.)
#' @param name Channel name.
#' @param recordingConfigurationArn Recording-configuration ARN. If this is set to an empty string,
#' recording is disabled. A value other than an empty string indicates that
#' recording is enabled
#' @param type Channel type, which determines the allowable resolution and bitrate. *If
#' you exceed the allowable resolution or bitrate, the stream probably will
#' disconnect immediately*. Valid values:
#' 
#' -   `STANDARD`: Multiple qualities are generated from the original
#'     input, to automatically give viewers the best experience for their
#'     devices and network conditions. Resolution can be up to 1080p and
#'     bitrate can be up to 8.5 Mbps. Audio is transcoded only for
#'     renditions 360p and below; above that, audio is passed through.
#' 
#' -   `BASIC`: Amazon IVS delivers the original input to viewers. The
#'     viewer’s video-quality choice is limited to the original input.
#'     Resolution can be up to 480p and bitrate can be up to 1.5 Mbps.
#'
#' @keywords internal
#'
#' @rdname ivs_update_channel
ivs_update_channel <- function(arn, authorized = NULL, latencyMode = NULL, name = NULL, recordingConfigurationArn = NULL, type = NULL) {
  op <- new_operation(
    name = "UpdateChannel",
    http_method = "POST",
    http_path = "/UpdateChannel",
    paginator = list()
  )
  input <- .ivs$update_channel_input(arn = arn, authorized = authorized, latencyMode = latencyMode, name = name, recordingConfigurationArn = recordingConfigurationArn, type = type)
  output <- .ivs$update_channel_output()
  config <- get_config()
  svc <- .ivs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$update_channel <- ivs_update_channel
