# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include quicksight_service.R
NULL

#' Cancels an ongoing ingestion of data into SPICE
#'
#' @description
#' Cancels an ongoing ingestion of data into SPICE.
#'
#' See [https://paws-r.github.io/docs/quicksight/cancel_ingestion.html](https://paws-r.github.io/docs/quicksight/cancel_ingestion.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param DataSetId &#91;required&#93; The ID of the dataset used in the ingestion.
#' @param IngestionId &#91;required&#93; An ID for the ingestion.
#'
#' @keywords internal
#'
#' @rdname quicksight_cancel_ingestion
quicksight_cancel_ingestion <- function(AwsAccountId, DataSetId, IngestionId) {
  op <- new_operation(
    name = "CancelIngestion",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
    paginator = list()
  )
  input <- .quicksight$cancel_ingestion_input(AwsAccountId = AwsAccountId, DataSetId = DataSetId, IngestionId = IngestionId)
  output <- .quicksight$cancel_ingestion_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$cancel_ingestion <- quicksight_cancel_ingestion

#' Creates Amazon QuickSight customizations for the current Amazon Web
#' Services Region
#'
#' @description
#' Creates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, you can add a custom default theme by using the [`create_account_customization`][quicksight_create_account_customization] or [`update_account_customization`][quicksight_update_account_customization] API operation. To further customize Amazon QuickSight by removing Amazon QuickSight sample assets and videos for all new users, see [Customizing Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html) in the *Amazon QuickSight User Guide.*
#'
#' See [https://paws-r.github.io/docs/quicksight/create_account_customization.html](https://paws-r.github.io/docs/quicksight/create_account_customization.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that you want to customize
#' Amazon QuickSight for.
#' @param Namespace The Amazon QuickSight namespace that you want to add customizations to.
#' @param AccountCustomization &#91;required&#93; The Amazon QuickSight customizations you're adding in the current Amazon
#' Web Services Region. You can add these to an Amazon Web Services account
#' and a QuickSight namespace.
#' 
#' For example, you can add a default theme by setting
#' `AccountCustomization` to the midnight theme:
#' `"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT" }`.
#' Or, you can add a custom theme by specifying
#' `"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639" }`.
#' @param Tags A list of the tags that you want to attach to this resource.
#'
#' @keywords internal
#'
#' @rdname quicksight_create_account_customization
quicksight_create_account_customization <- function(AwsAccountId, Namespace = NULL, AccountCustomization, Tags = NULL) {
  op <- new_operation(
    name = "CreateAccountCustomization",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/customizations",
    paginator = list()
  )
  input <- .quicksight$create_account_customization_input(AwsAccountId = AwsAccountId, Namespace = Namespace, AccountCustomization = AccountCustomization, Tags = Tags)
  output <- .quicksight$create_account_customization_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_account_customization <- quicksight_create_account_customization

#' Creates an Amazon QuickSight account, or subscribes to Amazon QuickSight
#' Q
#'
#' @description
#' Creates an Amazon QuickSight account, or subscribes to Amazon QuickSight Q.
#'
#' See [https://paws-r.github.io/docs/quicksight/create_account_subscription.html](https://paws-r.github.io/docs/quicksight/create_account_subscription.html) for full documentation.
#'
#' @param Edition &#91;required&#93; The edition of Amazon QuickSight that you want your account to have.
#' Currently, you can choose from `ENTERPRISE` or `ENTERPRISE_AND_Q`.
#' 
#' If you choose `ENTERPRISE_AND_Q`, the following parameters are required:
#' 
#' -   `FirstName`
#' 
#' -   `LastName`
#' 
#' -   `EmailAddress`
#' 
#' -   `ContactNumber`
#' @param AuthenticationMethod &#91;required&#93; The method that you want to use to authenticate your Amazon QuickSight
#' account. Currently, the valid values for this parameter are
#' `IAM_AND_QUICKSIGHT`, `IAM_ONLY`, and `ACTIVE_DIRECTORY`.
#' 
#' If you choose `ACTIVE_DIRECTORY`, provide an `ActiveDirectoryName` and
#' an `AdminGroup` associated with your Active Directory.
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID of the account that you're using to
#' create your Amazon QuickSight account.
#' @param AccountName &#91;required&#93; The name of your Amazon QuickSight account. This name is unique over all
#' of Amazon Web Services, and it appears only when users sign in. You
#' can't change `AccountName` value after the Amazon QuickSight account is
#' created.
#' @param NotificationEmail &#91;required&#93; The email address that you want Amazon QuickSight to send notifications
#' to regarding your Amazon QuickSight account or Amazon QuickSight
#' subscription.
#' @param ActiveDirectoryName The name of your Active Directory. This field is required if
#' `ACTIVE_DIRECTORY` is the selected authentication method of the new
#' Amazon QuickSight account.
#' @param Realm The realm of the Active Directory that is associated with your Amazon
#' QuickSight account. This field is required if `ACTIVE_DIRECTORY` is the
#' selected authentication method of the new Amazon QuickSight account.
#' @param DirectoryId The ID of the Active Directory that is associated with your Amazon
#' QuickSight account.
#' @param AdminGroup The admin group associated with your Active Directory. This field is
#' required if `ACTIVE_DIRECTORY` is the selected authentication method of
#' the new Amazon QuickSight account. For more information about using
#' Active Directory in Amazon QuickSight, see [Using Active Directory with
#' Amazon QuickSight Enterprise
#' Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html)
#' in the Amazon QuickSight User Guide.
#' @param AuthorGroup The author group associated with your Active Directory. For more
#' information about using Active Directory in Amazon QuickSight, see
#' [Using Active Directory with Amazon QuickSight Enterprise
#' Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html)
#' in the Amazon QuickSight User Guide.
#' @param ReaderGroup The reader group associated with your Active Direcrtory. For more
#' information about using Active Directory in Amazon QuickSight, see
#' [Using Active Directory with Amazon QuickSight Enterprise
#' Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html)
#' in the *Amazon QuickSight User Guide*.
#' @param FirstName The first name of the author of the Amazon QuickSight account to use for
#' future communications. This field is required if `ENTERPPRISE_AND_Q` is
#' the selected edition of the new Amazon QuickSight account.
#' @param LastName The last name of the author of the Amazon QuickSight account to use for
#' future communications. This field is required if `ENTERPPRISE_AND_Q` is
#' the selected edition of the new Amazon QuickSight account.
#' @param EmailAddress The email address of the author of the Amazon QuickSight account to use
#' for future communications. This field is required if `ENTERPPRISE_AND_Q`
#' is the selected edition of the new Amazon QuickSight account.
#' @param ContactNumber A 10-digit phone number for the author of the Amazon QuickSight account
#' to use for future communications. This field is required if
#' `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight
#' account.
#'
#' @keywords internal
#'
#' @rdname quicksight_create_account_subscription
quicksight_create_account_subscription <- function(Edition, AuthenticationMethod, AwsAccountId, AccountName, NotificationEmail, ActiveDirectoryName = NULL, Realm = NULL, DirectoryId = NULL, AdminGroup = NULL, AuthorGroup = NULL, ReaderGroup = NULL, FirstName = NULL, LastName = NULL, EmailAddress = NULL, ContactNumber = NULL) {
  op <- new_operation(
    name = "CreateAccountSubscription",
    http_method = "POST",
    http_path = "/account/{AwsAccountId}",
    paginator = list()
  )
  input <- .quicksight$create_account_subscription_input(Edition = Edition, AuthenticationMethod = AuthenticationMethod, AwsAccountId = AwsAccountId, AccountName = AccountName, NotificationEmail = NotificationEmail, ActiveDirectoryName = ActiveDirectoryName, Realm = Realm, DirectoryId = DirectoryId, AdminGroup = AdminGroup, AuthorGroup = AuthorGroup, ReaderGroup = ReaderGroup, FirstName = FirstName, LastName = LastName, EmailAddress = EmailAddress, ContactNumber = ContactNumber)
  output <- .quicksight$create_account_subscription_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_account_subscription <- quicksight_create_account_subscription

#' Creates an analysis in Amazon QuickSight
#'
#' @description
#' Creates an analysis in Amazon QuickSight.
#'
#' See [https://paws-r.github.io/docs/quicksight/create_analysis.html](https://paws-r.github.io/docs/quicksight/create_analysis.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account where you are creating an
#' analysis.
#' @param AnalysisId &#91;required&#93; The ID for the analysis that you're creating. This ID displays in the
#' URL of the analysis.
#' @param Name &#91;required&#93; A descriptive name for the analysis that you're creating. This name
#' displays for the analysis in the Amazon QuickSight console.
#' @param Parameters The parameter names and override values that you want to use. An
#' analysis can have any parameter type, and some parameters might accept
#' multiple values.
#' @param Permissions A structure that describes the principals and the resource-level
#' permissions on an analysis. You can use the `Permissions` structure to
#' grant permissions by providing a list of Identity and Access Management
#' (IAM) action information for each principal listed by Amazon Resource
#' Name (ARN).
#' 
#' To specify no permissions, omit `Permissions`.
#' @param SourceEntity &#91;required&#93; A source entity to use for the analysis that you're creating. This
#' metadata structure contains details that describe a source template and
#' one or more datasets.
#' @param ThemeArn The ARN for the theme to apply to the analysis that you're creating. To
#' see the theme in the Amazon QuickSight console, make sure that you have
#' access to it.
#' @param Tags Contains a map of the key-value pairs for the resource tag or tags
#' assigned to the analysis.
#'
#' @keywords internal
#'
#' @rdname quicksight_create_analysis
quicksight_create_analysis <- function(AwsAccountId, AnalysisId, Name, Parameters = NULL, Permissions = NULL, SourceEntity, ThemeArn = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateAnalysis",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
    paginator = list()
  )
  input <- .quicksight$create_analysis_input(AwsAccountId = AwsAccountId, AnalysisId = AnalysisId, Name = Name, Parameters = Parameters, Permissions = Permissions, SourceEntity = SourceEntity, ThemeArn = ThemeArn, Tags = Tags)
  output <- .quicksight$create_analysis_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_analysis <- quicksight_create_analysis

#' Creates a dashboard from a template
#'
#' @description
#' Creates a dashboard from a template. To first create a template, see the [`create_template`][quicksight_create_template] API operation.
#'
#' See [https://paws-r.github.io/docs/quicksight/create_dashboard.html](https://paws-r.github.io/docs/quicksight/create_dashboard.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account where you want to create the
#' dashboard.
#' @param DashboardId &#91;required&#93; The ID for the dashboard, also added to the IAM policy.
#' @param Name &#91;required&#93; The display name of the dashboard.
#' @param Parameters The parameters for the creation of the dashboard, which you want to use
#' to override the default settings. A dashboard can have any type of
#' parameters, and some parameters might accept multiple values.
#' @param Permissions A structure that contains the permissions of the dashboard. You can use
#' this structure for granting permissions by providing a list of IAM
#' action information for each principal ARN.
#' 
#' To specify no permissions, omit the permissions list.
#' @param SourceEntity &#91;required&#93; The entity that you are using as a source when you create the dashboard.
#' In `SourceEntity`, you specify the type of object you're using as
#' source. You can only create a dashboard from a template, so you use a
#' `SourceTemplate` entity. If you need to create a dashboard from an
#' analysis, first convert the analysis to a template by using the
#' [`create_template`][quicksight_create_template] API operation. For
#' `SourceTemplate`, specify the Amazon Resource Name (ARN) of the source
#' template. The `SourceTemplate`ARN can contain any Amazon Web Services
#' account and any Amazon QuickSight-supported Amazon Web Services Region.
#' 
#' Use the `DataSetReferences` entity within `SourceTemplate` to list the
#' replacement datasets for the placeholders listed in the original. The
#' schema in each dataset must match its placeholder.
#' @param Tags Contains a map of the key-value pairs for the resource tag or tags
#' assigned to the dashboard.
#' @param VersionDescription A description for the first version of the dashboard being created.
#' @param DashboardPublishOptions Options for publishing the dashboard when you create it:
#' 
#' -   `AvailabilityStatus` for `AdHocFilteringOption` - This status can be
#'     either `ENABLED` or `DISABLED`. When this is set to `DISABLED`,
#'     Amazon QuickSight disables the left filter pane on the published
#'     dashboard, which can be used for ad hoc (one-time) filtering. This
#'     option is `ENABLED` by default.
#' 
#' -   `AvailabilityStatus` for `ExportToCSVOption` - This status can be
#'     either `ENABLED` or `DISABLED`. The visual option to export data to
#'     .CSV format isn't enabled when this is set to `DISABLED`. This
#'     option is `ENABLED` by default.
#' 
#' -   `VisibilityState` for `SheetControlsOption` - This visibility state
#'     can be either `COLLAPSED` or `EXPANDED`. This option is `COLLAPSED`
#'     by default.
#' @param ThemeArn The Amazon Resource Name (ARN) of the theme that is being used for this
#' dashboard. If you add a value for this field, it overrides the value
#' that is used in the source entity. The theme ARN must exist in the same
#' Amazon Web Services account where you create the dashboard.
#'
#' @keywords internal
#'
#' @rdname quicksight_create_dashboard
quicksight_create_dashboard <- function(AwsAccountId, DashboardId, Name, Parameters = NULL, Permissions = NULL, SourceEntity, Tags = NULL, VersionDescription = NULL, DashboardPublishOptions = NULL, ThemeArn = NULL) {
  op <- new_operation(
    name = "CreateDashboard",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
    paginator = list()
  )
  input <- .quicksight$create_dashboard_input(AwsAccountId = AwsAccountId, DashboardId = DashboardId, Name = Name, Parameters = Parameters, Permissions = Permissions, SourceEntity = SourceEntity, Tags = Tags, VersionDescription = VersionDescription, DashboardPublishOptions = DashboardPublishOptions, ThemeArn = ThemeArn)
  output <- .quicksight$create_dashboard_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_dashboard <- quicksight_create_dashboard

#' Creates a dataset
#'
#' @description
#' Creates a dataset. This operation doesn't support datasets that include uploaded files as a source.
#'
#' See [https://paws-r.github.io/docs/quicksight/create_data_set.html](https://paws-r.github.io/docs/quicksight/create_data_set.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param DataSetId &#91;required&#93; An ID for the dataset that you want to create. This ID is unique per
#' Amazon Web Services Region for each Amazon Web Services account.
#' @param Name &#91;required&#93; The display name for the dataset.
#' @param PhysicalTableMap &#91;required&#93; Declares the physical tables that are available in the underlying data
#' sources.
#' @param LogicalTableMap Configures the combination and transformation of the data from the
#' physical tables.
#' @param ImportMode &#91;required&#93; Indicates whether you want to import the data into SPICE.
#' @param ColumnGroups Groupings of columns that work together in certain Amazon QuickSight
#' features. Currently, only geospatial hierarchy is supported.
#' @param FieldFolders The folder that contains fields and nested subfolders for your dataset.
#' @param Permissions A list of resource permissions on the dataset.
#' @param RowLevelPermissionDataSet The row-level security configuration for the data that you want to
#' create.
#' @param RowLevelPermissionTagConfiguration The configuration of tags on a dataset to set row-level security.
#' Row-level security tags are currently supported for anonymous embedding
#' only.
#' @param ColumnLevelPermissionRules A set of one or more definitions of a ` ColumnLevelPermissionRule `.
#' @param Tags Contains a map of the key-value pairs for the resource tag or tags
#' assigned to the dataset.
#' @param DataSetUsageConfiguration 
#'
#' @keywords internal
#'
#' @rdname quicksight_create_data_set
quicksight_create_data_set <- function(AwsAccountId, DataSetId, Name, PhysicalTableMap, LogicalTableMap = NULL, ImportMode, ColumnGroups = NULL, FieldFolders = NULL, Permissions = NULL, RowLevelPermissionDataSet = NULL, RowLevelPermissionTagConfiguration = NULL, ColumnLevelPermissionRules = NULL, Tags = NULL, DataSetUsageConfiguration = NULL) {
  op <- new_operation(
    name = "CreateDataSet",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/data-sets",
    paginator = list()
  )
  input <- .quicksight$create_data_set_input(AwsAccountId = AwsAccountId, DataSetId = DataSetId, Name = Name, PhysicalTableMap = PhysicalTableMap, LogicalTableMap = LogicalTableMap, ImportMode = ImportMode, ColumnGroups = ColumnGroups, FieldFolders = FieldFolders, Permissions = Permissions, RowLevelPermissionDataSet = RowLevelPermissionDataSet, RowLevelPermissionTagConfiguration = RowLevelPermissionTagConfiguration, ColumnLevelPermissionRules = ColumnLevelPermissionRules, Tags = Tags, DataSetUsageConfiguration = DataSetUsageConfiguration)
  output <- .quicksight$create_data_set_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_data_set <- quicksight_create_data_set

#' Creates a data source
#'
#' @description
#' Creates a data source.
#'
#' See [https://paws-r.github.io/docs/quicksight/create_data_source.html](https://paws-r.github.io/docs/quicksight/create_data_source.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param DataSourceId &#91;required&#93; An ID for the data source. This ID is unique per Amazon Web Services
#' Region for each Amazon Web Services account.
#' @param Name &#91;required&#93; A display name for the data source.
#' @param Type &#91;required&#93; The type of the data source. To return a list of all data sources, use
#' [`list_data_sources`][quicksight_list_data_sources].
#' 
#' Use `AMAZON_ELASTICSEARCH` for Amazon OpenSearch Service.
#' @param DataSourceParameters The parameters that Amazon QuickSight uses to connect to your underlying
#' source.
#' @param Credentials The credentials Amazon QuickSight that uses to connect to your
#' underlying source. Currently, only credentials based on user name and
#' password are supported.
#' @param Permissions A list of resource permissions on the data source.
#' @param VpcConnectionProperties Use this parameter only when you want Amazon QuickSight to use a VPC
#' connection when connecting to your underlying source.
#' @param SslProperties Secure Socket Layer (SSL) properties that apply when Amazon QuickSight
#' connects to your underlying source.
#' @param Tags Contains a map of the key-value pairs for the resource tag or tags
#' assigned to the data source.
#'
#' @keywords internal
#'
#' @rdname quicksight_create_data_source
quicksight_create_data_source <- function(AwsAccountId, DataSourceId, Name, Type, DataSourceParameters = NULL, Credentials = NULL, Permissions = NULL, VpcConnectionProperties = NULL, SslProperties = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDataSource",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/data-sources",
    paginator = list()
  )
  input <- .quicksight$create_data_source_input(AwsAccountId = AwsAccountId, DataSourceId = DataSourceId, Name = Name, Type = Type, DataSourceParameters = DataSourceParameters, Credentials = Credentials, Permissions = Permissions, VpcConnectionProperties = VpcConnectionProperties, SslProperties = SslProperties, Tags = Tags)
  output <- .quicksight$create_data_source_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_data_source <- quicksight_create_data_source

#' Creates an empty shared folder
#'
#' @description
#' Creates an empty shared folder.
#'
#' See [https://paws-r.github.io/docs/quicksight/create_folder.html](https://paws-r.github.io/docs/quicksight/create_folder.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account where you want to create the
#' folder.
#' @param FolderId &#91;required&#93; The ID of the folder.
#' @param Name The name of the folder.
#' @param FolderType The type of folder. By default, `folderType` is `SHARED`.
#' @param ParentFolderArn The Amazon Resource Name (ARN) for the parent folder.
#' 
#' `ParentFolderArn` can be null. An empty `parentFolderArn` creates a
#' root-level folder.
#' @param Permissions A structure that describes the principals and the resource-level
#' permissions of a folder.
#' 
#' To specify no permissions, omit `Permissions`.
#' @param Tags Tags for the folder.
#'
#' @keywords internal
#'
#' @rdname quicksight_create_folder
quicksight_create_folder <- function(AwsAccountId, FolderId, Name = NULL, FolderType = NULL, ParentFolderArn = NULL, Permissions = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateFolder",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/folders/{FolderId}",
    paginator = list()
  )
  input <- .quicksight$create_folder_input(AwsAccountId = AwsAccountId, FolderId = FolderId, Name = Name, FolderType = FolderType, ParentFolderArn = ParentFolderArn, Permissions = Permissions, Tags = Tags)
  output <- .quicksight$create_folder_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_folder <- quicksight_create_folder

#' Adds an asset, such as a dashboard, analysis, or dataset into a folder
#'
#' @description
#' Adds an asset, such as a dashboard, analysis, or dataset into a folder.
#'
#' See [https://paws-r.github.io/docs/quicksight/create_folder_membership.html](https://paws-r.github.io/docs/quicksight/create_folder_membership.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the folder.
#' @param FolderId &#91;required&#93; The ID of the folder.
#' @param MemberId &#91;required&#93; The ID of the asset (the dashboard, analysis, or dataset).
#' @param MemberType &#91;required&#93; The type of the member, including `DASHBOARD`, `ANALYSIS`, and
#' `DATASET`.
#'
#' @keywords internal
#'
#' @rdname quicksight_create_folder_membership
quicksight_create_folder_membership <- function(AwsAccountId, FolderId, MemberId, MemberType) {
  op <- new_operation(
    name = "CreateFolderMembership",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/folders/{FolderId}/members/{MemberType}/{MemberId}",
    paginator = list()
  )
  input <- .quicksight$create_folder_membership_input(AwsAccountId = AwsAccountId, FolderId = FolderId, MemberId = MemberId, MemberType = MemberType)
  output <- .quicksight$create_folder_membership_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_folder_membership <- quicksight_create_folder_membership

#' Use the CreateGroup operation to create a group in Amazon QuickSight
#'
#' @description
#' Use the [`create_group`][quicksight_create_group] operation to create a group in Amazon QuickSight. You can create up to 10,000 groups in a namespace. If you want to create more than 10,000 groups in a namespace, contact AWS Support.
#'
#' See [https://paws-r.github.io/docs/quicksight/create_group.html](https://paws-r.github.io/docs/quicksight/create_group.html) for full documentation.
#'
#' @param GroupName &#91;required&#93; A name for the group that you want to create.
#' @param Description A description for the group that you want to create.
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the group is in.
#' Currently, you use the ID for the Amazon Web Services account that
#' contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace that you want the group to be a part of.
#'
#' @keywords internal
#'
#' @rdname quicksight_create_group
quicksight_create_group <- function(GroupName, Description = NULL, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "CreateGroup",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups",
    paginator = list()
  )
  input <- .quicksight$create_group_input(GroupName = GroupName, Description = Description, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$create_group_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_group <- quicksight_create_group

#' Adds an Amazon QuickSight user to an Amazon QuickSight group
#'
#' @description
#' Adds an Amazon QuickSight user to an Amazon QuickSight group.
#'
#' See [https://paws-r.github.io/docs/quicksight/create_group_membership.html](https://paws-r.github.io/docs/quicksight/create_group_membership.html) for full documentation.
#'
#' @param MemberName &#91;required&#93; The name of the user that you want to add to the group membership.
#' @param GroupName &#91;required&#93; The name of the group that you want to add the user to.
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the group is in.
#' Currently, you use the ID for the Amazon Web Services account that
#' contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace that you want the user to be a part of.
#'
#' @keywords internal
#'
#' @rdname quicksight_create_group_membership
quicksight_create_group_membership <- function(MemberName, GroupName, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "CreateGroupMembership",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
    paginator = list()
  )
  input <- .quicksight$create_group_membership_input(MemberName = MemberName, GroupName = GroupName, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$create_group_membership_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_group_membership <- quicksight_create_group_membership

#' Creates an assignment with one specified IAM policy, identified by its
#' Amazon Resource Name (ARN)
#'
#' @description
#' Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy assignment is attached to the specified groups or users of Amazon QuickSight. Assignment names are unique per Amazon Web Services account. To avoid overwriting rules in other namespaces, use assignment names that are unique.
#'
#' See [https://paws-r.github.io/docs/quicksight/create_iam_policy_assignment.html](https://paws-r.github.io/docs/quicksight/create_iam_policy_assignment.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account where you want to assign an
#' IAM policy to Amazon QuickSight users or groups.
#' @param AssignmentName &#91;required&#93; The name of the assignment, also called a rule. It must be unique within
#' an Amazon Web Services account.
#' @param AssignmentStatus &#91;required&#93; The status of the assignment. Possible values are as follows:
#' 
#' -   `ENABLED` - Anything specified in this assignment is used when
#'     creating the data source.
#' 
#' -   `DISABLED` - This assignment isn't used when creating the data
#'     source.
#' 
#' -   `DRAFT` - This assignment is an unfinished draft and isn't used when
#'     creating the data source.
#' @param PolicyArn The ARN for the IAM policy to apply to the Amazon QuickSight users and
#' groups specified in this assignment.
#' @param Identities The Amazon QuickSight users, groups, or both that you want to assign the
#' policy to.
#' @param Namespace &#91;required&#93; The namespace that contains the assignment.
#'
#' @keywords internal
#'
#' @rdname quicksight_create_iam_policy_assignment
quicksight_create_iam_policy_assignment <- function(AwsAccountId, AssignmentName, AssignmentStatus, PolicyArn = NULL, Identities = NULL, Namespace) {
  op <- new_operation(
    name = "CreateIAMPolicyAssignment",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/",
    paginator = list()
  )
  input <- .quicksight$create_iam_policy_assignment_input(AwsAccountId = AwsAccountId, AssignmentName = AssignmentName, AssignmentStatus = AssignmentStatus, PolicyArn = PolicyArn, Identities = Identities, Namespace = Namespace)
  output <- .quicksight$create_iam_policy_assignment_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_iam_policy_assignment <- quicksight_create_iam_policy_assignment

#' Creates and starts a new SPICE ingestion for a dataset
#'
#' @description
#' Creates and starts a new SPICE ingestion for a dataset. You can manually refresh datasets in an Enterprise edition account 32 times in a 24-hour period. You can manually refresh datasets in a Standard edition account 8 times in a 24-hour period. Each 24-hour period is measured starting 24 hours before the current date and time.
#'
#' See [https://paws-r.github.io/docs/quicksight/create_ingestion.html](https://paws-r.github.io/docs/quicksight/create_ingestion.html) for full documentation.
#'
#' @param DataSetId &#91;required&#93; The ID of the dataset used in the ingestion.
#' @param IngestionId &#91;required&#93; An ID for the ingestion.
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param IngestionType The type of ingestion that you want to create.
#'
#' @keywords internal
#'
#' @rdname quicksight_create_ingestion
quicksight_create_ingestion <- function(DataSetId, IngestionId, AwsAccountId, IngestionType = NULL) {
  op <- new_operation(
    name = "CreateIngestion",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
    paginator = list()
  )
  input <- .quicksight$create_ingestion_input(DataSetId = DataSetId, IngestionId = IngestionId, AwsAccountId = AwsAccountId, IngestionType = IngestionType)
  output <- .quicksight$create_ingestion_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_ingestion <- quicksight_create_ingestion

#' (Enterprise edition only) Creates a new namespace for you to use with
#' Amazon QuickSight
#'
#' @description
#' (Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight.
#'
#' See [https://paws-r.github.io/docs/quicksight/create_namespace.html](https://paws-r.github.io/docs/quicksight/create_namespace.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that you want to create the
#' Amazon QuickSight namespace in.
#' @param Namespace &#91;required&#93; The name that you want to use to describe the new namespace.
#' @param IdentityStore &#91;required&#93; Specifies the type of your user identity directory. Currently, this
#' supports users with an identity type of `QUICKSIGHT`.
#' @param Tags The tags that you want to associate with the namespace that you're
#' creating.
#'
#' @keywords internal
#'
#' @rdname quicksight_create_namespace
quicksight_create_namespace <- function(AwsAccountId, Namespace, IdentityStore, Tags = NULL) {
  op <- new_operation(
    name = "CreateNamespace",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}",
    paginator = list()
  )
  input <- .quicksight$create_namespace_input(AwsAccountId = AwsAccountId, Namespace = Namespace, IdentityStore = IdentityStore, Tags = Tags)
  output <- .quicksight$create_namespace_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_namespace <- quicksight_create_namespace

#' Creates a template from an existing Amazon QuickSight analysis or
#' template
#'
#' @description
#' Creates a template from an existing Amazon QuickSight analysis or template. You can use the resulting template to create a dashboard.
#'
#' See [https://paws-r.github.io/docs/quicksight/create_template.html](https://paws-r.github.io/docs/quicksight/create_template.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the group is in. You use
#' the ID for the Amazon Web Services account that contains your Amazon
#' QuickSight account.
#' @param TemplateId &#91;required&#93; An ID for the template that you want to create. This template is unique
#' per Amazon Web Services Region; in each Amazon Web Services account.
#' @param Name A display name for the template.
#' @param Permissions A list of resource permissions to be set on the template.
#' @param SourceEntity &#91;required&#93; The entity that you are using as a source when you create the template.
#' In `SourceEntity`, you specify the type of object you're using as
#' source: `SourceTemplate` for a template or `SourceAnalysis` for an
#' analysis. Both of these require an Amazon Resource Name (ARN). For
#' `SourceTemplate`, specify the ARN of the source template. For
#' `SourceAnalysis`, specify the ARN of the source analysis. The
#' `SourceTemplate` ARN can contain any Amazon Web Services account and any
#' Amazon QuickSight-supported Amazon Web Services Region.
#' 
#' Use the `DataSetReferences` entity within `SourceTemplate` or
#' `SourceAnalysis` to list the replacement datasets for the placeholders
#' listed in the original. The schema in each dataset must match its
#' placeholder.
#' @param Tags Contains a map of the key-value pairs for the resource tag or tags
#' assigned to the resource.
#' @param VersionDescription A description of the current template version being created. This API
#' operation creates the first version of the template. Every time
#' [`update_template`][quicksight_update_template] is called, a new version
#' is created. Each version of the template maintains a description of the
#' version in the `VersionDescription` field.
#'
#' @keywords internal
#'
#' @rdname quicksight_create_template
quicksight_create_template <- function(AwsAccountId, TemplateId, Name = NULL, Permissions = NULL, SourceEntity, Tags = NULL, VersionDescription = NULL) {
  op <- new_operation(
    name = "CreateTemplate",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/templates/{TemplateId}",
    paginator = list()
  )
  input <- .quicksight$create_template_input(AwsAccountId = AwsAccountId, TemplateId = TemplateId, Name = Name, Permissions = Permissions, SourceEntity = SourceEntity, Tags = Tags, VersionDescription = VersionDescription)
  output <- .quicksight$create_template_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_template <- quicksight_create_template

#' Creates a template alias for a template
#'
#' @description
#' Creates a template alias for a template.
#'
#' See [https://paws-r.github.io/docs/quicksight/create_template_alias.html](https://paws-r.github.io/docs/quicksight/create_template_alias.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the template
#' that you creating an alias for.
#' @param TemplateId &#91;required&#93; An ID for the template.
#' @param AliasName &#91;required&#93; The name that you want to give to the template alias that you're
#' creating. Don't start the alias name with the `$` character. Alias names
#' that start with `$` are reserved by Amazon QuickSight.
#' @param TemplateVersionNumber &#91;required&#93; The version number of the template.
#'
#' @keywords internal
#'
#' @rdname quicksight_create_template_alias
quicksight_create_template_alias <- function(AwsAccountId, TemplateId, AliasName, TemplateVersionNumber) {
  op <- new_operation(
    name = "CreateTemplateAlias",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
    paginator = list()
  )
  input <- .quicksight$create_template_alias_input(AwsAccountId = AwsAccountId, TemplateId = TemplateId, AliasName = AliasName, TemplateVersionNumber = TemplateVersionNumber)
  output <- .quicksight$create_template_alias_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_template_alias <- quicksight_create_template_alias

#' Creates a theme
#'
#' @description
#' Creates a theme.
#'
#' See [https://paws-r.github.io/docs/quicksight/create_theme.html](https://paws-r.github.io/docs/quicksight/create_theme.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account where you want to store the
#' new theme.
#' @param ThemeId &#91;required&#93; An ID for the theme that you want to create. The theme ID is unique per
#' Amazon Web Services Region in each Amazon Web Services account.
#' @param Name &#91;required&#93; A display name for the theme.
#' @param BaseThemeId &#91;required&#93; The ID of the theme that a custom theme will inherit from. All themes
#' inherit from one of the starting themes defined by Amazon QuickSight.
#' For a list of the starting themes, use
#' [`list_themes`][quicksight_list_themes] or choose **Themes** from within
#' an analysis.
#' @param VersionDescription A description of the first version of the theme that you're creating.
#' Every time [`update_theme`][quicksight_update_theme] is called, a new
#' version is created. Each version of the theme has a description of the
#' version in the `VersionDescription` field.
#' @param Configuration &#91;required&#93; The theme configuration, which contains the theme display properties.
#' @param Permissions A valid grouping of resource permissions to apply to the new theme.
#' @param Tags A map of the key-value pairs for the resource tag or tags that you want
#' to add to the resource.
#'
#' @keywords internal
#'
#' @rdname quicksight_create_theme
quicksight_create_theme <- function(AwsAccountId, ThemeId, Name, BaseThemeId, VersionDescription = NULL, Configuration, Permissions = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateTheme",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/themes/{ThemeId}",
    paginator = list()
  )
  input <- .quicksight$create_theme_input(AwsAccountId = AwsAccountId, ThemeId = ThemeId, Name = Name, BaseThemeId = BaseThemeId, VersionDescription = VersionDescription, Configuration = Configuration, Permissions = Permissions, Tags = Tags)
  output <- .quicksight$create_theme_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_theme <- quicksight_create_theme

#' Creates a theme alias for a theme
#'
#' @description
#' Creates a theme alias for a theme.
#'
#' See [https://paws-r.github.io/docs/quicksight/create_theme_alias.html](https://paws-r.github.io/docs/quicksight/create_theme_alias.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the theme for
#' the new theme alias.
#' @param ThemeId &#91;required&#93; An ID for the theme alias.
#' @param AliasName &#91;required&#93; The name that you want to give to the theme alias that you are creating.
#' The alias name can't begin with a `$`. Alias names that start with `$`
#' are reserved by Amazon QuickSight.
#' @param ThemeVersionNumber &#91;required&#93; The version number of the theme.
#'
#' @keywords internal
#'
#' @rdname quicksight_create_theme_alias
quicksight_create_theme_alias <- function(AwsAccountId, ThemeId, AliasName, ThemeVersionNumber) {
  op <- new_operation(
    name = "CreateThemeAlias",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
    paginator = list()
  )
  input <- .quicksight$create_theme_alias_input(AwsAccountId = AwsAccountId, ThemeId = ThemeId, AliasName = AliasName, ThemeVersionNumber = ThemeVersionNumber)
  output <- .quicksight$create_theme_alias_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_theme_alias <- quicksight_create_theme_alias

#' Deletes all Amazon QuickSight customizations in this Amazon Web Services
#' Region for the specified Amazon Web Services account and Amazon
#' QuickSight namespace
#'
#' @description
#' Deletes all Amazon QuickSight customizations in this Amazon Web Services Region for the specified Amazon Web Services account and Amazon QuickSight namespace.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_account_customization.html](https://paws-r.github.io/docs/quicksight/delete_account_customization.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that you want to delete
#' Amazon QuickSight customizations from in this Amazon Web Services
#' Region.
#' @param Namespace The Amazon QuickSight namespace that you're deleting the customizations
#' from.
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_account_customization
quicksight_delete_account_customization <- function(AwsAccountId, Namespace = NULL) {
  op <- new_operation(
    name = "DeleteAccountCustomization",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/customizations",
    paginator = list()
  )
  input <- .quicksight$delete_account_customization_input(AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$delete_account_customization_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_account_customization <- quicksight_delete_account_customization

#' Deletes an analysis from Amazon QuickSight
#'
#' @description
#' Deletes an analysis from Amazon QuickSight. You can optionally include a recovery window during which you can restore the analysis. If you don't specify a recovery window value, the operation defaults to 30 days. Amazon QuickSight attaches a `DeletionTime` stamp to the response that specifies the end of the recovery window. At the end of the recovery window, Amazon QuickSight deletes the analysis permanently.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_analysis.html](https://paws-r.github.io/docs/quicksight/delete_analysis.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account where you want to delete an
#' analysis.
#' @param AnalysisId &#91;required&#93; The ID of the analysis that you're deleting.
#' @param RecoveryWindowInDays A value that specifies the number of days that Amazon QuickSight waits
#' before it deletes the analysis. You can't use this parameter with the
#' `ForceDeleteWithoutRecovery` option in the same API call. The default
#' value is 30.
#' @param ForceDeleteWithoutRecovery This option defaults to the value `NoForceDeleteWithoutRecovery`. To
#' immediately delete the analysis, add the `ForceDeleteWithoutRecovery`
#' option. You can't restore an analysis after it's deleted.
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_analysis
quicksight_delete_analysis <- function(AwsAccountId, AnalysisId, RecoveryWindowInDays = NULL, ForceDeleteWithoutRecovery = NULL) {
  op <- new_operation(
    name = "DeleteAnalysis",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
    paginator = list()
  )
  input <- .quicksight$delete_analysis_input(AwsAccountId = AwsAccountId, AnalysisId = AnalysisId, RecoveryWindowInDays = RecoveryWindowInDays, ForceDeleteWithoutRecovery = ForceDeleteWithoutRecovery)
  output <- .quicksight$delete_analysis_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_analysis <- quicksight_delete_analysis

#' Deletes a dashboard
#'
#' @description
#' Deletes a dashboard.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_dashboard.html](https://paws-r.github.io/docs/quicksight/delete_dashboard.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the dashboard
#' that you're deleting.
#' @param DashboardId &#91;required&#93; The ID for the dashboard.
#' @param VersionNumber The version number of the dashboard. If the version number property is
#' provided, only the specified version of the dashboard is deleted.
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_dashboard
quicksight_delete_dashboard <- function(AwsAccountId, DashboardId, VersionNumber = NULL) {
  op <- new_operation(
    name = "DeleteDashboard",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
    paginator = list()
  )
  input <- .quicksight$delete_dashboard_input(AwsAccountId = AwsAccountId, DashboardId = DashboardId, VersionNumber = VersionNumber)
  output <- .quicksight$delete_dashboard_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_dashboard <- quicksight_delete_dashboard

#' Deletes a dataset
#'
#' @description
#' Deletes a dataset.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_data_set.html](https://paws-r.github.io/docs/quicksight/delete_data_set.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param DataSetId &#91;required&#93; The ID for the dataset that you want to create. This ID is unique per
#' Amazon Web Services Region for each Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_data_set
quicksight_delete_data_set <- function(AwsAccountId, DataSetId) {
  op <- new_operation(
    name = "DeleteDataSet",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
    paginator = list()
  )
  input <- .quicksight$delete_data_set_input(AwsAccountId = AwsAccountId, DataSetId = DataSetId)
  output <- .quicksight$delete_data_set_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_data_set <- quicksight_delete_data_set

#' Deletes the data source permanently
#'
#' @description
#' Deletes the data source permanently. This operation breaks all the datasets that reference the deleted data source.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_data_source.html](https://paws-r.github.io/docs/quicksight/delete_data_source.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param DataSourceId &#91;required&#93; The ID of the data source. This ID is unique per Amazon Web Services
#' Region for each Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_data_source
quicksight_delete_data_source <- function(AwsAccountId, DataSourceId) {
  op <- new_operation(
    name = "DeleteDataSource",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
    paginator = list()
  )
  input <- .quicksight$delete_data_source_input(AwsAccountId = AwsAccountId, DataSourceId = DataSourceId)
  output <- .quicksight$delete_data_source_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_data_source <- quicksight_delete_data_source

#' Deletes an empty folder
#'
#' @description
#' Deletes an empty folder.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_folder.html](https://paws-r.github.io/docs/quicksight/delete_folder.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the folder.
#' @param FolderId &#91;required&#93; The ID of the folder.
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_folder
quicksight_delete_folder <- function(AwsAccountId, FolderId) {
  op <- new_operation(
    name = "DeleteFolder",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/folders/{FolderId}",
    paginator = list()
  )
  input <- .quicksight$delete_folder_input(AwsAccountId = AwsAccountId, FolderId = FolderId)
  output <- .quicksight$delete_folder_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_folder <- quicksight_delete_folder

#' Removes an asset, such as a dashboard, analysis, or dataset, from a
#' folder
#'
#' @description
#' Removes an asset, such as a dashboard, analysis, or dataset, from a folder.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_folder_membership.html](https://paws-r.github.io/docs/quicksight/delete_folder_membership.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the folder.
#' @param FolderId &#91;required&#93; The Folder ID.
#' @param MemberId &#91;required&#93; The ID of the asset (the dashboard, analysis, or dataset) that you want
#' to delete.
#' @param MemberType &#91;required&#93; The type of the member, including `DASHBOARD`, `ANALYSIS`, and `DATASET`
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_folder_membership
quicksight_delete_folder_membership <- function(AwsAccountId, FolderId, MemberId, MemberType) {
  op <- new_operation(
    name = "DeleteFolderMembership",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/folders/{FolderId}/members/{MemberType}/{MemberId}",
    paginator = list()
  )
  input <- .quicksight$delete_folder_membership_input(AwsAccountId = AwsAccountId, FolderId = FolderId, MemberId = MemberId, MemberType = MemberType)
  output <- .quicksight$delete_folder_membership_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_folder_membership <- quicksight_delete_folder_membership

#' Removes a user group from Amazon QuickSight
#'
#' @description
#' Removes a user group from Amazon QuickSight.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_group.html](https://paws-r.github.io/docs/quicksight/delete_group.html) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name of the group that you want to delete.
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the group is in.
#' Currently, you use the ID for the Amazon Web Services account that
#' contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace of the group that you want to delete.
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_group
quicksight_delete_group <- function(GroupName, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "DeleteGroup",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
    paginator = list()
  )
  input <- .quicksight$delete_group_input(GroupName = GroupName, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$delete_group_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_group <- quicksight_delete_group

#' Removes a user from a group so that the user is no longer a member of
#' the group
#'
#' @description
#' Removes a user from a group so that the user is no longer a member of the group.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_group_membership.html](https://paws-r.github.io/docs/quicksight/delete_group_membership.html) for full documentation.
#'
#' @param MemberName &#91;required&#93; The name of the user that you want to delete from the group membership.
#' @param GroupName &#91;required&#93; The name of the group that you want to delete the user from.
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the group is in.
#' Currently, you use the ID for the Amazon Web Services account that
#' contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace of the group that you want to remove a user from.
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_group_membership
quicksight_delete_group_membership <- function(MemberName, GroupName, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "DeleteGroupMembership",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
    paginator = list()
  )
  input <- .quicksight$delete_group_membership_input(MemberName = MemberName, GroupName = GroupName, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$delete_group_membership_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_group_membership <- quicksight_delete_group_membership

#' Deletes an existing IAM policy assignment
#'
#' @description
#' Deletes an existing IAM policy assignment.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_iam_policy_assignment.html](https://paws-r.github.io/docs/quicksight/delete_iam_policy_assignment.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID where you want to delete the IAM
#' policy assignment.
#' @param AssignmentName &#91;required&#93; The name of the assignment.
#' @param Namespace &#91;required&#93; The namespace that contains the assignment.
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_iam_policy_assignment
quicksight_delete_iam_policy_assignment <- function(AwsAccountId, AssignmentName, Namespace) {
  op <- new_operation(
    name = "DeleteIAMPolicyAssignment",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/namespace/{Namespace}/iam-policy-assignments/{AssignmentName}",
    paginator = list()
  )
  input <- .quicksight$delete_iam_policy_assignment_input(AwsAccountId = AwsAccountId, AssignmentName = AssignmentName, Namespace = Namespace)
  output <- .quicksight$delete_iam_policy_assignment_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_iam_policy_assignment <- quicksight_delete_iam_policy_assignment

#' Deletes a namespace and the users and groups that are associated with
#' the namespace
#'
#' @description
#' Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these assets, you use the API operations for the relevant asset.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_namespace.html](https://paws-r.github.io/docs/quicksight/delete_namespace.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that you want to delete the
#' Amazon QuickSight namespace from.
#' @param Namespace &#91;required&#93; The namespace that you want to delete.
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_namespace
quicksight_delete_namespace <- function(AwsAccountId, Namespace) {
  op <- new_operation(
    name = "DeleteNamespace",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}",
    paginator = list()
  )
  input <- .quicksight$delete_namespace_input(AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$delete_namespace_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_namespace <- quicksight_delete_namespace

#' Deletes a template
#'
#' @description
#' Deletes a template.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_template.html](https://paws-r.github.io/docs/quicksight/delete_template.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the template
#' that you're deleting.
#' @param TemplateId &#91;required&#93; An ID for the template you want to delete.
#' @param VersionNumber Specifies the version of the template that you want to delete. If you
#' don't provide a version number,
#' [`delete_template`][quicksight_delete_template] deletes all versions of
#' the template.
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_template
quicksight_delete_template <- function(AwsAccountId, TemplateId, VersionNumber = NULL) {
  op <- new_operation(
    name = "DeleteTemplate",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/templates/{TemplateId}",
    paginator = list()
  )
  input <- .quicksight$delete_template_input(AwsAccountId = AwsAccountId, TemplateId = TemplateId, VersionNumber = VersionNumber)
  output <- .quicksight$delete_template_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_template <- quicksight_delete_template

#' Deletes the item that the specified template alias points to
#'
#' @description
#' Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the version of the template that the alias points to.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_template_alias.html](https://paws-r.github.io/docs/quicksight/delete_template_alias.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the item to
#' delete.
#' @param TemplateId &#91;required&#93; The ID for the template that the specified alias is for.
#' @param AliasName &#91;required&#93; The name for the template alias. To delete a specific alias, you delete
#' the version that the alias points to. You can specify the alias name, or
#' specify the latest version of the template by providing the keyword
#' `$LATEST` in the `AliasName` parameter.
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_template_alias
quicksight_delete_template_alias <- function(AwsAccountId, TemplateId, AliasName) {
  op <- new_operation(
    name = "DeleteTemplateAlias",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
    paginator = list()
  )
  input <- .quicksight$delete_template_alias_input(AwsAccountId = AwsAccountId, TemplateId = TemplateId, AliasName = AliasName)
  output <- .quicksight$delete_template_alias_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_template_alias <- quicksight_delete_template_alias

#' Deletes a theme
#'
#' @description
#' Deletes a theme.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_theme.html](https://paws-r.github.io/docs/quicksight/delete_theme.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the theme that
#' you're deleting.
#' @param ThemeId &#91;required&#93; An ID for the theme that you want to delete.
#' @param VersionNumber The version of the theme that you want to delete.
#' 
#' **Note:** If you don't provide a version number, you're using this call
#' to [`delete_theme`][quicksight_delete_theme] to delete all versions of
#' the theme.
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_theme
quicksight_delete_theme <- function(AwsAccountId, ThemeId, VersionNumber = NULL) {
  op <- new_operation(
    name = "DeleteTheme",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/themes/{ThemeId}",
    paginator = list()
  )
  input <- .quicksight$delete_theme_input(AwsAccountId = AwsAccountId, ThemeId = ThemeId, VersionNumber = VersionNumber)
  output <- .quicksight$delete_theme_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_theme <- quicksight_delete_theme

#' Deletes the version of the theme that the specified theme alias points
#' to
#'
#' @description
#' Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you delete the version of the theme that the alias points to.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_theme_alias.html](https://paws-r.github.io/docs/quicksight/delete_theme_alias.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the theme alias
#' to delete.
#' @param ThemeId &#91;required&#93; The ID for the theme that the specified alias is for.
#' @param AliasName &#91;required&#93; The unique name for the theme alias to delete.
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_theme_alias
quicksight_delete_theme_alias <- function(AwsAccountId, ThemeId, AliasName) {
  op <- new_operation(
    name = "DeleteThemeAlias",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
    paginator = list()
  )
  input <- .quicksight$delete_theme_alias_input(AwsAccountId = AwsAccountId, ThemeId = ThemeId, AliasName = AliasName)
  output <- .quicksight$delete_theme_alias_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_theme_alias <- quicksight_delete_theme_alias

#' Deletes the Amazon QuickSight user that is associated with the identity
#' of the Identity and Access Management (IAM) user or role that's making
#' the call
#'
#' @description
#' Deletes the Amazon QuickSight user that is associated with the identity of the Identity and Access Management (IAM) user or role that's making the call. The IAM user isn't deleted as a result of this call.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_user.html](https://paws-r.github.io/docs/quicksight/delete_user.html) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the user that you want to delete.
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the user is in.
#' Currently, you use the ID for the Amazon Web Services account that
#' contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_user
quicksight_delete_user <- function(UserName, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
    paginator = list()
  )
  input <- .quicksight$delete_user_input(UserName = UserName, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$delete_user_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_user <- quicksight_delete_user

#' Deletes a user identified by its principal ID
#'
#' @description
#' Deletes a user identified by its principal ID.
#'
#' See [https://paws-r.github.io/docs/quicksight/delete_user_by_principal_id.html](https://paws-r.github.io/docs/quicksight/delete_user_by_principal_id.html) for full documentation.
#'
#' @param PrincipalId &#91;required&#93; The principal ID of the user.
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the user is in.
#' Currently, you use the ID for the Amazon Web Services account that
#' contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_user_by_principal_id
quicksight_delete_user_by_principal_id <- function(PrincipalId, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "DeleteUserByPrincipalId",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/user-principals/{PrincipalId}",
    paginator = list()
  )
  input <- .quicksight$delete_user_by_principal_id_input(PrincipalId = PrincipalId, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$delete_user_by_principal_id_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_user_by_principal_id <- quicksight_delete_user_by_principal_id

#' Describes the customizations associated with the provided Amazon Web
#' Services account and Amazon Amazon QuickSight namespace in an Amazon Web
#' Services Region
#'
#' @description
#' Describes the customizations associated with the provided Amazon Web Services account and Amazon Amazon QuickSight namespace in an Amazon Web Services Region. The Amazon QuickSight console evaluates which customizations to apply by running this API operation with the `Resolved` flag included.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_account_customization.html](https://paws-r.github.io/docs/quicksight/describe_account_customization.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that you want to describe
#' Amazon QuickSight customizations for.
#' @param Namespace The Amazon QuickSight namespace that you want to describe Amazon
#' QuickSight customizations for.
#' @param Resolved The `Resolved` flag works with the other parameters to determine which
#' view of Amazon QuickSight customizations is returned. You can add this
#' flag to your command to use the same view that Amazon QuickSight uses to
#' identify which customizations to apply to the console. Omit this flag,
#' or set it to `no-resolved`, to reveal customizations that are configured
#' at different levels.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_account_customization
quicksight_describe_account_customization <- function(AwsAccountId, Namespace = NULL, Resolved = NULL) {
  op <- new_operation(
    name = "DescribeAccountCustomization",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/customizations",
    paginator = list()
  )
  input <- .quicksight$describe_account_customization_input(AwsAccountId = AwsAccountId, Namespace = Namespace, Resolved = Resolved)
  output <- .quicksight$describe_account_customization_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_account_customization <- quicksight_describe_account_customization

#' Describes the settings that were used when your Amazon QuickSight
#' subscription was first created in this Amazon Web Services account
#'
#' @description
#' Describes the settings that were used when your Amazon QuickSight subscription was first created in this Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_account_settings.html](https://paws-r.github.io/docs/quicksight/describe_account_settings.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the settings
#' that you want to list.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_account_settings
quicksight_describe_account_settings <- function(AwsAccountId) {
  op <- new_operation(
    name = "DescribeAccountSettings",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/settings",
    paginator = list()
  )
  input <- .quicksight$describe_account_settings_input(AwsAccountId = AwsAccountId)
  output <- .quicksight$describe_account_settings_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_account_settings <- quicksight_describe_account_settings

#' Use the DescribeAccountSubscription operation to receive a description
#' of a Amazon QuickSight account's subscription
#'
#' @description
#' Use the DescribeAccountSubscription operation to receive a description of a Amazon QuickSight account's subscription. A successful API call returns an `AccountInfo` object that includes an account's name, subscription status, authentication type, edition, and notification email address.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_account_subscription.html](https://paws-r.github.io/docs/quicksight/describe_account_subscription.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID associated with your Amazon
#' QuickSight account.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_account_subscription
quicksight_describe_account_subscription <- function(AwsAccountId) {
  op <- new_operation(
    name = "DescribeAccountSubscription",
    http_method = "GET",
    http_path = "/account/{AwsAccountId}",
    paginator = list()
  )
  input <- .quicksight$describe_account_subscription_input(AwsAccountId = AwsAccountId)
  output <- .quicksight$describe_account_subscription_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_account_subscription <- quicksight_describe_account_subscription

#' Provides a summary of the metadata for an analysis
#'
#' @description
#' Provides a summary of the metadata for an analysis.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_analysis.html](https://paws-r.github.io/docs/quicksight/describe_analysis.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the analysis.
#' You must be using the Amazon Web Services account that the analysis is
#' in.
#' @param AnalysisId &#91;required&#93; The ID of the analysis that you're describing. The ID is part of the URL
#' of the analysis.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_analysis
quicksight_describe_analysis <- function(AwsAccountId, AnalysisId) {
  op <- new_operation(
    name = "DescribeAnalysis",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
    paginator = list()
  )
  input <- .quicksight$describe_analysis_input(AwsAccountId = AwsAccountId, AnalysisId = AnalysisId)
  output <- .quicksight$describe_analysis_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_analysis <- quicksight_describe_analysis

#' Provides the read and write permissions for an analysis
#'
#' @description
#' Provides the read and write permissions for an analysis.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_analysis_permissions.html](https://paws-r.github.io/docs/quicksight/describe_analysis_permissions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the analysis
#' whose permissions you're describing. You must be using the Amazon Web
#' Services account that the analysis is in.
#' @param AnalysisId &#91;required&#93; The ID of the analysis whose permissions you're describing. The ID is
#' part of the analysis URL.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_analysis_permissions
quicksight_describe_analysis_permissions <- function(AwsAccountId, AnalysisId) {
  op <- new_operation(
    name = "DescribeAnalysisPermissions",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/analyses/{AnalysisId}/permissions",
    paginator = list()
  )
  input <- .quicksight$describe_analysis_permissions_input(AwsAccountId = AwsAccountId, AnalysisId = AnalysisId)
  output <- .quicksight$describe_analysis_permissions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_analysis_permissions <- quicksight_describe_analysis_permissions

#' Provides a summary for a dashboard
#'
#' @description
#' Provides a summary for a dashboard.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_dashboard.html](https://paws-r.github.io/docs/quicksight/describe_dashboard.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the dashboard
#' that you're describing.
#' @param DashboardId &#91;required&#93; The ID for the dashboard.
#' @param VersionNumber The version number for the dashboard. If a version number isn't passed,
#' the latest published dashboard version is described.
#' @param AliasName The alias name.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_dashboard
quicksight_describe_dashboard <- function(AwsAccountId, DashboardId, VersionNumber = NULL, AliasName = NULL) {
  op <- new_operation(
    name = "DescribeDashboard",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
    paginator = list()
  )
  input <- .quicksight$describe_dashboard_input(AwsAccountId = AwsAccountId, DashboardId = DashboardId, VersionNumber = VersionNumber, AliasName = AliasName)
  output <- .quicksight$describe_dashboard_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_dashboard <- quicksight_describe_dashboard

#' Describes read and write permissions for a dashboard
#'
#' @description
#' Describes read and write permissions for a dashboard.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_dashboard_permissions.html](https://paws-r.github.io/docs/quicksight/describe_dashboard_permissions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the dashboard
#' that you're describing permissions for.
#' @param DashboardId &#91;required&#93; The ID for the dashboard, also added to the IAM policy.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_dashboard_permissions
quicksight_describe_dashboard_permissions <- function(AwsAccountId, DashboardId) {
  op <- new_operation(
    name = "DescribeDashboardPermissions",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions",
    paginator = list()
  )
  input <- .quicksight$describe_dashboard_permissions_input(AwsAccountId = AwsAccountId, DashboardId = DashboardId)
  output <- .quicksight$describe_dashboard_permissions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_dashboard_permissions <- quicksight_describe_dashboard_permissions

#' Describes a dataset
#'
#' @description
#' Describes a dataset. This operation doesn't support datasets that include uploaded files as a source.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_data_set.html](https://paws-r.github.io/docs/quicksight/describe_data_set.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param DataSetId &#91;required&#93; The ID for the dataset that you want to create. This ID is unique per
#' Amazon Web Services Region for each Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_data_set
quicksight_describe_data_set <- function(AwsAccountId, DataSetId) {
  op <- new_operation(
    name = "DescribeDataSet",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
    paginator = list()
  )
  input <- .quicksight$describe_data_set_input(AwsAccountId = AwsAccountId, DataSetId = DataSetId)
  output <- .quicksight$describe_data_set_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_data_set <- quicksight_describe_data_set

#' Describes the permissions on a dataset
#'
#' @description
#' Describes the permissions on a dataset.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_data_set_permissions.html](https://paws-r.github.io/docs/quicksight/describe_data_set_permissions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param DataSetId &#91;required&#93; The ID for the dataset that you want to create. This ID is unique per
#' Amazon Web Services Region for each Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_data_set_permissions
quicksight_describe_data_set_permissions <- function(AwsAccountId, DataSetId) {
  op <- new_operation(
    name = "DescribeDataSetPermissions",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/data-sets/{DataSetId}/permissions",
    paginator = list()
  )
  input <- .quicksight$describe_data_set_permissions_input(AwsAccountId = AwsAccountId, DataSetId = DataSetId)
  output <- .quicksight$describe_data_set_permissions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_data_set_permissions <- quicksight_describe_data_set_permissions

#' Describes a data source
#'
#' @description
#' Describes a data source.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_data_source.html](https://paws-r.github.io/docs/quicksight/describe_data_source.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param DataSourceId &#91;required&#93; The ID of the data source. This ID is unique per Amazon Web Services
#' Region for each Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_data_source
quicksight_describe_data_source <- function(AwsAccountId, DataSourceId) {
  op <- new_operation(
    name = "DescribeDataSource",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
    paginator = list()
  )
  input <- .quicksight$describe_data_source_input(AwsAccountId = AwsAccountId, DataSourceId = DataSourceId)
  output <- .quicksight$describe_data_source_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_data_source <- quicksight_describe_data_source

#' Describes the resource permissions for a data source
#'
#' @description
#' Describes the resource permissions for a data source.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_data_source_permissions.html](https://paws-r.github.io/docs/quicksight/describe_data_source_permissions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param DataSourceId &#91;required&#93; The ID of the data source. This ID is unique per Amazon Web Services
#' Region for each Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_data_source_permissions
quicksight_describe_data_source_permissions <- function(AwsAccountId, DataSourceId) {
  op <- new_operation(
    name = "DescribeDataSourcePermissions",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions",
    paginator = list()
  )
  input <- .quicksight$describe_data_source_permissions_input(AwsAccountId = AwsAccountId, DataSourceId = DataSourceId)
  output <- .quicksight$describe_data_source_permissions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_data_source_permissions <- quicksight_describe_data_source_permissions

#' Describes a folder
#'
#' @description
#' Describes a folder.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_folder.html](https://paws-r.github.io/docs/quicksight/describe_folder.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the folder.
#' @param FolderId &#91;required&#93; The ID of the folder.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_folder
quicksight_describe_folder <- function(AwsAccountId, FolderId) {
  op <- new_operation(
    name = "DescribeFolder",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/folders/{FolderId}",
    paginator = list()
  )
  input <- .quicksight$describe_folder_input(AwsAccountId = AwsAccountId, FolderId = FolderId)
  output <- .quicksight$describe_folder_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_folder <- quicksight_describe_folder

#' Describes permissions for a folder
#'
#' @description
#' Describes permissions for a folder.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_folder_permissions.html](https://paws-r.github.io/docs/quicksight/describe_folder_permissions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the folder.
#' @param FolderId &#91;required&#93; The ID of the folder.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_folder_permissions
quicksight_describe_folder_permissions <- function(AwsAccountId, FolderId) {
  op <- new_operation(
    name = "DescribeFolderPermissions",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/folders/{FolderId}/permissions",
    paginator = list()
  )
  input <- .quicksight$describe_folder_permissions_input(AwsAccountId = AwsAccountId, FolderId = FolderId)
  output <- .quicksight$describe_folder_permissions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_folder_permissions <- quicksight_describe_folder_permissions

#' Describes the folder resolved permissions
#'
#' @description
#' Describes the folder resolved permissions. Permissions consists of both folder direct permissions and the inherited permissions from the ancestor folders.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_folder_resolved_permissions.html](https://paws-r.github.io/docs/quicksight/describe_folder_resolved_permissions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the folder.
#' @param FolderId &#91;required&#93; The ID of the folder.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_folder_resolved_permissions
quicksight_describe_folder_resolved_permissions <- function(AwsAccountId, FolderId) {
  op <- new_operation(
    name = "DescribeFolderResolvedPermissions",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/folders/{FolderId}/resolved-permissions",
    paginator = list()
  )
  input <- .quicksight$describe_folder_resolved_permissions_input(AwsAccountId = AwsAccountId, FolderId = FolderId)
  output <- .quicksight$describe_folder_resolved_permissions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_folder_resolved_permissions <- quicksight_describe_folder_resolved_permissions

#' Returns an Amazon QuickSight group's description and Amazon Resource
#' Name (ARN)
#'
#' @description
#' Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_group.html](https://paws-r.github.io/docs/quicksight/describe_group.html) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name of the group that you want to describe.
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the group is in.
#' Currently, you use the ID for the Amazon Web Services account that
#' contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace of the group that you want described.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_group
quicksight_describe_group <- function(GroupName, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "DescribeGroup",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
    paginator = list()
  )
  input <- .quicksight$describe_group_input(GroupName = GroupName, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$describe_group_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_group <- quicksight_describe_group

#' Use the DescribeGroupMembership operation to determine if a user is a
#' member of the specified group
#'
#' @description
#' Use the [`describe_group_membership`][quicksight_describe_group_membership] operation to determine if a user is a member of the specified group. If the user exists and is a member of the specified group, an associated `GroupMember` object is returned.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_group_membership.html](https://paws-r.github.io/docs/quicksight/describe_group_membership.html) for full documentation.
#'
#' @param MemberName &#91;required&#93; The user name of the user that you want to search for.
#' @param GroupName &#91;required&#93; The name of the group that you want to search.
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the group is in.
#' Currently, you use the ID for the Amazon Web Services account that
#' contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace that includes the group you are searching within.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_group_membership
quicksight_describe_group_membership <- function(MemberName, GroupName, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "DescribeGroupMembership",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
    paginator = list()
  )
  input <- .quicksight$describe_group_membership_input(MemberName = MemberName, GroupName = GroupName, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$describe_group_membership_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_group_membership <- quicksight_describe_group_membership

#' Describes an existing IAM policy assignment, as specified by the
#' assignment name
#'
#' @description
#' Describes an existing IAM policy assignment, as specified by the assignment name.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_iam_policy_assignment.html](https://paws-r.github.io/docs/quicksight/describe_iam_policy_assignment.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the assignment
#' that you want to describe.
#' @param AssignmentName &#91;required&#93; The name of the assignment, also called a rule.
#' @param Namespace &#91;required&#93; The namespace that contains the assignment.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_iam_policy_assignment
quicksight_describe_iam_policy_assignment <- function(AwsAccountId, AssignmentName, Namespace) {
  op <- new_operation(
    name = "DescribeIAMPolicyAssignment",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/{AssignmentName}",
    paginator = list()
  )
  input <- .quicksight$describe_iam_policy_assignment_input(AwsAccountId = AwsAccountId, AssignmentName = AssignmentName, Namespace = Namespace)
  output <- .quicksight$describe_iam_policy_assignment_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_iam_policy_assignment <- quicksight_describe_iam_policy_assignment

#' Describes a SPICE ingestion
#'
#' @description
#' Describes a SPICE ingestion.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_ingestion.html](https://paws-r.github.io/docs/quicksight/describe_ingestion.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param DataSetId &#91;required&#93; The ID of the dataset used in the ingestion.
#' @param IngestionId &#91;required&#93; An ID for the ingestion.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_ingestion
quicksight_describe_ingestion <- function(AwsAccountId, DataSetId, IngestionId) {
  op <- new_operation(
    name = "DescribeIngestion",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
    paginator = list()
  )
  input <- .quicksight$describe_ingestion_input(AwsAccountId = AwsAccountId, DataSetId = DataSetId, IngestionId = IngestionId)
  output <- .quicksight$describe_ingestion_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_ingestion <- quicksight_describe_ingestion

#' Provides a summary and status of IP rules
#'
#' @description
#' Provides a summary and status of IP rules.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_ip_restriction.html](https://paws-r.github.io/docs/quicksight/describe_ip_restriction.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the IP rules.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_ip_restriction
quicksight_describe_ip_restriction <- function(AwsAccountId) {
  op <- new_operation(
    name = "DescribeIpRestriction",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/ip-restriction",
    paginator = list()
  )
  input <- .quicksight$describe_ip_restriction_input(AwsAccountId = AwsAccountId)
  output <- .quicksight$describe_ip_restriction_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_ip_restriction <- quicksight_describe_ip_restriction

#' Describes the current namespace
#'
#' @description
#' Describes the current namespace.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_namespace.html](https://paws-r.github.io/docs/quicksight/describe_namespace.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the Amazon
#' QuickSight namespace that you want to describe.
#' @param Namespace &#91;required&#93; The namespace that you want to describe.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_namespace
quicksight_describe_namespace <- function(AwsAccountId, Namespace) {
  op <- new_operation(
    name = "DescribeNamespace",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}",
    paginator = list()
  )
  input <- .quicksight$describe_namespace_input(AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$describe_namespace_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_namespace <- quicksight_describe_namespace

#' Describes a template's metadata
#'
#' @description
#' Describes a template's metadata.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_template.html](https://paws-r.github.io/docs/quicksight/describe_template.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the template
#' that you're describing.
#' @param TemplateId &#91;required&#93; The ID for the template.
#' @param VersionNumber (Optional) The number for the version to describe. If a `VersionNumber`
#' parameter value isn't provided, the latest version of the template is
#' described.
#' @param AliasName The alias of the template that you want to describe. If you name a
#' specific alias, you describe the version that the alias points to. You
#' can specify the latest version of the template by providing the keyword
#' `$LATEST` in the `AliasName` parameter. The keyword `$PUBLISHED` doesn't
#' apply to templates.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_template
quicksight_describe_template <- function(AwsAccountId, TemplateId, VersionNumber = NULL, AliasName = NULL) {
  op <- new_operation(
    name = "DescribeTemplate",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/templates/{TemplateId}",
    paginator = list()
  )
  input <- .quicksight$describe_template_input(AwsAccountId = AwsAccountId, TemplateId = TemplateId, VersionNumber = VersionNumber, AliasName = AliasName)
  output <- .quicksight$describe_template_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_template <- quicksight_describe_template

#' Describes the template alias for a template
#'
#' @description
#' Describes the template alias for a template.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_template_alias.html](https://paws-r.github.io/docs/quicksight/describe_template_alias.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the template
#' alias that you're describing.
#' @param TemplateId &#91;required&#93; The ID for the template.
#' @param AliasName &#91;required&#93; The name of the template alias that you want to describe. If you name a
#' specific alias, you describe the version that the alias points to. You
#' can specify the latest version of the template by providing the keyword
#' `$LATEST` in the `AliasName` parameter. The keyword `$PUBLISHED` doesn't
#' apply to templates.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_template_alias
quicksight_describe_template_alias <- function(AwsAccountId, TemplateId, AliasName) {
  op <- new_operation(
    name = "DescribeTemplateAlias",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
    paginator = list()
  )
  input <- .quicksight$describe_template_alias_input(AwsAccountId = AwsAccountId, TemplateId = TemplateId, AliasName = AliasName)
  output <- .quicksight$describe_template_alias_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_template_alias <- quicksight_describe_template_alias

#' Describes read and write permissions on a template
#'
#' @description
#' Describes read and write permissions on a template.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_template_permissions.html](https://paws-r.github.io/docs/quicksight/describe_template_permissions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the template
#' that you're describing.
#' @param TemplateId &#91;required&#93; The ID for the template.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_template_permissions
quicksight_describe_template_permissions <- function(AwsAccountId, TemplateId) {
  op <- new_operation(
    name = "DescribeTemplatePermissions",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/templates/{TemplateId}/permissions",
    paginator = list()
  )
  input <- .quicksight$describe_template_permissions_input(AwsAccountId = AwsAccountId, TemplateId = TemplateId)
  output <- .quicksight$describe_template_permissions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_template_permissions <- quicksight_describe_template_permissions

#' Describes a theme
#'
#' @description
#' Describes a theme.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_theme.html](https://paws-r.github.io/docs/quicksight/describe_theme.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the theme that
#' you're describing.
#' @param ThemeId &#91;required&#93; The ID for the theme.
#' @param VersionNumber The version number for the version to describe. If a `VersionNumber`
#' parameter value isn't provided, the latest version of the theme is
#' described.
#' @param AliasName The alias of the theme that you want to describe. If you name a specific
#' alias, you describe the version that the alias points to. You can
#' specify the latest version of the theme by providing the keyword
#' `$LATEST` in the `AliasName` parameter. The keyword `$PUBLISHED` doesn't
#' apply to themes.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_theme
quicksight_describe_theme <- function(AwsAccountId, ThemeId, VersionNumber = NULL, AliasName = NULL) {
  op <- new_operation(
    name = "DescribeTheme",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/themes/{ThemeId}",
    paginator = list()
  )
  input <- .quicksight$describe_theme_input(AwsAccountId = AwsAccountId, ThemeId = ThemeId, VersionNumber = VersionNumber, AliasName = AliasName)
  output <- .quicksight$describe_theme_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_theme <- quicksight_describe_theme

#' Describes the alias for a theme
#'
#' @description
#' Describes the alias for a theme.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_theme_alias.html](https://paws-r.github.io/docs/quicksight/describe_theme_alias.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the theme alias
#' that you're describing.
#' @param ThemeId &#91;required&#93; The ID for the theme.
#' @param AliasName &#91;required&#93; The name of the theme alias that you want to describe.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_theme_alias
quicksight_describe_theme_alias <- function(AwsAccountId, ThemeId, AliasName) {
  op <- new_operation(
    name = "DescribeThemeAlias",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
    paginator = list()
  )
  input <- .quicksight$describe_theme_alias_input(AwsAccountId = AwsAccountId, ThemeId = ThemeId, AliasName = AliasName)
  output <- .quicksight$describe_theme_alias_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_theme_alias <- quicksight_describe_theme_alias

#' Describes the read and write permissions for a theme
#'
#' @description
#' Describes the read and write permissions for a theme.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_theme_permissions.html](https://paws-r.github.io/docs/quicksight/describe_theme_permissions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the theme that
#' you're describing.
#' @param ThemeId &#91;required&#93; The ID for the theme that you want to describe permissions for.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_theme_permissions
quicksight_describe_theme_permissions <- function(AwsAccountId, ThemeId) {
  op <- new_operation(
    name = "DescribeThemePermissions",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/themes/{ThemeId}/permissions",
    paginator = list()
  )
  input <- .quicksight$describe_theme_permissions_input(AwsAccountId = AwsAccountId, ThemeId = ThemeId)
  output <- .quicksight$describe_theme_permissions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_theme_permissions <- quicksight_describe_theme_permissions

#' Returns information about a user, given the user name
#'
#' @description
#' Returns information about a user, given the user name.
#'
#' See [https://paws-r.github.io/docs/quicksight/describe_user.html](https://paws-r.github.io/docs/quicksight/describe_user.html) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the user that you want to describe.
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the user is in.
#' Currently, you use the ID for the Amazon Web Services account that
#' contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_user
quicksight_describe_user <- function(UserName, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "DescribeUser",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
    paginator = list()
  )
  input <- .quicksight$describe_user_input(UserName = UserName, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$describe_user_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_user <- quicksight_describe_user

#' Generates an embed URL that you can use to embed an Amazon QuickSight
#' dashboard in your website, without having to register any reader users
#'
#' @description
#' Generates an embed URL that you can use to embed an Amazon QuickSight dashboard in your website, without having to register any reader users. Before you use this action, make sure that you have configured the dashboards and permissions.
#'
#' See [https://paws-r.github.io/docs/quicksight/generate_embed_url_for_anonymous_user.html](https://paws-r.github.io/docs/quicksight/generate_embed_url_for_anonymous_user.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the dashboard
#' that you're embedding.
#' @param SessionLifetimeInMinutes How many minutes the session is valid. The session lifetime must be in
#' \[15-600\] minutes range.
#' @param Namespace &#91;required&#93; The Amazon QuickSight namespace that the anonymous user virtually
#' belongs to. If you are not using an Amazon QuickSight custom namespace,
#' set this to `default`.
#' @param SessionTags The session tags used for row-level security. Before you use this
#' parameter, make sure that you have configured the relevant datasets
#' using the `DataSet$RowLevelPermissionTagConfiguration` parameter so that
#' session tags can be used to provide row-level security.
#' 
#' These are not the tags used for the Amazon Web Services resource tagging
#' feature. For more information, see [Using Row-Level Security (RLS) with
#' Tags](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html)in
#' the *Amazon QuickSight User Guide*.
#' @param AuthorizedResourceArns &#91;required&#93; The Amazon Resource Names (ARNs) for the Amazon QuickSight resources
#' that the user is authorized to access during the lifetime of the
#' session. If you choose `Dashboard` embedding experience, pass the list
#' of dashboard ARNs in the account that you want the user to be able to
#' view. Currently, you can pass up to 25 dashboard ARNs in each API call.
#' @param ExperienceConfiguration &#91;required&#93; The configuration of the experience that you are embedding.
#' @param AllowedDomains The domains that you want to add to the allow list for access to the
#' generated URL that is then embedded. This optional parameter overrides
#' the static domains that are configured in the Manage QuickSight menu in
#' the Amazon QuickSight console. Instead, it allows only the domains that
#' you include in this parameter. You can list up to three domains or
#' subdomains in each API call.
#' 
#' To include all subdomains under a specific domain to the allow list, use
#' `*`. For example, `https://*.sapp.amazon.com` includes all subdomains
#' under `https://sapp.amazon.com`.
#'
#' @keywords internal
#'
#' @rdname quicksight_generate_embed_url_for_anonymous_user
quicksight_generate_embed_url_for_anonymous_user <- function(AwsAccountId, SessionLifetimeInMinutes = NULL, Namespace, SessionTags = NULL, AuthorizedResourceArns, ExperienceConfiguration, AllowedDomains = NULL) {
  op <- new_operation(
    name = "GenerateEmbedUrlForAnonymousUser",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/embed-url/anonymous-user",
    paginator = list()
  )
  input <- .quicksight$generate_embed_url_for_anonymous_user_input(AwsAccountId = AwsAccountId, SessionLifetimeInMinutes = SessionLifetimeInMinutes, Namespace = Namespace, SessionTags = SessionTags, AuthorizedResourceArns = AuthorizedResourceArns, ExperienceConfiguration = ExperienceConfiguration, AllowedDomains = AllowedDomains)
  output <- .quicksight$generate_embed_url_for_anonymous_user_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$generate_embed_url_for_anonymous_user <- quicksight_generate_embed_url_for_anonymous_user

#' Generates an embed URL that you can use to embed an Amazon QuickSight
#' experience in your website
#'
#' @description
#' Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can be used for any type of user registered in an Amazon QuickSight account. Before you use this action, make sure that you have configured the relevant Amazon QuickSight resource and permissions.
#'
#' See [https://paws-r.github.io/docs/quicksight/generate_embed_url_for_registered_user.html](https://paws-r.github.io/docs/quicksight/generate_embed_url_for_registered_user.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the dashboard
#' that you're embedding.
#' @param SessionLifetimeInMinutes How many minutes the session is valid. The session lifetime must be in
#' \[15-600\] minutes range.
#' @param UserArn &#91;required&#93; The Amazon Resource Name for the registered user.
#' @param ExperienceConfiguration &#91;required&#93; The experience you are embedding. For registered users, you can embed
#' Amazon QuickSight dashboards or the entire Amazon QuickSight console.
#' @param AllowedDomains The domains that you want to add to the allow list for access to the
#' generated URL that is then embedded. This optional parameter overrides
#' the static domains that are configured in the Manage QuickSight menu in
#' the Amazon QuickSight console. Instead, it allows only the domains that
#' you include in this parameter. You can list up to three domains or
#' subdomains in each API call.
#' 
#' To include all subdomains under a specific domain to the allow list, use
#' `*`. For example, `https://*.sapp.amazon.com` includes all subdomains
#' under `https://sapp.amazon.com`.
#'
#' @keywords internal
#'
#' @rdname quicksight_generate_embed_url_for_registered_user
quicksight_generate_embed_url_for_registered_user <- function(AwsAccountId, SessionLifetimeInMinutes = NULL, UserArn, ExperienceConfiguration, AllowedDomains = NULL) {
  op <- new_operation(
    name = "GenerateEmbedUrlForRegisteredUser",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/embed-url/registered-user",
    paginator = list()
  )
  input <- .quicksight$generate_embed_url_for_registered_user_input(AwsAccountId = AwsAccountId, SessionLifetimeInMinutes = SessionLifetimeInMinutes, UserArn = UserArn, ExperienceConfiguration = ExperienceConfiguration, AllowedDomains = AllowedDomains)
  output <- .quicksight$generate_embed_url_for_registered_user_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$generate_embed_url_for_registered_user <- quicksight_generate_embed_url_for_registered_user

#' Generates a temporary session URL and authorization code(bearer token)
#' that you can use to embed an Amazon QuickSight read-only dashboard in
#' your website or application
#'
#' @description
#' Generates a temporary session URL and authorization code(bearer token) that you can use to embed an Amazon QuickSight read-only dashboard in your website or application. Before you use this command, make sure that you have configured the dashboards and permissions.
#'
#' See [https://paws-r.github.io/docs/quicksight/get_dashboard_embed_url.html](https://paws-r.github.io/docs/quicksight/get_dashboard_embed_url.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the dashboard
#' that you're embedding.
#' @param DashboardId &#91;required&#93; The ID for the dashboard, also added to the Identity and Access
#' Management (IAM) policy.
#' @param IdentityType &#91;required&#93; The authentication method that the user uses to sign in.
#' @param SessionLifetimeInMinutes How many minutes the session is valid. The session lifetime must be
#' 15-600 minutes.
#' @param UndoRedoDisabled Remove the undo/redo button on the embedded dashboard. The default is
#' FALSE, which enables the undo/redo button.
#' @param ResetDisabled Remove the reset button on the embedded dashboard. The default is FALSE,
#' which enables the reset button.
#' @param StatePersistenceEnabled Adds persistence of state for the user session in an embedded dashboard.
#' Persistence applies to the sheet and the parameter settings. These are
#' control settings that the dashboard subscriber (Amazon QuickSight
#' reader) chooses while viewing the dashboard. If this is set to `TRUE`,
#' the settings are the same when the subscriber reopens the same dashboard
#' URL. The state is stored in Amazon QuickSight, not in a browser cookie.
#' If this is set to FALSE, the state of the user session is not persisted.
#' The default is `FALSE`.
#' @param UserArn The Amazon QuickSight user's Amazon Resource Name (ARN), for use with
#' `QUICKSIGHT` identity type. You can use this for any Amazon QuickSight
#' users in your account (readers, authors, or admins) authenticated as one
#' of the following:
#' 
#' -   Active Directory (AD) users or group members
#' 
#' -   Invited nonfederated users
#' 
#' -   IAM users and IAM role-based sessions authenticated through
#'     Federated Single Sign-On using SAML, OpenID Connect, or IAM
#'     federation.
#' 
#' Omit this parameter for users in the third group – IAM users and IAM
#' role-based sessions.
#' @param Namespace The Amazon QuickSight namespace that contains the dashboard IDs in this
#' request. If you're not using a custom namespace, set
#' `Namespace = default`.
#' @param AdditionalDashboardIds A list of one or more dashboard IDs that you want anonymous users to
#' have tempporary access to. Currently, the `IdentityType` parameter must
#' be set to `ANONYMOUS` because other identity types authenticate as
#' Amazon QuickSight or IAM users. For example, if you set
#' "`--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS`",
#' the session can access all three dashboards.
#'
#' @keywords internal
#'
#' @rdname quicksight_get_dashboard_embed_url
quicksight_get_dashboard_embed_url <- function(AwsAccountId, DashboardId, IdentityType, SessionLifetimeInMinutes = NULL, UndoRedoDisabled = NULL, ResetDisabled = NULL, StatePersistenceEnabled = NULL, UserArn = NULL, Namespace = NULL, AdditionalDashboardIds = NULL) {
  op <- new_operation(
    name = "GetDashboardEmbedUrl",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/dashboards/{DashboardId}/embed-url",
    paginator = list()
  )
  input <- .quicksight$get_dashboard_embed_url_input(AwsAccountId = AwsAccountId, DashboardId = DashboardId, IdentityType = IdentityType, SessionLifetimeInMinutes = SessionLifetimeInMinutes, UndoRedoDisabled = UndoRedoDisabled, ResetDisabled = ResetDisabled, StatePersistenceEnabled = StatePersistenceEnabled, UserArn = UserArn, Namespace = Namespace, AdditionalDashboardIds = AdditionalDashboardIds)
  output <- .quicksight$get_dashboard_embed_url_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$get_dashboard_embed_url <- quicksight_get_dashboard_embed_url

#' Generates a session URL and authorization code that you can use to embed
#' the Amazon Amazon QuickSight console in your web server code
#'
#' @description
#' Generates a session URL and authorization code that you can use to embed the Amazon Amazon QuickSight console in your web server code. Use [`get_session_embed_url`][quicksight_get_session_embed_url] where you want to provide an authoring portal that allows users to create data sources, datasets, analyses, and dashboards. The users who access an embedded Amazon QuickSight console need belong to the author or admin security cohort. If you want to restrict permissions to some of these features, add a custom permissions profile to the user with the [`update_user`][quicksight_update_user] API operation. Use [`register_user`][quicksight_register_user] API operation to add a new user with a custom permission profile attached. For more information, see the following sections in the *Amazon QuickSight User Guide*:
#'
#' See [https://paws-r.github.io/docs/quicksight/get_session_embed_url.html](https://paws-r.github.io/docs/quicksight/get_session_embed_url.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account associated with your Amazon
#' QuickSight subscription.
#' @param EntryPoint The URL you use to access the embedded session. The entry point URL is
#' constrained to the following paths:
#' 
#' -   `/start`
#' 
#' -   `/start/analyses`
#' 
#' -   `/start/dashboards`
#' 
#' -   `/start/favorites`
#' 
#' -   `/dashboards/DashboardId ` - where `DashboardId` is the actual ID
#'     key from the Amazon QuickSight console URL of the dashboard
#' 
#' -   `/analyses/AnalysisId ` - where `AnalysisId` is the actual ID key
#'     from the Amazon QuickSight console URL of the analysis
#' @param SessionLifetimeInMinutes How many minutes the session is valid. The session lifetime must be
#' 15-600 minutes.
#' @param UserArn The Amazon QuickSight user's Amazon Resource Name (ARN), for use with
#' `QUICKSIGHT` identity type. You can use this for any type of Amazon
#' QuickSight users in your account (readers, authors, or admins). They
#' need to be authenticated as one of the following:
#' 
#' 1.  Active Directory (AD) users or group members
#' 
#' 2.  Invited nonfederated users
#' 
#' 3.  Identity and Access Management (IAM) users and IAM role-based
#'     sessions authenticated through Federated Single Sign-On using SAML,
#'     OpenID Connect, or IAM federation
#' 
#' Omit this parameter for users in the third group, IAM users and IAM
#' role-based sessions.
#'
#' @keywords internal
#'
#' @rdname quicksight_get_session_embed_url
quicksight_get_session_embed_url <- function(AwsAccountId, EntryPoint = NULL, SessionLifetimeInMinutes = NULL, UserArn = NULL) {
  op <- new_operation(
    name = "GetSessionEmbedUrl",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/session-embed-url",
    paginator = list()
  )
  input <- .quicksight$get_session_embed_url_input(AwsAccountId = AwsAccountId, EntryPoint = EntryPoint, SessionLifetimeInMinutes = SessionLifetimeInMinutes, UserArn = UserArn)
  output <- .quicksight$get_session_embed_url_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$get_session_embed_url <- quicksight_get_session_embed_url

#' Lists Amazon QuickSight analyses that exist in the specified Amazon Web
#' Services account
#'
#' @description
#' Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_analyses.html](https://paws-r.github.io/docs/quicksight/list_analyses.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the analyses.
#' @param NextToken A pagination token that can be used in a subsequent request.
#' @param MaxResults The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_analyses
quicksight_list_analyses <- function(AwsAccountId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAnalyses",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/analyses",
    paginator = list()
  )
  input <- .quicksight$list_analyses_input(AwsAccountId = AwsAccountId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$list_analyses_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_analyses <- quicksight_list_analyses

#' Lists all the versions of the dashboards in the Amazon QuickSight
#' subscription
#'
#' @description
#' Lists all the versions of the dashboards in the Amazon QuickSight subscription.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_dashboard_versions.html](https://paws-r.github.io/docs/quicksight/list_dashboard_versions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the dashboard
#' that you're listing versions for.
#' @param DashboardId &#91;required&#93; The ID for the dashboard.
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param MaxResults The maximum number of results to be returned per request.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_dashboard_versions
quicksight_list_dashboard_versions <- function(AwsAccountId, DashboardId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDashboardVersions",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/dashboards/{DashboardId}/versions",
    paginator = list()
  )
  input <- .quicksight$list_dashboard_versions_input(AwsAccountId = AwsAccountId, DashboardId = DashboardId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$list_dashboard_versions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_dashboard_versions <- quicksight_list_dashboard_versions

#' Lists dashboards in an Amazon Web Services account
#'
#' @description
#' Lists dashboards in an Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_dashboards.html](https://paws-r.github.io/docs/quicksight/list_dashboards.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the dashboards
#' that you're listing.
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param MaxResults The maximum number of results to be returned per request.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_dashboards
quicksight_list_dashboards <- function(AwsAccountId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDashboards",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/dashboards",
    paginator = list()
  )
  input <- .quicksight$list_dashboards_input(AwsAccountId = AwsAccountId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$list_dashboards_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_dashboards <- quicksight_list_dashboards

#' Lists all of the datasets belonging to the current Amazon Web Services
#' account in an Amazon Web Services Region
#'
#' @description
#' Lists all of the datasets belonging to the current Amazon Web Services account in an Amazon Web Services Region.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_data_sets.html](https://paws-r.github.io/docs/quicksight/list_data_sets.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param MaxResults The maximum number of results to be returned per request.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_data_sets
quicksight_list_data_sets <- function(AwsAccountId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDataSets",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/data-sets",
    paginator = list()
  )
  input <- .quicksight$list_data_sets_input(AwsAccountId = AwsAccountId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$list_data_sets_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_data_sets <- quicksight_list_data_sets

#' Lists data sources in current Amazon Web Services Region that belong to
#' this Amazon Web Services account
#'
#' @description
#' Lists data sources in current Amazon Web Services Region that belong to this Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_data_sources.html](https://paws-r.github.io/docs/quicksight/list_data_sources.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param MaxResults The maximum number of results to be returned per request.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_data_sources
quicksight_list_data_sources <- function(AwsAccountId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDataSources",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/data-sources",
    paginator = list()
  )
  input <- .quicksight$list_data_sources_input(AwsAccountId = AwsAccountId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$list_data_sources_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_data_sources <- quicksight_list_data_sources

#' List all assets (DASHBOARD, ANALYSIS, and DATASET) in a folder
#'
#' @description
#' List all assets (`DASHBOARD`, `ANALYSIS`, and `DATASET`) in a folder.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_folder_members.html](https://paws-r.github.io/docs/quicksight/list_folder_members.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the folder.
#' @param FolderId &#91;required&#93; The ID of the folder.
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param MaxResults The maximum number of results to be returned per request.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_folder_members
quicksight_list_folder_members <- function(AwsAccountId, FolderId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFolderMembers",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/folders/{FolderId}/members",
    paginator = list()
  )
  input <- .quicksight$list_folder_members_input(AwsAccountId = AwsAccountId, FolderId = FolderId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$list_folder_members_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_folder_members <- quicksight_list_folder_members

#' Lists all folders in an account
#'
#' @description
#' Lists all folders in an account.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_folders.html](https://paws-r.github.io/docs/quicksight/list_folders.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the folder.
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param MaxResults The maximum number of results to be returned per request.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_folders
quicksight_list_folders <- function(AwsAccountId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFolders",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/folders",
    paginator = list()
  )
  input <- .quicksight$list_folders_input(AwsAccountId = AwsAccountId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$list_folders_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_folders <- quicksight_list_folders

#' Lists member users in a group
#'
#' @description
#' Lists member users in a group.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_group_memberships.html](https://paws-r.github.io/docs/quicksight/list_group_memberships.html) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name of the group that you want to see a membership list of.
#' @param NextToken A pagination token that can be used in a subsequent request.
#' @param MaxResults The maximum number of results to return from this request.
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the group is in.
#' Currently, you use the ID for the Amazon Web Services account that
#' contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace of the group that you want a list of users from.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_group_memberships
quicksight_list_group_memberships <- function(GroupName, NextToken = NULL, MaxResults = NULL, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "ListGroupMemberships",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members",
    paginator = list()
  )
  input <- .quicksight$list_group_memberships_input(GroupName = GroupName, NextToken = NextToken, MaxResults = MaxResults, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$list_group_memberships_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_group_memberships <- quicksight_list_group_memberships

#' Lists all user groups in Amazon QuickSight
#'
#' @description
#' Lists all user groups in Amazon QuickSight.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_groups.html](https://paws-r.github.io/docs/quicksight/list_groups.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the group is in.
#' Currently, you use the ID for the Amazon Web Services account that
#' contains your Amazon QuickSight account.
#' @param NextToken A pagination token that can be used in a subsequent request.
#' @param MaxResults The maximum number of results to return.
#' @param Namespace &#91;required&#93; The namespace that you want a list of groups from.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_groups
quicksight_list_groups <- function(AwsAccountId, NextToken = NULL, MaxResults = NULL, Namespace) {
  op <- new_operation(
    name = "ListGroups",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups",
    paginator = list()
  )
  input <- .quicksight$list_groups_input(AwsAccountId = AwsAccountId, NextToken = NextToken, MaxResults = MaxResults, Namespace = Namespace)
  output <- .quicksight$list_groups_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_groups <- quicksight_list_groups

#' Lists IAM policy assignments in the current Amazon QuickSight account
#'
#' @description
#' Lists IAM policy assignments in the current Amazon QuickSight account.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_iam_policy_assignments.html](https://paws-r.github.io/docs/quicksight/list_iam_policy_assignments.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains these IAM policy
#' assignments.
#' @param AssignmentStatus The status of the assignments.
#' @param Namespace &#91;required&#93; The namespace for the assignments.
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param MaxResults The maximum number of results to be returned per request.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_iam_policy_assignments
quicksight_list_iam_policy_assignments <- function(AwsAccountId, AssignmentStatus = NULL, Namespace, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListIAMPolicyAssignments",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments",
    paginator = list()
  )
  input <- .quicksight$list_iam_policy_assignments_input(AwsAccountId = AwsAccountId, AssignmentStatus = AssignmentStatus, Namespace = Namespace, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$list_iam_policy_assignments_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_iam_policy_assignments <- quicksight_list_iam_policy_assignments

#' Lists all the IAM policy assignments, including the Amazon Resource
#' Names (ARNs) for the IAM policies assigned to the specified user and
#' group or groups that the user belongs to
#'
#' @description
#' Lists all the IAM policy assignments, including the Amazon Resource Names (ARNs) for the IAM policies assigned to the specified user and group or groups that the user belongs to.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_iam_policy_assignments_for_user.html](https://paws-r.github.io/docs/quicksight/list_iam_policy_assignments_for_user.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the assignments.
#' @param UserName &#91;required&#93; The name of the user.
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param MaxResults The maximum number of results to be returned per request.
#' @param Namespace &#91;required&#93; The namespace of the assignment.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_iam_policy_assignments_for_user
quicksight_list_iam_policy_assignments_for_user <- function(AwsAccountId, UserName, NextToken = NULL, MaxResults = NULL, Namespace) {
  op <- new_operation(
    name = "ListIAMPolicyAssignmentsForUser",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/iam-policy-assignments",
    paginator = list()
  )
  input <- .quicksight$list_iam_policy_assignments_for_user_input(AwsAccountId = AwsAccountId, UserName = UserName, NextToken = NextToken, MaxResults = MaxResults, Namespace = Namespace)
  output <- .quicksight$list_iam_policy_assignments_for_user_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_iam_policy_assignments_for_user <- quicksight_list_iam_policy_assignments_for_user

#' Lists the history of SPICE ingestions for a dataset
#'
#' @description
#' Lists the history of SPICE ingestions for a dataset.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_ingestions.html](https://paws-r.github.io/docs/quicksight/list_ingestions.html) for full documentation.
#'
#' @param DataSetId &#91;required&#93; The ID of the dataset used in the ingestion.
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param MaxResults The maximum number of results to be returned per request.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_ingestions
quicksight_list_ingestions <- function(DataSetId, NextToken = NULL, AwsAccountId, MaxResults = NULL) {
  op <- new_operation(
    name = "ListIngestions",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions",
    paginator = list()
  )
  input <- .quicksight$list_ingestions_input(DataSetId = DataSetId, NextToken = NextToken, AwsAccountId = AwsAccountId, MaxResults = MaxResults)
  output <- .quicksight$list_ingestions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_ingestions <- quicksight_list_ingestions

#' Lists the namespaces for the specified Amazon Web Services account
#'
#' @description
#' Lists the namespaces for the specified Amazon Web Services account. This operation doesn't list deleted namespaces.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_namespaces.html](https://paws-r.github.io/docs/quicksight/list_namespaces.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the Amazon
#' QuickSight namespaces that you want to list.
#' @param NextToken A unique pagination token that can be used in a subsequent request. You
#' will receive a pagination token in the response body of a previous
#' `ListNameSpaces` API call if there is more data that can be returned. To
#' receive the data, make another
#' [`list_namespaces`][quicksight_list_namespaces] API call with the
#' returned token to retrieve the next page of data. Each token is valid
#' for 24 hours. If you try to make a
#' [`list_namespaces`][quicksight_list_namespaces] API call with an expired
#' token, you will receive a `HTTP 400 InvalidNextTokenException` error.
#' @param MaxResults The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_namespaces
quicksight_list_namespaces <- function(AwsAccountId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListNamespaces",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces",
    paginator = list()
  )
  input <- .quicksight$list_namespaces_input(AwsAccountId = AwsAccountId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$list_namespaces_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_namespaces <- quicksight_list_namespaces

#' Lists the tags assigned to a resource
#'
#' @description
#' Lists the tags assigned to a resource.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_tags_for_resource.html](https://paws-r.github.io/docs/quicksight/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want a list of
#' tags for.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_tags_for_resource
quicksight_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/resources/{ResourceArn}/tags",
    paginator = list()
  )
  input <- .quicksight$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .quicksight$list_tags_for_resource_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_tags_for_resource <- quicksight_list_tags_for_resource

#' Lists all the aliases of a template
#'
#' @description
#' Lists all the aliases of a template.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_template_aliases.html](https://paws-r.github.io/docs/quicksight/list_template_aliases.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the template
#' aliases that you're listing.
#' @param TemplateId &#91;required&#93; The ID for the template.
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param MaxResults The maximum number of results to be returned per request.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_template_aliases
quicksight_list_template_aliases <- function(AwsAccountId, TemplateId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTemplateAliases",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases",
    paginator = list()
  )
  input <- .quicksight$list_template_aliases_input(AwsAccountId = AwsAccountId, TemplateId = TemplateId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$list_template_aliases_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_template_aliases <- quicksight_list_template_aliases

#' Lists all the versions of the templates in the current Amazon QuickSight
#' account
#'
#' @description
#' Lists all the versions of the templates in the current Amazon QuickSight account.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_template_versions.html](https://paws-r.github.io/docs/quicksight/list_template_versions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the templates
#' that you're listing.
#' @param TemplateId &#91;required&#93; The ID for the template.
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param MaxResults The maximum number of results to be returned per request.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_template_versions
quicksight_list_template_versions <- function(AwsAccountId, TemplateId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTemplateVersions",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/templates/{TemplateId}/versions",
    paginator = list()
  )
  input <- .quicksight$list_template_versions_input(AwsAccountId = AwsAccountId, TemplateId = TemplateId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$list_template_versions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_template_versions <- quicksight_list_template_versions

#' Lists all the templates in the current Amazon QuickSight account
#'
#' @description
#' Lists all the templates in the current Amazon QuickSight account.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_templates.html](https://paws-r.github.io/docs/quicksight/list_templates.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the templates
#' that you're listing.
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param MaxResults The maximum number of results to be returned per request.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_templates
quicksight_list_templates <- function(AwsAccountId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTemplates",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/templates",
    paginator = list()
  )
  input <- .quicksight$list_templates_input(AwsAccountId = AwsAccountId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$list_templates_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_templates <- quicksight_list_templates

#' Lists all the aliases of a theme
#'
#' @description
#' Lists all the aliases of a theme.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_theme_aliases.html](https://paws-r.github.io/docs/quicksight/list_theme_aliases.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the theme
#' aliases that you're listing.
#' @param ThemeId &#91;required&#93; The ID for the theme.
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param MaxResults The maximum number of results to be returned per request.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_theme_aliases
quicksight_list_theme_aliases <- function(AwsAccountId, ThemeId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListThemeAliases",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases",
    paginator = list()
  )
  input <- .quicksight$list_theme_aliases_input(AwsAccountId = AwsAccountId, ThemeId = ThemeId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$list_theme_aliases_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_theme_aliases <- quicksight_list_theme_aliases

#' Lists all the versions of the themes in the current Amazon Web Services
#' account
#'
#' @description
#' Lists all the versions of the themes in the current Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_theme_versions.html](https://paws-r.github.io/docs/quicksight/list_theme_versions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the themes that
#' you're listing.
#' @param ThemeId &#91;required&#93; The ID for the theme.
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param MaxResults The maximum number of results to be returned per request.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_theme_versions
quicksight_list_theme_versions <- function(AwsAccountId, ThemeId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListThemeVersions",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/themes/{ThemeId}/versions",
    paginator = list()
  )
  input <- .quicksight$list_theme_versions_input(AwsAccountId = AwsAccountId, ThemeId = ThemeId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$list_theme_versions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_theme_versions <- quicksight_list_theme_versions

#' Lists all the themes in the current Amazon Web Services account
#'
#' @description
#' Lists all the themes in the current Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_themes.html](https://paws-r.github.io/docs/quicksight/list_themes.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the themes that
#' you're listing.
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param MaxResults The maximum number of results to be returned per request.
#' @param Type The type of themes that you want to list. Valid options include the
#' following:
#' 
#' -   `ALL (default)`- Display all existing themes.
#' 
#' -   `CUSTOM` - Display only the themes created by people using Amazon
#'     QuickSight.
#' 
#' -   `QUICKSIGHT` - Display only the starting themes defined by Amazon
#'     QuickSight.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_themes
quicksight_list_themes <- function(AwsAccountId, NextToken = NULL, MaxResults = NULL, Type = NULL) {
  op <- new_operation(
    name = "ListThemes",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/themes",
    paginator = list()
  )
  input <- .quicksight$list_themes_input(AwsAccountId = AwsAccountId, NextToken = NextToken, MaxResults = MaxResults, Type = Type)
  output <- .quicksight$list_themes_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_themes <- quicksight_list_themes

#' Lists the Amazon QuickSight groups that an Amazon QuickSight user is a
#' member of
#'
#' @description
#' Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_user_groups.html](https://paws-r.github.io/docs/quicksight/list_user_groups.html) for full documentation.
#'
#' @param UserName &#91;required&#93; The Amazon QuickSight user name that you want to list group memberships
#' for.
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID that the user is in. Currently, you
#' use the ID for the Amazon Web Services account that contains your Amazon
#' QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#' @param NextToken A pagination token that can be used in a subsequent request.
#' @param MaxResults The maximum number of results to return from this request.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_user_groups
quicksight_list_user_groups <- function(UserName, AwsAccountId, Namespace, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListUserGroups",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/groups",
    paginator = list()
  )
  input <- .quicksight$list_user_groups_input(UserName = UserName, AwsAccountId = AwsAccountId, Namespace = Namespace, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$list_user_groups_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_user_groups <- quicksight_list_user_groups

#' Returns a list of all of the Amazon QuickSight users belonging to this
#' account
#'
#' @description
#' Returns a list of all of the Amazon QuickSight users belonging to this account.
#'
#' See [https://paws-r.github.io/docs/quicksight/list_users.html](https://paws-r.github.io/docs/quicksight/list_users.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the user is in.
#' Currently, you use the ID for the Amazon Web Services account that
#' contains your Amazon QuickSight account.
#' @param NextToken A pagination token that can be used in a subsequent request.
#' @param MaxResults The maximum number of results to return from this request.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#'
#' @keywords internal
#'
#' @rdname quicksight_list_users
quicksight_list_users <- function(AwsAccountId, NextToken = NULL, MaxResults = NULL, Namespace) {
  op <- new_operation(
    name = "ListUsers",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/users",
    paginator = list()
  )
  input <- .quicksight$list_users_input(AwsAccountId = AwsAccountId, NextToken = NextToken, MaxResults = MaxResults, Namespace = Namespace)
  output <- .quicksight$list_users_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_users <- quicksight_list_users

#' Creates an Amazon QuickSight user, whose identity is associated with the
#' Identity and Access Management (IAM) identity or role specified in the
#' request
#'
#' @description
#' Creates an Amazon QuickSight user, whose identity is associated with the Identity and Access Management (IAM) identity or role specified in the request.
#'
#' See [https://paws-r.github.io/docs/quicksight/register_user.html](https://paws-r.github.io/docs/quicksight/register_user.html) for full documentation.
#'
#' @param IdentityType &#91;required&#93; Amazon QuickSight supports several ways of managing the identity of
#' users. This parameter accepts two values:
#' 
#' -   `IAM`: A user whose identity maps to an existing IAM user or role.
#' 
#' -   `QUICKSIGHT`: A user whose identity is owned and managed internally
#'     by Amazon QuickSight.
#' @param Email &#91;required&#93; The email address of the user that you want to register.
#' @param UserRole &#91;required&#93; The Amazon QuickSight role for the user. The user role can be one of the
#' following:
#' 
#' -   `READER`: A user who has read-only access to dashboards.
#' 
#' -   `AUTHOR`: A user who can create data sources, datasets, analyses,
#'     and dashboards.
#' 
#' -   `ADMIN`: A user who is an author, who can also manage Amazon
#'     QuickSight settings.
#' 
#' -   `RESTRICTED_READER`: This role isn't currently available for use.
#' 
#' -   `RESTRICTED_AUTHOR`: This role isn't currently available for use.
#' @param IamArn The ARN of the IAM user or role that you are registering with Amazon
#' QuickSight.
#' @param SessionName You need to use this parameter only when you register one or more users
#' using an assumed IAM role. You don't need to provide the session name
#' for other scenarios, for example when you are registering an IAM user or
#' an Amazon QuickSight user. You can register multiple users using the
#' same IAM role if each user has a different session name. For more
#' information on assuming IAM roles, see
#' [`assume-role`](https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html)
#' in the *CLI Reference.*
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the user is in.
#' Currently, you use the ID for the Amazon Web Services account that
#' contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#' @param UserName The Amazon QuickSight user name that you want to create for the user you
#' are registering.
#' @param CustomPermissionsName (Enterprise edition only) The name of the custom permissions profile
#' that you want to assign to this user. Customized permissions allows you
#' to control a user's access by restricting access the following
#' operations:
#' 
#' -   Create and update data sources
#' 
#' -   Create and update datasets
#' 
#' -   Create and update email reports
#' 
#' -   Subscribe to email reports
#' 
#' To add custom permissions to an existing user, use
#' [`update_user`][quicksight_update_user] instead.
#' 
#' A set of custom permissions includes any combination of these
#' restrictions. Currently, you need to create the profile names for custom
#' permission sets by using the Amazon QuickSight console. Then, you use
#' the [`register_user`][quicksight_register_user] API operation to assign
#' the named set of permissions to a Amazon QuickSight user.
#' 
#' Amazon QuickSight custom permissions are applied through IAM policies.
#' Therefore, they override the permissions typically granted by assigning
#' Amazon QuickSight users to one of the default security cohorts in Amazon
#' QuickSight (admin, author, reader).
#' 
#' This feature is available only to Amazon QuickSight Enterprise edition
#' subscriptions.
#' @param ExternalLoginFederationProviderType The type of supported external login provider that provides identity to
#' let a user federate into Amazon QuickSight with an associated Identity
#' and Access Management(IAM) role. The type of supported external login
#' provider can be one of the following.
#' 
#' -   `COGNITO`: Amazon Cognito. The provider URL is
#'     cognito-identity.amazonaws.com. When choosing the `COGNITO` provider
#'     type, don’t use the "CustomFederationProviderUrl" parameter which is
#'     only needed when the external provider is custom.
#' 
#' -   `CUSTOM_OIDC`: Custom OpenID Connect (OIDC) provider. When choosing
#'     `CUSTOM_OIDC` type, use the `CustomFederationProviderUrl` parameter
#'     to provide the custom OIDC provider URL.
#' @param CustomFederationProviderUrl The URL of the custom OpenID Connect (OIDC) provider that provides
#' identity to let a user federate into Amazon QuickSight with an
#' associated Identity and Access Management(IAM) role. This parameter
#' should only be used when `ExternalLoginFederationProviderType` parameter
#' is set to `CUSTOM_OIDC`.
#' @param ExternalLoginId The identity ID for a user in the external login provider.
#'
#' @keywords internal
#'
#' @rdname quicksight_register_user
quicksight_register_user <- function(IdentityType, Email, UserRole, IamArn = NULL, SessionName = NULL, AwsAccountId, Namespace, UserName = NULL, CustomPermissionsName = NULL, ExternalLoginFederationProviderType = NULL, CustomFederationProviderUrl = NULL, ExternalLoginId = NULL) {
  op <- new_operation(
    name = "RegisterUser",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/users",
    paginator = list()
  )
  input <- .quicksight$register_user_input(IdentityType = IdentityType, Email = Email, UserRole = UserRole, IamArn = IamArn, SessionName = SessionName, AwsAccountId = AwsAccountId, Namespace = Namespace, UserName = UserName, CustomPermissionsName = CustomPermissionsName, ExternalLoginFederationProviderType = ExternalLoginFederationProviderType, CustomFederationProviderUrl = CustomFederationProviderUrl, ExternalLoginId = ExternalLoginId)
  output <- .quicksight$register_user_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$register_user <- quicksight_register_user

#' Restores an analysis
#'
#' @description
#' Restores an analysis.
#'
#' See [https://paws-r.github.io/docs/quicksight/restore_analysis.html](https://paws-r.github.io/docs/quicksight/restore_analysis.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the analysis.
#' @param AnalysisId &#91;required&#93; The ID of the analysis that you're restoring.
#'
#' @keywords internal
#'
#' @rdname quicksight_restore_analysis
quicksight_restore_analysis <- function(AwsAccountId, AnalysisId) {
  op <- new_operation(
    name = "RestoreAnalysis",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/restore/analyses/{AnalysisId}",
    paginator = list()
  )
  input <- .quicksight$restore_analysis_input(AwsAccountId = AwsAccountId, AnalysisId = AnalysisId)
  output <- .quicksight$restore_analysis_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$restore_analysis <- quicksight_restore_analysis

#' Searches for analyses that belong to the user specified in the filter
#'
#' @description
#' Searches for analyses that belong to the user specified in the filter.
#'
#' See [https://paws-r.github.io/docs/quicksight/search_analyses.html](https://paws-r.github.io/docs/quicksight/search_analyses.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the analyses
#' that you're searching for.
#' @param Filters &#91;required&#93; The structure for the search filters that you want to apply to your
#' search.
#' @param NextToken A pagination token that can be used in a subsequent request.
#' @param MaxResults The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname quicksight_search_analyses
quicksight_search_analyses <- function(AwsAccountId, Filters, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "SearchAnalyses",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/search/analyses",
    paginator = list()
  )
  input <- .quicksight$search_analyses_input(AwsAccountId = AwsAccountId, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$search_analyses_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$search_analyses <- quicksight_search_analyses

#' Searches for dashboards that belong to a user
#'
#' @description
#' Searches for dashboards that belong to a user.
#'
#' See [https://paws-r.github.io/docs/quicksight/search_dashboards.html](https://paws-r.github.io/docs/quicksight/search_dashboards.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the user whose
#' dashboards you're searching for.
#' @param Filters &#91;required&#93; The filters to apply to the search. Currently, you can search only by
#' user name, for example,
#' `"Filters": [ { "Name": "QUICKSIGHT_USER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1" } ]`
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param MaxResults The maximum number of results to be returned per request.
#'
#' @keywords internal
#'
#' @rdname quicksight_search_dashboards
quicksight_search_dashboards <- function(AwsAccountId, Filters, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "SearchDashboards",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/search/dashboards",
    paginator = list()
  )
  input <- .quicksight$search_dashboards_input(AwsAccountId = AwsAccountId, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$search_dashboards_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$search_dashboards <- quicksight_search_dashboards

#' Searches the subfolders in a folder
#'
#' @description
#' Searches the subfolders in a folder.
#'
#' See [https://paws-r.github.io/docs/quicksight/search_folders.html](https://paws-r.github.io/docs/quicksight/search_folders.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the folder.
#' @param Filters &#91;required&#93; The filters to apply to the search. Currently, you can search only by
#' the parent folder ARN. For example,
#' `"Filters": [ { "Name": "PARENT_FOLDER_ARN", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:folder/folderId" } ]`.
#' @param NextToken The token for the next set of results, or null if there are no more
#' results.
#' @param MaxResults The maximum number of results to be returned per request.
#'
#' @keywords internal
#'
#' @rdname quicksight_search_folders
quicksight_search_folders <- function(AwsAccountId, Filters, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "SearchFolders",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/search/folders",
    paginator = list()
  )
  input <- .quicksight$search_folders_input(AwsAccountId = AwsAccountId, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$search_folders_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$search_folders <- quicksight_search_folders

#' Use the SearchGroups operation to search groups in a specified Amazon
#' QuickSight namespace using the supplied filters
#'
#' @description
#' Use the [`search_groups`][quicksight_search_groups] operation to search groups in a specified Amazon QuickSight namespace using the supplied filters.
#'
#' See [https://paws-r.github.io/docs/quicksight/search_groups.html](https://paws-r.github.io/docs/quicksight/search_groups.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the group is in.
#' Currently, you use the ID for the Amazon Web Services account that
#' contains your Amazon QuickSight account.
#' @param NextToken A pagination token that can be used in a subsequent request.
#' @param MaxResults The maximum number of results to return from this request.
#' @param Namespace &#91;required&#93; The namespace that you want to search.
#' @param Filters &#91;required&#93; The structure for the search filters that you want to apply to your
#' search.
#'
#' @keywords internal
#'
#' @rdname quicksight_search_groups
quicksight_search_groups <- function(AwsAccountId, NextToken = NULL, MaxResults = NULL, Namespace, Filters) {
  op <- new_operation(
    name = "SearchGroups",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups-search",
    paginator = list()
  )
  input <- .quicksight$search_groups_input(AwsAccountId = AwsAccountId, NextToken = NextToken, MaxResults = MaxResults, Namespace = Namespace, Filters = Filters)
  output <- .quicksight$search_groups_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$search_groups <- quicksight_search_groups

#' Assigns one or more tags (key-value pairs) to the specified Amazon
#' QuickSight resource
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified Amazon QuickSight resource.
#'
#' See [https://paws-r.github.io/docs/quicksight/tag_resource.html](https://paws-r.github.io/docs/quicksight/tag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to tag.
#' @param Tags &#91;required&#93; Contains a map of the key-value pairs for the resource tag or tags
#' assigned to the resource.
#'
#' @keywords internal
#'
#' @rdname quicksight_tag_resource
quicksight_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/resources/{ResourceArn}/tags",
    paginator = list()
  )
  input <- .quicksight$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .quicksight$tag_resource_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$tag_resource <- quicksight_tag_resource

#' Removes a tag or tags from a resource
#'
#' @description
#' Removes a tag or tags from a resource.
#'
#' See [https://paws-r.github.io/docs/quicksight/untag_resource.html](https://paws-r.github.io/docs/quicksight/untag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to untag.
#' @param TagKeys &#91;required&#93; The keys of the key-value pairs for the resource tag or tags assigned to
#' the resource.
#'
#' @keywords internal
#'
#' @rdname quicksight_untag_resource
quicksight_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/resources/{ResourceArn}/tags",
    paginator = list()
  )
  input <- .quicksight$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .quicksight$untag_resource_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$untag_resource <- quicksight_untag_resource

#' Updates Amazon QuickSight customizations for the current Amazon Web
#' Services Region
#'
#' @description
#' Updates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, the only customization that you can use is a theme.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_account_customization.html](https://paws-r.github.io/docs/quicksight/update_account_customization.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that you want to update
#' Amazon QuickSight customizations for.
#' @param Namespace The namespace that you want to update Amazon QuickSight customizations
#' for.
#' @param AccountCustomization &#91;required&#93; The Amazon QuickSight customizations you're updating in the current
#' Amazon Web Services Region.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_account_customization
quicksight_update_account_customization <- function(AwsAccountId, Namespace = NULL, AccountCustomization) {
  op <- new_operation(
    name = "UpdateAccountCustomization",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/customizations",
    paginator = list()
  )
  input <- .quicksight$update_account_customization_input(AwsAccountId = AwsAccountId, Namespace = Namespace, AccountCustomization = AccountCustomization)
  output <- .quicksight$update_account_customization_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_account_customization <- quicksight_update_account_customization

#' Updates the Amazon QuickSight settings in your Amazon Web Services
#' account
#'
#' @description
#' Updates the Amazon QuickSight settings in your Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_account_settings.html](https://paws-r.github.io/docs/quicksight/update_account_settings.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the Amazon
#' QuickSight settings that you want to list.
#' @param DefaultNamespace &#91;required&#93; The default namespace for this Amazon Web Services account. Currently,
#' the default is `default`. Identity and Access Management (IAM) users
#' that register for the first time with Amazon QuickSight provide an email
#' address that becomes associated with the default namespace.
#' @param NotificationEmail The email address that you want Amazon QuickSight to send notifications
#' to regarding your Amazon Web Services account or Amazon QuickSight
#' subscription.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_account_settings
quicksight_update_account_settings <- function(AwsAccountId, DefaultNamespace, NotificationEmail = NULL) {
  op <- new_operation(
    name = "UpdateAccountSettings",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/settings",
    paginator = list()
  )
  input <- .quicksight$update_account_settings_input(AwsAccountId = AwsAccountId, DefaultNamespace = DefaultNamespace, NotificationEmail = NotificationEmail)
  output <- .quicksight$update_account_settings_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_account_settings <- quicksight_update_account_settings

#' Updates an analysis in Amazon QuickSight
#'
#' @description
#' Updates an analysis in Amazon QuickSight
#'
#' See [https://paws-r.github.io/docs/quicksight/update_analysis.html](https://paws-r.github.io/docs/quicksight/update_analysis.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the analysis
#' that you're updating.
#' @param AnalysisId &#91;required&#93; The ID for the analysis that you're updating. This ID displays in the
#' URL of the analysis.
#' @param Name &#91;required&#93; A descriptive name for the analysis that you're updating. This name
#' displays for the analysis in the Amazon QuickSight console.
#' @param Parameters The parameter names and override values that you want to use. An
#' analysis can have any parameter type, and some parameters might accept
#' multiple values.
#' @param SourceEntity &#91;required&#93; A source entity to use for the analysis that you're updating. This
#' metadata structure contains details that describe a source template and
#' one or more datasets.
#' @param ThemeArn The Amazon Resource Name (ARN) for the theme to apply to the analysis
#' that you're creating. To see the theme in the Amazon QuickSight console,
#' make sure that you have access to it.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_analysis
quicksight_update_analysis <- function(AwsAccountId, AnalysisId, Name, Parameters = NULL, SourceEntity, ThemeArn = NULL) {
  op <- new_operation(
    name = "UpdateAnalysis",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
    paginator = list()
  )
  input <- .quicksight$update_analysis_input(AwsAccountId = AwsAccountId, AnalysisId = AnalysisId, Name = Name, Parameters = Parameters, SourceEntity = SourceEntity, ThemeArn = ThemeArn)
  output <- .quicksight$update_analysis_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_analysis <- quicksight_update_analysis

#' Updates the read and write permissions for an analysis
#'
#' @description
#' Updates the read and write permissions for an analysis.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_analysis_permissions.html](https://paws-r.github.io/docs/quicksight/update_analysis_permissions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the analysis
#' whose permissions you're updating. You must be using the Amazon Web
#' Services account that the analysis is in.
#' @param AnalysisId &#91;required&#93; The ID of the analysis whose permissions you're updating. The ID is part
#' of the analysis URL.
#' @param GrantPermissions A structure that describes the permissions to add and the principal to
#' add them to.
#' @param RevokePermissions A structure that describes the permissions to remove and the principal
#' to remove them from.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_analysis_permissions
quicksight_update_analysis_permissions <- function(AwsAccountId, AnalysisId, GrantPermissions = NULL, RevokePermissions = NULL) {
  op <- new_operation(
    name = "UpdateAnalysisPermissions",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/analyses/{AnalysisId}/permissions",
    paginator = list()
  )
  input <- .quicksight$update_analysis_permissions_input(AwsAccountId = AwsAccountId, AnalysisId = AnalysisId, GrantPermissions = GrantPermissions, RevokePermissions = RevokePermissions)
  output <- .quicksight$update_analysis_permissions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_analysis_permissions <- quicksight_update_analysis_permissions

#' Updates a dashboard in an Amazon Web Services account
#'
#' @description
#' Updates a dashboard in an Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_dashboard.html](https://paws-r.github.io/docs/quicksight/update_dashboard.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the dashboard
#' that you're updating.
#' @param DashboardId &#91;required&#93; The ID for the dashboard.
#' @param Name &#91;required&#93; The display name of the dashboard.
#' @param SourceEntity &#91;required&#93; The entity that you are using as a source when you update the dashboard.
#' In `SourceEntity`, you specify the type of object you're using as
#' source. You can only update a dashboard from a template, so you use a
#' `SourceTemplate` entity. If you need to update a dashboard from an
#' analysis, first convert the analysis to a template by using the
#' [`create_template`][quicksight_create_template] API operation. For
#' `SourceTemplate`, specify the Amazon Resource Name (ARN) of the source
#' template. The `SourceTemplate` ARN can contain any Amazon Web Services
#' account and any Amazon QuickSight-supported Amazon Web Services Region.
#' 
#' Use the `DataSetReferences` entity within `SourceTemplate` to list the
#' replacement datasets for the placeholders listed in the original. The
#' schema in each dataset must match its placeholder.
#' @param Parameters A structure that contains the parameters of the dashboard. These are
#' parameter overrides for a dashboard. A dashboard can have any type of
#' parameters, and some parameters might accept multiple values.
#' @param VersionDescription A description for the first version of the dashboard being created.
#' @param DashboardPublishOptions Options for publishing the dashboard when you create it:
#' 
#' -   `AvailabilityStatus` for `AdHocFilteringOption` - This status can be
#'     either `ENABLED` or `DISABLED`. When this is set to `DISABLED`,
#'     Amazon QuickSight disables the left filter pane on the published
#'     dashboard, which can be used for ad hoc (one-time) filtering. This
#'     option is `ENABLED` by default.
#' 
#' -   `AvailabilityStatus` for `ExportToCSVOption` - This status can be
#'     either `ENABLED` or `DISABLED`. The visual option to export data to
#'     .CSV format isn't enabled when this is set to `DISABLED`. This
#'     option is `ENABLED` by default.
#' 
#' -   `VisibilityState` for `SheetControlsOption` - This visibility state
#'     can be either `COLLAPSED` or `EXPANDED`. This option is `COLLAPSED`
#'     by default.
#' @param ThemeArn The Amazon Resource Name (ARN) of the theme that is being used for this
#' dashboard. If you add a value for this field, it overrides the value
#' that was originally associated with the entity. The theme ARN must exist
#' in the same Amazon Web Services account where you create the dashboard.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_dashboard
quicksight_update_dashboard <- function(AwsAccountId, DashboardId, Name, SourceEntity, Parameters = NULL, VersionDescription = NULL, DashboardPublishOptions = NULL, ThemeArn = NULL) {
  op <- new_operation(
    name = "UpdateDashboard",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
    paginator = list()
  )
  input <- .quicksight$update_dashboard_input(AwsAccountId = AwsAccountId, DashboardId = DashboardId, Name = Name, SourceEntity = SourceEntity, Parameters = Parameters, VersionDescription = VersionDescription, DashboardPublishOptions = DashboardPublishOptions, ThemeArn = ThemeArn)
  output <- .quicksight$update_dashboard_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_dashboard <- quicksight_update_dashboard

#' Updates read and write permissions on a dashboard
#'
#' @description
#' Updates read and write permissions on a dashboard.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_dashboard_permissions.html](https://paws-r.github.io/docs/quicksight/update_dashboard_permissions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the dashboard
#' whose permissions you're updating.
#' @param DashboardId &#91;required&#93; The ID for the dashboard.
#' @param GrantPermissions The permissions that you want to grant on this resource.
#' @param RevokePermissions The permissions that you want to revoke from this resource.
#' @param GrantLinkPermissions Grants link permissions to all users in a defined namespace.
#' @param RevokeLinkPermissions Revokes link permissions from all users in a defined namespace.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_dashboard_permissions
quicksight_update_dashboard_permissions <- function(AwsAccountId, DashboardId, GrantPermissions = NULL, RevokePermissions = NULL, GrantLinkPermissions = NULL, RevokeLinkPermissions = NULL) {
  op <- new_operation(
    name = "UpdateDashboardPermissions",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions",
    paginator = list()
  )
  input <- .quicksight$update_dashboard_permissions_input(AwsAccountId = AwsAccountId, DashboardId = DashboardId, GrantPermissions = GrantPermissions, RevokePermissions = RevokePermissions, GrantLinkPermissions = GrantLinkPermissions, RevokeLinkPermissions = RevokeLinkPermissions)
  output <- .quicksight$update_dashboard_permissions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_dashboard_permissions <- quicksight_update_dashboard_permissions

#' Updates the published version of a dashboard
#'
#' @description
#' Updates the published version of a dashboard.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_dashboard_published_version.html](https://paws-r.github.io/docs/quicksight/update_dashboard_published_version.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the dashboard
#' that you're updating.
#' @param DashboardId &#91;required&#93; The ID for the dashboard.
#' @param VersionNumber &#91;required&#93; The version number of the dashboard.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_dashboard_published_version
quicksight_update_dashboard_published_version <- function(AwsAccountId, DashboardId, VersionNumber) {
  op <- new_operation(
    name = "UpdateDashboardPublishedVersion",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/dashboards/{DashboardId}/versions/{VersionNumber}",
    paginator = list()
  )
  input <- .quicksight$update_dashboard_published_version_input(AwsAccountId = AwsAccountId, DashboardId = DashboardId, VersionNumber = VersionNumber)
  output <- .quicksight$update_dashboard_published_version_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_dashboard_published_version <- quicksight_update_dashboard_published_version

#' Updates a dataset
#'
#' @description
#' Updates a dataset. This operation doesn't support datasets that include uploaded files as a source.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_data_set.html](https://paws-r.github.io/docs/quicksight/update_data_set.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param DataSetId &#91;required&#93; The ID for the dataset that you want to update. This ID is unique per
#' Amazon Web Services Region for each Amazon Web Services account.
#' @param Name &#91;required&#93; The display name for the dataset.
#' @param PhysicalTableMap &#91;required&#93; Declares the physical tables that are available in the underlying data
#' sources.
#' @param LogicalTableMap Configures the combination and transformation of the data from the
#' physical tables.
#' @param ImportMode &#91;required&#93; Indicates whether you want to import the data into SPICE.
#' @param ColumnGroups Groupings of columns that work together in certain Amazon QuickSight
#' features. Currently, only geospatial hierarchy is supported.
#' @param FieldFolders The folder that contains fields and nested subfolders for your dataset.
#' @param RowLevelPermissionDataSet The row-level security configuration for the data you want to create.
#' @param RowLevelPermissionTagConfiguration The configuration of tags on a dataset to set row-level security.
#' Row-level security tags are currently supported for anonymous embedding
#' only.
#' @param ColumnLevelPermissionRules A set of one or more definitions of a ` ColumnLevelPermissionRule `.
#' @param DataSetUsageConfiguration 
#'
#' @keywords internal
#'
#' @rdname quicksight_update_data_set
quicksight_update_data_set <- function(AwsAccountId, DataSetId, Name, PhysicalTableMap, LogicalTableMap = NULL, ImportMode, ColumnGroups = NULL, FieldFolders = NULL, RowLevelPermissionDataSet = NULL, RowLevelPermissionTagConfiguration = NULL, ColumnLevelPermissionRules = NULL, DataSetUsageConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateDataSet",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
    paginator = list()
  )
  input <- .quicksight$update_data_set_input(AwsAccountId = AwsAccountId, DataSetId = DataSetId, Name = Name, PhysicalTableMap = PhysicalTableMap, LogicalTableMap = LogicalTableMap, ImportMode = ImportMode, ColumnGroups = ColumnGroups, FieldFolders = FieldFolders, RowLevelPermissionDataSet = RowLevelPermissionDataSet, RowLevelPermissionTagConfiguration = RowLevelPermissionTagConfiguration, ColumnLevelPermissionRules = ColumnLevelPermissionRules, DataSetUsageConfiguration = DataSetUsageConfiguration)
  output <- .quicksight$update_data_set_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_data_set <- quicksight_update_data_set

#' Updates the permissions on a dataset
#'
#' @description
#' Updates the permissions on a dataset.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_data_set_permissions.html](https://paws-r.github.io/docs/quicksight/update_data_set_permissions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param DataSetId &#91;required&#93; The ID for the dataset whose permissions you want to update. This ID is
#' unique per Amazon Web Services Region for each Amazon Web Services
#' account.
#' @param GrantPermissions The resource permissions that you want to grant to the dataset.
#' @param RevokePermissions The resource permissions that you want to revoke from the dataset.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_data_set_permissions
quicksight_update_data_set_permissions <- function(AwsAccountId, DataSetId, GrantPermissions = NULL, RevokePermissions = NULL) {
  op <- new_operation(
    name = "UpdateDataSetPermissions",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/data-sets/{DataSetId}/permissions",
    paginator = list()
  )
  input <- .quicksight$update_data_set_permissions_input(AwsAccountId = AwsAccountId, DataSetId = DataSetId, GrantPermissions = GrantPermissions, RevokePermissions = RevokePermissions)
  output <- .quicksight$update_data_set_permissions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_data_set_permissions <- quicksight_update_data_set_permissions

#' Updates a data source
#'
#' @description
#' Updates a data source.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_data_source.html](https://paws-r.github.io/docs/quicksight/update_data_source.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param DataSourceId &#91;required&#93; The ID of the data source. This ID is unique per Amazon Web Services
#' Region for each Amazon Web Services account.
#' @param Name &#91;required&#93; A display name for the data source.
#' @param DataSourceParameters The parameters that Amazon QuickSight uses to connect to your underlying
#' source.
#' @param Credentials The credentials that Amazon QuickSight that uses to connect to your
#' underlying source. Currently, only credentials based on user name and
#' password are supported.
#' @param VpcConnectionProperties Use this parameter only when you want Amazon QuickSight to use a VPC
#' connection when connecting to your underlying source.
#' @param SslProperties Secure Socket Layer (SSL) properties that apply when Amazon QuickSight
#' connects to your underlying source.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_data_source
quicksight_update_data_source <- function(AwsAccountId, DataSourceId, Name, DataSourceParameters = NULL, Credentials = NULL, VpcConnectionProperties = NULL, SslProperties = NULL) {
  op <- new_operation(
    name = "UpdateDataSource",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
    paginator = list()
  )
  input <- .quicksight$update_data_source_input(AwsAccountId = AwsAccountId, DataSourceId = DataSourceId, Name = Name, DataSourceParameters = DataSourceParameters, Credentials = Credentials, VpcConnectionProperties = VpcConnectionProperties, SslProperties = SslProperties)
  output <- .quicksight$update_data_source_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_data_source <- quicksight_update_data_source

#' Updates the permissions to a data source
#'
#' @description
#' Updates the permissions to a data source.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_data_source_permissions.html](https://paws-r.github.io/docs/quicksight/update_data_source_permissions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID.
#' @param DataSourceId &#91;required&#93; The ID of the data source. This ID is unique per Amazon Web Services
#' Region for each Amazon Web Services account.
#' @param GrantPermissions A list of resource permissions that you want to grant on the data
#' source.
#' @param RevokePermissions A list of resource permissions that you want to revoke on the data
#' source.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_data_source_permissions
quicksight_update_data_source_permissions <- function(AwsAccountId, DataSourceId, GrantPermissions = NULL, RevokePermissions = NULL) {
  op <- new_operation(
    name = "UpdateDataSourcePermissions",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions",
    paginator = list()
  )
  input <- .quicksight$update_data_source_permissions_input(AwsAccountId = AwsAccountId, DataSourceId = DataSourceId, GrantPermissions = GrantPermissions, RevokePermissions = RevokePermissions)
  output <- .quicksight$update_data_source_permissions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_data_source_permissions <- quicksight_update_data_source_permissions

#' Updates the name of a folder
#'
#' @description
#' Updates the name of a folder.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_folder.html](https://paws-r.github.io/docs/quicksight/update_folder.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the folder to
#' update.
#' @param FolderId &#91;required&#93; The ID of the folder.
#' @param Name &#91;required&#93; The name of the folder.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_folder
quicksight_update_folder <- function(AwsAccountId, FolderId, Name) {
  op <- new_operation(
    name = "UpdateFolder",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/folders/{FolderId}",
    paginator = list()
  )
  input <- .quicksight$update_folder_input(AwsAccountId = AwsAccountId, FolderId = FolderId, Name = Name)
  output <- .quicksight$update_folder_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_folder <- quicksight_update_folder

#' Updates permissions of a folder
#'
#' @description
#' Updates permissions of a folder.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_folder_permissions.html](https://paws-r.github.io/docs/quicksight/update_folder_permissions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that contains the folder to
#' update.
#' @param FolderId &#91;required&#93; The ID of the folder.
#' @param GrantPermissions The permissions that you want to grant on a resource.
#' @param RevokePermissions The permissions that you want to revoke from a resource.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_folder_permissions
quicksight_update_folder_permissions <- function(AwsAccountId, FolderId, GrantPermissions = NULL, RevokePermissions = NULL) {
  op <- new_operation(
    name = "UpdateFolderPermissions",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/folders/{FolderId}/permissions",
    paginator = list()
  )
  input <- .quicksight$update_folder_permissions_input(AwsAccountId = AwsAccountId, FolderId = FolderId, GrantPermissions = GrantPermissions, RevokePermissions = RevokePermissions)
  output <- .quicksight$update_folder_permissions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_folder_permissions <- quicksight_update_folder_permissions

#' Changes a group description
#'
#' @description
#' Changes a group description.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_group.html](https://paws-r.github.io/docs/quicksight/update_group.html) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name of the group that you want to update.
#' @param Description The description for the group that you want to update.
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the group is in.
#' Currently, you use the ID for the Amazon Web Services account that
#' contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace of the group that you want to update.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_group
quicksight_update_group <- function(GroupName, Description = NULL, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "UpdateGroup",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
    paginator = list()
  )
  input <- .quicksight$update_group_input(GroupName = GroupName, Description = Description, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$update_group_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_group <- quicksight_update_group

#' Updates an existing IAM policy assignment
#'
#' @description
#' Updates an existing IAM policy assignment. This operation updates only the optional parameter or parameters that are specified in the request. This overwrites all of the users included in `Identities`.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_iam_policy_assignment.html](https://paws-r.github.io/docs/quicksight/update_iam_policy_assignment.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the IAM policy
#' assignment.
#' @param AssignmentName &#91;required&#93; The name of the assignment, also called a rule. This name must be unique
#' within an Amazon Web Services account.
#' @param Namespace &#91;required&#93; The namespace of the assignment.
#' @param AssignmentStatus The status of the assignment. Possible values are as follows:
#' 
#' -   `ENABLED` - Anything specified in this assignment is used when
#'     creating the data source.
#' 
#' -   `DISABLED` - This assignment isn't used when creating the data
#'     source.
#' 
#' -   `DRAFT` - This assignment is an unfinished draft and isn't used when
#'     creating the data source.
#' @param PolicyArn The ARN for the IAM policy to apply to the Amazon QuickSight users and
#' groups specified in this assignment.
#' @param Identities The Amazon QuickSight users, groups, or both that you want to assign the
#' policy to.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_iam_policy_assignment
quicksight_update_iam_policy_assignment <- function(AwsAccountId, AssignmentName, Namespace, AssignmentStatus = NULL, PolicyArn = NULL, Identities = NULL) {
  op <- new_operation(
    name = "UpdateIAMPolicyAssignment",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/{AssignmentName}",
    paginator = list()
  )
  input <- .quicksight$update_iam_policy_assignment_input(AwsAccountId = AwsAccountId, AssignmentName = AssignmentName, Namespace = Namespace, AssignmentStatus = AssignmentStatus, PolicyArn = PolicyArn, Identities = Identities)
  output <- .quicksight$update_iam_policy_assignment_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_iam_policy_assignment <- quicksight_update_iam_policy_assignment

#' Updates the content and status of IP rules
#'
#' @description
#' Updates the content and status of IP rules. To use this operation, you need to provide the entire map of rules. You can use the [`describe_ip_restriction`][quicksight_describe_ip_restriction] operation to get the current rule map.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_ip_restriction.html](https://paws-r.github.io/docs/quicksight/update_ip_restriction.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the IP rules.
#' @param IpRestrictionRuleMap A map that describes the updated IP rules with CIDR ranges and
#' descriptions.
#' @param Enabled A value that specifies whether IP rules are turned on.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_ip_restriction
quicksight_update_ip_restriction <- function(AwsAccountId, IpRestrictionRuleMap = NULL, Enabled = NULL) {
  op <- new_operation(
    name = "UpdateIpRestriction",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/ip-restriction",
    paginator = list()
  )
  input <- .quicksight$update_ip_restriction_input(AwsAccountId = AwsAccountId, IpRestrictionRuleMap = IpRestrictionRuleMap, Enabled = Enabled)
  output <- .quicksight$update_ip_restriction_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_ip_restriction <- quicksight_update_ip_restriction

#' Use the UpdatePublicSharingSettings operation to turn on or turn off the
#' public sharing settings of an Amazon QuickSight dashboard
#'
#' @description
#' Use the [`update_public_sharing_settings`][quicksight_update_public_sharing_settings] operation to turn on or turn off the public sharing settings of an Amazon QuickSight dashboard.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_public_sharing_settings.html](https://paws-r.github.io/docs/quicksight/update_public_sharing_settings.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The Amazon Web Services account ID associated with your Amazon
#' QuickSight subscription.
#' @param PublicSharingEnabled A Boolean value that indicates whether public sharing is turned on for
#' an Amazon QuickSight account.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_public_sharing_settings
quicksight_update_public_sharing_settings <- function(AwsAccountId, PublicSharingEnabled = NULL) {
  op <- new_operation(
    name = "UpdatePublicSharingSettings",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/public-sharing-settings",
    paginator = list()
  )
  input <- .quicksight$update_public_sharing_settings_input(AwsAccountId = AwsAccountId, PublicSharingEnabled = PublicSharingEnabled)
  output <- .quicksight$update_public_sharing_settings_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_public_sharing_settings <- quicksight_update_public_sharing_settings

#' Updates a template from an existing Amazon QuickSight analysis or
#' another template
#'
#' @description
#' Updates a template from an existing Amazon QuickSight analysis or another template.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_template.html](https://paws-r.github.io/docs/quicksight/update_template.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the template
#' that you're updating.
#' @param TemplateId &#91;required&#93; The ID for the template.
#' @param SourceEntity &#91;required&#93; The entity that you are using as a source when you update the template.
#' In `SourceEntity`, you specify the type of object you're using as
#' source: `SourceTemplate` for a template or `SourceAnalysis` for an
#' analysis. Both of these require an Amazon Resource Name (ARN). For
#' `SourceTemplate`, specify the ARN of the source template. For
#' `SourceAnalysis`, specify the ARN of the source analysis. The
#' `SourceTemplate` ARN can contain any Amazon Web Services account and any
#' Amazon QuickSight-supported Amazon Web Services Region;.
#' 
#' Use the `DataSetReferences` entity within `SourceTemplate` or
#' `SourceAnalysis` to list the replacement datasets for the placeholders
#' listed in the original. The schema in each dataset must match its
#' placeholder.
#' @param VersionDescription A description of the current template version that is being updated.
#' Every time you call [`update_template`][quicksight_update_template], you
#' create a new version of the template. Each version of the template
#' maintains a description of the version in the `VersionDescription`
#' field.
#' @param Name The name for the template.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_template
quicksight_update_template <- function(AwsAccountId, TemplateId, SourceEntity, VersionDescription = NULL, Name = NULL) {
  op <- new_operation(
    name = "UpdateTemplate",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/templates/{TemplateId}",
    paginator = list()
  )
  input <- .quicksight$update_template_input(AwsAccountId = AwsAccountId, TemplateId = TemplateId, SourceEntity = SourceEntity, VersionDescription = VersionDescription, Name = Name)
  output <- .quicksight$update_template_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_template <- quicksight_update_template

#' Updates the template alias of a template
#'
#' @description
#' Updates the template alias of a template.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_template_alias.html](https://paws-r.github.io/docs/quicksight/update_template_alias.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the template
#' alias that you're updating.
#' @param TemplateId &#91;required&#93; The ID for the template.
#' @param AliasName &#91;required&#93; The alias of the template that you want to update. If you name a
#' specific alias, you update the version that the alias points to. You can
#' specify the latest version of the template by providing the keyword
#' `$LATEST` in the `AliasName` parameter. The keyword `$PUBLISHED` doesn't
#' apply to templates.
#' @param TemplateVersionNumber &#91;required&#93; The version number of the template.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_template_alias
quicksight_update_template_alias <- function(AwsAccountId, TemplateId, AliasName, TemplateVersionNumber) {
  op <- new_operation(
    name = "UpdateTemplateAlias",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
    paginator = list()
  )
  input <- .quicksight$update_template_alias_input(AwsAccountId = AwsAccountId, TemplateId = TemplateId, AliasName = AliasName, TemplateVersionNumber = TemplateVersionNumber)
  output <- .quicksight$update_template_alias_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_template_alias <- quicksight_update_template_alias

#' Updates the resource permissions for a template
#'
#' @description
#' Updates the resource permissions for a template.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_template_permissions.html](https://paws-r.github.io/docs/quicksight/update_template_permissions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the template.
#' @param TemplateId &#91;required&#93; The ID for the template.
#' @param GrantPermissions A list of resource permissions to be granted on the template.
#' @param RevokePermissions A list of resource permissions to be revoked from the template.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_template_permissions
quicksight_update_template_permissions <- function(AwsAccountId, TemplateId, GrantPermissions = NULL, RevokePermissions = NULL) {
  op <- new_operation(
    name = "UpdateTemplatePermissions",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/templates/{TemplateId}/permissions",
    paginator = list()
  )
  input <- .quicksight$update_template_permissions_input(AwsAccountId = AwsAccountId, TemplateId = TemplateId, GrantPermissions = GrantPermissions, RevokePermissions = RevokePermissions)
  output <- .quicksight$update_template_permissions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_template_permissions <- quicksight_update_template_permissions

#' Updates a theme
#'
#' @description
#' Updates a theme.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_theme.html](https://paws-r.github.io/docs/quicksight/update_theme.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the theme that
#' you're updating.
#' @param ThemeId &#91;required&#93; The ID for the theme.
#' @param Name The name for the theme.
#' @param BaseThemeId &#91;required&#93; The theme ID, defined by Amazon QuickSight, that a custom theme inherits
#' from. All themes initially inherit from a default Amazon QuickSight
#' theme.
#' @param VersionDescription A description of the theme version that you're updating Every time that
#' you call [`update_theme`][quicksight_update_theme], you create a new
#' version of the theme. Each version of the theme maintains a description
#' of the version in `VersionDescription`.
#' @param Configuration The theme configuration, which contains the theme display properties.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_theme
quicksight_update_theme <- function(AwsAccountId, ThemeId, Name = NULL, BaseThemeId, VersionDescription = NULL, Configuration = NULL) {
  op <- new_operation(
    name = "UpdateTheme",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/themes/{ThemeId}",
    paginator = list()
  )
  input <- .quicksight$update_theme_input(AwsAccountId = AwsAccountId, ThemeId = ThemeId, Name = Name, BaseThemeId = BaseThemeId, VersionDescription = VersionDescription, Configuration = Configuration)
  output <- .quicksight$update_theme_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_theme <- quicksight_update_theme

#' Updates an alias of a theme
#'
#' @description
#' Updates an alias of a theme.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_theme_alias.html](https://paws-r.github.io/docs/quicksight/update_theme_alias.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the theme alias
#' that you're updating.
#' @param ThemeId &#91;required&#93; The ID for the theme.
#' @param AliasName &#91;required&#93; The name of the theme alias that you want to update.
#' @param ThemeVersionNumber &#91;required&#93; The version number of the theme that the alias should reference.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_theme_alias
quicksight_update_theme_alias <- function(AwsAccountId, ThemeId, AliasName, ThemeVersionNumber) {
  op <- new_operation(
    name = "UpdateThemeAlias",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
    paginator = list()
  )
  input <- .quicksight$update_theme_alias_input(AwsAccountId = AwsAccountId, ThemeId = ThemeId, AliasName = AliasName, ThemeVersionNumber = ThemeVersionNumber)
  output <- .quicksight$update_theme_alias_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_theme_alias <- quicksight_update_theme_alias

#' Updates the resource permissions for a theme
#'
#' @description
#' Updates the resource permissions for a theme. Permissions apply to the action to grant or revoke permissions on, for example `"quicksight:DescribeTheme"`.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_theme_permissions.html](https://paws-r.github.io/docs/quicksight/update_theme_permissions.html) for full documentation.
#'
#' @param AwsAccountId &#91;required&#93; The ID of the Amazon Web Services account that contains the theme.
#' @param ThemeId &#91;required&#93; The ID for the theme.
#' @param GrantPermissions A list of resource permissions to be granted for the theme.
#' @param RevokePermissions A list of resource permissions to be revoked from the theme.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_theme_permissions
quicksight_update_theme_permissions <- function(AwsAccountId, ThemeId, GrantPermissions = NULL, RevokePermissions = NULL) {
  op <- new_operation(
    name = "UpdateThemePermissions",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/themes/{ThemeId}/permissions",
    paginator = list()
  )
  input <- .quicksight$update_theme_permissions_input(AwsAccountId = AwsAccountId, ThemeId = ThemeId, GrantPermissions = GrantPermissions, RevokePermissions = RevokePermissions)
  output <- .quicksight$update_theme_permissions_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_theme_permissions <- quicksight_update_theme_permissions

#' Updates an Amazon QuickSight user
#'
#' @description
#' Updates an Amazon QuickSight user.
#'
#' See [https://paws-r.github.io/docs/quicksight/update_user.html](https://paws-r.github.io/docs/quicksight/update_user.html) for full documentation.
#'
#' @param UserName &#91;required&#93; The Amazon QuickSight user name that you want to update.
#' @param AwsAccountId &#91;required&#93; The ID for the Amazon Web Services account that the user is in.
#' Currently, you use the ID for the Amazon Web Services account that
#' contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#' @param Email &#91;required&#93; The email address of the user that you want to update.
#' @param Role &#91;required&#93; The Amazon QuickSight role of the user. The role can be one of the
#' following default security cohorts:
#' 
#' -   `READER`: A user who has read-only access to dashboards.
#' 
#' -   `AUTHOR`: A user who can create data sources, datasets, analyses,
#'     and dashboards.
#' 
#' -   `ADMIN`: A user who is an author, who can also manage Amazon
#'     QuickSight settings.
#' 
#' The name of the Amazon QuickSight role is invisible to the user except
#' for the console screens dealing with permissions.
#' @param CustomPermissionsName (Enterprise edition only) The name of the custom permissions profile
#' that you want to assign to this user. Customized permissions allows you
#' to control a user's access by restricting access the following
#' operations:
#' 
#' -   Create and update data sources
#' 
#' -   Create and update datasets
#' 
#' -   Create and update email reports
#' 
#' -   Subscribe to email reports
#' 
#' A set of custom permissions includes any combination of these
#' restrictions. Currently, you need to create the profile names for custom
#' permission sets by using the Amazon QuickSight console. Then, you use
#' the [`register_user`][quicksight_register_user] API operation to assign
#' the named set of permissions to a Amazon QuickSight user.
#' 
#' Amazon QuickSight custom permissions are applied through IAM policies.
#' Therefore, they override the permissions typically granted by assigning
#' Amazon QuickSight users to one of the default security cohorts in Amazon
#' QuickSight (admin, author, reader).
#' 
#' This feature is available only to Amazon QuickSight Enterprise edition
#' subscriptions.
#' @param UnapplyCustomPermissions A flag that you use to indicate that you want to remove all custom
#' permissions from this user. Using this parameter resets the user to the
#' state it was in before a custom permissions profile was applied. This
#' parameter defaults to NULL and it doesn't accept any other value.
#' @param ExternalLoginFederationProviderType The type of supported external login provider that provides identity to
#' let a user federate into Amazon QuickSight with an associated Identity
#' and Access Management(IAM) role. The type of supported external login
#' provider can be one of the following.
#' 
#' -   `COGNITO`: Amazon Cognito. The provider URL is
#'     cognito-identity.amazonaws.com. When choosing the `COGNITO` provider
#'     type, don’t use the "CustomFederationProviderUrl" parameter which is
#'     only needed when the external provider is custom.
#' 
#' -   `CUSTOM_OIDC`: Custom OpenID Connect (OIDC) provider. When choosing
#'     `CUSTOM_OIDC` type, use the `CustomFederationProviderUrl` parameter
#'     to provide the custom OIDC provider URL.
#' 
#' -   `NONE`: This clears all the previously saved external login
#'     information for a user. Use the
#'     [`describe_user`][quicksight_describe_user] API operation to check
#'     the external login information.
#' @param CustomFederationProviderUrl The URL of the custom OpenID Connect (OIDC) provider that provides
#' identity to let a user federate into Amazon QuickSight with an
#' associated Identity and Access Management(IAM) role. This parameter
#' should only be used when `ExternalLoginFederationProviderType` parameter
#' is set to `CUSTOM_OIDC`.
#' @param ExternalLoginId The identity ID for a user in the external login provider.
#'
#' @keywords internal
#'
#' @rdname quicksight_update_user
quicksight_update_user <- function(UserName, AwsAccountId, Namespace, Email, Role, CustomPermissionsName = NULL, UnapplyCustomPermissions = NULL, ExternalLoginFederationProviderType = NULL, CustomFederationProviderUrl = NULL, ExternalLoginId = NULL) {
  op <- new_operation(
    name = "UpdateUser",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
    paginator = list()
  )
  input <- .quicksight$update_user_input(UserName = UserName, AwsAccountId = AwsAccountId, Namespace = Namespace, Email = Email, Role = Role, CustomPermissionsName = CustomPermissionsName, UnapplyCustomPermissions = UnapplyCustomPermissions, ExternalLoginFederationProviderType = ExternalLoginFederationProviderType, CustomFederationProviderUrl = CustomFederationProviderUrl, ExternalLoginId = ExternalLoginId)
  output <- .quicksight$update_user_output()
  config <- get_config()
  svc <- .quicksight$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_user <- quicksight_update_user
