% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_update_experience}
\alias{kendra_update_experience}
\title{Updates your Amazon Kendra experience such as a search application}
\usage{
kendra_update_experience(
  Id,
  Name = NULL,
  IndexId,
  RoleArn = NULL,
  Configuration = NULL,
  Description = NULL
)
}
\arguments{
\item{Id}{[required] The identifier of your Amazon Kendra experience you want to update.}

\item{Name}{A new name for your Amazon Kendra experience.}

\item{IndexId}{[required] The identifier of the index for your Amazon Kendra experience.}

\item{RoleArn}{The Amazon Resource Name (ARN) of a role with permission to access
\code{\link[=kendra_query]{query}} API, \code{QuerySuggestions} API,
\code{\link[=kendra_submit_feedback]{submit_feedback}} API, and Amazon Web Services
SSO that stores your user and group information. For more information,
see \href{https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html}{IAM roles for Amazon Kendra}.}

\item{Configuration}{Configuration information you want to update for your Amazon Kendra
experience.}

\item{Description}{A new description for your Amazon Kendra experience.}
}
\description{
Updates your Amazon Kendra experience such as a search application. For more information on creating a search application experience, see \href{https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html}{Building a search experience with no code}.

See \url{https://paws-r.github.io/docs/kendra/update_experience.html} for full documentation.
}
\keyword{internal}
