% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datapipeline_operations.R
\name{datapipeline_create_pipeline}
\alias{datapipeline_create_pipeline}
\title{Creates a new, empty pipeline}
\usage{
datapipeline_create_pipeline(name, uniqueId, description = NULL, tags = NULL)
}
\arguments{
\item{name}{[required] The name for the pipeline. You can use the same name for multiple
pipelines associated with your AWS account, because AWS Data Pipeline
assigns each pipeline a unique pipeline identifier.}

\item{uniqueId}{[required] A unique identifier. This identifier is not the same as the pipeline
identifier assigned by AWS Data Pipeline. You are responsible for
defining the format and ensuring the uniqueness of this identifier. You
use this parameter to ensure idempotency during repeated calls to
\code{\link[=datapipeline_create_pipeline]{create_pipeline}}. For example, if the
first call to \code{\link[=datapipeline_create_pipeline]{create_pipeline}} does not
succeed, you can pass in the same unique identifier and pipeline name
combination on a subsequent call to
\code{\link[=datapipeline_create_pipeline]{create_pipeline}}.
\code{\link[=datapipeline_create_pipeline]{create_pipeline}} ensures that if a
pipeline already exists with the same name and unique identifier, a new
pipeline is not created. Instead, you'll receive the pipeline identifier
from the previous attempt. The uniqueness of the name and unique
identifier combination is scoped to the AWS account or IAM user
credentials.}

\item{description}{The description for the pipeline.}

\item{tags}{A list of tags to associate with the pipeline at creation. Tags let you
control access to pipelines. For more information, see \href{https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html}{Controlling User Access to Pipelines}
in the \emph{AWS Data Pipeline Developer Guide}.}
}
\description{
Creates a new, empty pipeline. Use \code{\link[=datapipeline_put_pipeline_definition]{put_pipeline_definition}} to populate the pipeline.

See \url{https://www.paws-r-sdk.com/docs/datapipeline_create_pipeline/} for full documentation.
}
\keyword{internal}
