% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_update_studio_session_mapping}
\alias{emr_update_studio_session_mapping}
\title{Updates the session policy attached to the user or group for the
specified Amazon EMR Studio}
\usage{
emr_update_studio_session_mapping(
  StudioId,
  IdentityId = NULL,
  IdentityName = NULL,
  IdentityType,
  SessionPolicyArn
)
}
\arguments{
\item{StudioId}{[required] The ID of the Amazon EMR Studio.}

\item{IdentityId}{The globally unique identifier (GUID) of the user or group. For more
information, see
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId}{UserId}
and
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId}{GroupId}
in the \emph{IAM Identity Center Identity Store API Reference}. Either
\code{IdentityName} or \code{IdentityId} must be specified.}

\item{IdentityName}{The name of the user or group to update. For more information, see
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName}{UserName}
and
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName}{DisplayName}
in the \emph{IAM Identity Center Identity Store API Reference}. Either
\code{IdentityName} or \code{IdentityId} must be specified.}

\item{IdentityType}{[required] Specifies whether the identity to update is a user or a group.}

\item{SessionPolicyArn}{[required] The Amazon Resource Name (ARN) of the session policy to associate with
the specified user or group.}
}
\description{
Updates the session policy attached to the user or group for the specified Amazon EMR Studio.

See \url{https://www.paws-r-sdk.com/docs/emr_update_studio_session_mapping/} for full documentation.
}
\keyword{internal}
