% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_start_workflow_execution}
\alias{swf_start_workflow_execution}
\title{Starts an execution of the workflow type in the specified domain using
the provided workflowId and input data}
\usage{
swf_start_workflow_execution(domain, workflowId, workflowType, taskList,
  taskPriority, input, executionStartToCloseTimeout, tagList,
  taskStartToCloseTimeout, childPolicy, lambdaRole)
}
\arguments{
\item{domain}{[required] The name of the domain in which the workflow execution is created.}

\item{workflowId}{[required] The user defined identifier associated with the workflow execution. You
can use this to associate a custom identifier with the workflow
execution. You may specify the same identifier if a workflow execution
is logically a \emph{restart} of a previous execution. You cannot have two
open workflow executions with the same \code{workflowId} at the same time
within the same domain.

The specified string must not start or end with whitespace. It must not
contain a \code{:} (colon), \code{/} (slash), \code{|} (vertical bar), or any control
characters (\verb{U+0000`-`U+001f} | \verb{U+007f`-`U+009f}). Also, it must not \emph{be}
the literal string \code{arn}.}

\item{workflowType}{[required] The type of the workflow to start.}

\item{taskList}{The task list to use for the decision tasks generated for this workflow
execution. This overrides the \code{defaultTaskList} specified when
registering the workflow type.

A task list for this workflow execution must be specified either as a
default for the workflow type or through this parameter. If neither this
parameter is set nor a default task list was specified at registration
time then a fault is returned.

The specified string must not start or end with whitespace. It must not
contain a \code{:} (colon), \code{/} (slash), \code{|} (vertical bar), or any control
characters (\verb{U+0000`-`U+001f} | \verb{U+007f`-`U+009f}). Also, it must not \emph{be}
the literal string \code{arn}.}

\item{taskPriority}{The task priority to use for this workflow execution. This overrides any
default priority that was assigned when the workflow type was
registered. If not set, then the default task priority for the workflow
type is used. Valid values are integers that range from Java's
\code{Integer.MIN_VALUE} (-2147483648) to \code{Integer.MAX_VALUE} (2147483647).
Higher numbers indicate higher priority.

For more information about setting task priority, see \href{https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html}{Setting Task Priority}
in the \emph{Amazon SWF Developer Guide}.}

\item{input}{The input for the workflow execution. This is a free form string which
should be meaningful to the workflow you are starting. This \code{input} is
made available to the new workflow execution in the
\code{WorkflowExecutionStarted} history event.}

\item{executionStartToCloseTimeout}{The total duration for this workflow execution. This overrides the
defaultExecutionStartToCloseTimeout specified when registering the
workflow type.

The duration is specified in seconds; an integer greater than or equal
to \code{0}. Exceeding this limit causes the workflow execution to time out.
Unlike some of the other timeout parameters in Amazon SWF, you cannot
specify a value of "NONE" for this timeout; there is a one-year max
limit on the time that a workflow execution can run.

An execution start-to-close timeout must be specified either through
this parameter or as a default when the workflow type is registered. If
neither this parameter nor a default execution start-to-close timeout is
specified, a fault is returned.}

\item{tagList}{The list of tags to associate with the workflow execution. You can
specify a maximum of 5 tags. You can list workflow executions with a
specific tag by calling ListOpenWorkflowExecutions or
ListClosedWorkflowExecutions and specifying a TagFilter.}

\item{taskStartToCloseTimeout}{Specifies the maximum duration of decision tasks for this workflow
execution. This parameter overrides the \code{defaultTaskStartToCloseTimout}
specified when registering the workflow type using RegisterWorkflowType.

The duration is specified in seconds, an integer greater than or equal
to \code{0}. You can use \code{NONE} to specify unlimited duration.

A task start-to-close timeout for this workflow execution must be
specified either as a default for the workflow type or through this
parameter. If neither this parameter is set nor a default task
start-to-close timeout was specified at registration time then a fault
is returned.}

\item{childPolicy}{If set, specifies the policy to use for the child workflow executions of
this workflow execution if it is terminated, by calling the
TerminateWorkflowExecution action explicitly or due to an expired
timeout. This policy overrides the default child policy specified when
registering the workflow type using RegisterWorkflowType.

The supported child policies are:
\itemize{
\item \code{TERMINATE} – The child executions are terminated.
\item \code{REQUEST_CANCEL} – A request to cancel is attempted for each child
execution by recording a \code{WorkflowExecutionCancelRequested} event in
its history. It is up to the decider to take appropriate actions
when it receives an execution history with this event.
\item \code{ABANDON} – No action is taken. The child executions continue to
run.
}

A child policy for this workflow execution must be specified either as a
default for the workflow type or through this parameter. If neither this
parameter is set nor a default child policy was specified at
registration time then a fault is returned.}

\item{lambdaRole}{The IAM role to attach to this workflow execution.

Executions of this workflow type need IAM roles to invoke Lambda
functions. If you don't attach an IAM role, any attempt to schedule a
Lambda task fails. This results in a \code{ScheduleLambdaFunctionFailed}
history event. For more information, see
\url{https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html}
in the \emph{Amazon SWF Developer Guide}.}
}
\description{
Starts an execution of the workflow type in the specified domain using
the provided \code{workflowId} and input data.

This action returns the newly started workflow execution.

\strong{Access Control}

You can use IAM policies to control this action's access to Amazon SWF
resources as follows:
\itemize{
\item Use a \code{Resource} element with the domain name to limit the action to
only specified domains.
\item Use an \code{Action} element to allow or deny permission to call this
action.
\item Constrain the following parameters by using a \code{Condition} element
with the appropriate keys.
\itemize{
\item \code{tagList.member.0}: The key is \code{swf:tagList.member.0}.
\item \code{tagList.member.1}: The key is \code{swf:tagList.member.1}.
\item \code{tagList.member.2}: The key is \code{swf:tagList.member.2}.
\item \code{tagList.member.3}: The key is \code{swf:tagList.member.3}.
\item \code{tagList.member.4}: The key is \code{swf:tagList.member.4}.
\item \code{taskList}: String constraint. The key is \code{swf:taskList.name}.
\item \code{workflowType.name}: String constraint. The key is
\code{swf:workflowType.name}.
\item \code{workflowType.version}: String constraint. The key is
\code{swf:workflowType.version}.
}
}

If the caller doesn't have sufficient permissions to invoke the action,
or the parameter values fall outside the specified constraints, the
action fails. The associated event attribute's \code{cause} parameter is set
to \code{OPERATION_NOT_PERMITTED}. For details and example IAM policies, see
\href{https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html}{Using IAM to Manage Access to Amazon SWF Workflows}
in the \emph{Amazon SWF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$start_workflow_execution(
  domain = "string",
  workflowId = "string",
  workflowType = list(
    name = "string",
    version = "string"
  ),
  taskList = list(
    name = "string"
  ),
  taskPriority = "string",
  input = "string",
  executionStartToCloseTimeout = "string",
  tagList = list(
    "string"
  ),
  taskStartToCloseTimeout = "string",
  childPolicy = "TERMINATE"|"REQUEST_CANCEL"|"ABANDON",
  lambdaRole = "string"
)
}
}

\keyword{internal}
