% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridge_operations.R
\name{eventbridge_list_rules}
\alias{eventbridge_list_rules}
\title{Lists your Amazon EventBridge rules}
\usage{
eventbridge_list_rules(
  NamePrefix = NULL,
  EventBusName = NULL,
  NextToken = NULL,
  Limit = NULL
)
}
\arguments{
\item{NamePrefix}{The prefix matching the rule name.}

\item{EventBusName}{The name or ARN of the event bus to list the rules for. If you omit
this, the default event bus is used.}

\item{NextToken}{The token returned by a previous call, which you can use to retrieve the
next set of results.

The value of \code{nextToken} is a unique pagination token for each page. To
retrieve the next page of results, make the call again using the
returned token. Keep all other arguments unchanged.

Using an expired pagination token results in an \verb{HTTP 400 InvalidToken}
error.}

\item{Limit}{The maximum number of results to return.}
}
\description{
Lists your Amazon EventBridge rules. You can either list all the rules or you can provide a prefix to match to the rule names.

See \url{https://www.paws-r-sdk.com/docs/eventbridge_list_rules/} for full documentation.
}
\keyword{internal}
