% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_availability_zones}
\alias{ec2_describe_availability_zones}
\title{Describes one or more of the Availability Zones that are available to
you}
\usage{
ec2_describe_availability_zones(Filters, ZoneNames, ZoneIds, DryRun)
}
\arguments{
\item{Filters}{One or more filters.
\itemize{
\item \code{message} - Information about the Availability Zone.
\item \code{region-name} - The name of the region for the Availability Zone
(for example, \code{us-east-1}).
\item \code{state} - The state of the Availability Zone (\code{available} \|
\code{information} \| \code{impaired} \| \code{unavailable}).
\item \code{zone-id} - The ID of the Availability Zone (for example,
\code{use1-az1}).
\item \code{zone-name} - The name of the Availability Zone (for example,
\code{us-east-1a}).
}}

\item{ZoneNames}{The names of one or more Availability Zones.}

\item{ZoneIds}{The IDs of one or more Availability Zones.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes one or more of the Availability Zones that are available to
you. The results include zones only for the region you're currently
using. If there is an event impacting an Availability Zone, you can use
this request to view the state and any provided message for that
Availability Zone.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html}{Regions and Availability Zones}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_availability_zones(
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  ZoneNames = list(
    "string"
  ),
  ZoneIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example describes the Availability Zones that are available to you.
# The response includes Availability Zones only for the current region.
\donttest{svc$describe_availability_zones()}

}
\keyword{internal}
