% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_placement_groups}
\alias{ec2_describe_placement_groups}
\title{Describes one or more of your placement groups}
\usage{
ec2_describe_placement_groups(Filters, DryRun, GroupNames)
}
\arguments{
\item{Filters}{One or more filters.
\itemize{
\item \code{group-name} - The name of the placement group.
\item \code{state} - The state of the placement group (\code{pending} \| \code{available}
\| \code{deleting} \| \code{deleted}).
\item \code{strategy} - The strategy of the placement group (\code{cluster} \|
\code{spread} \| \code{partition}).
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{GroupNames}{One or more placement group names.

Default: Describes all your placement groups, or only those otherwise
specified.}
}
\description{
Describes one or more of your placement groups. For more information,
see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html}{Placement Groups}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_placement_groups(
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  DryRun = TRUE|FALSE,
  GroupNames = list(
    "string"
  )
)
}
}

\keyword{internal}
