% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_restore_address_to_classic}
\alias{ec2_restore_address_to_classic}
\title{Restores an Elastic IP address that was previously moved to the EC2-VPC
platform back to the EC2-Classic platform}
\usage{
ec2_restore_address_to_classic(DryRun, PublicIp)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{PublicIp}{[required] The Elastic IP address.}
}
\description{
Restores an Elastic IP address that was previously moved to the EC2-VPC
platform back to the EC2-Classic platform. You cannot move an Elastic IP
address that was originally allocated for use in EC2-VPC. The Elastic IP
address must not be associated with an instance or network interface.
}
\section{Request syntax}{
\preformatted{svc$restore_address_to_classic(
  DryRun = TRUE|FALSE,
  PublicIp = "string"
)
}
}

\examples{
# This example restores the specified Elastic IP address to the
# EC2-Classic platform.
\donttest{svc$restore_address_to_classic(
  PublicIp = "198.51.100.0"
)}

}
\keyword{internal}
