% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_copy_snapshot}
\alias{lightsail_copy_snapshot}
\title{Copies an instance or disk snapshot from one AWS Region to another in
Amazon Lightsail}
\usage{
lightsail_copy_snapshot(sourceSnapshotName, targetSnapshotName,
  sourceRegion)
}
\arguments{
\item{sourceSnapshotName}{[required] The name of the source instance or disk snapshot to be copied.}

\item{targetSnapshotName}{[required] The name of the new instance or disk snapshot to be created as a copy.}

\item{sourceRegion}{[required] The AWS Region where the source snapshot is located.}
}
\description{
Copies an instance or disk snapshot from one AWS Region to another in
Amazon Lightsail.
}
\section{Request syntax}{
\preformatted{svc$copy_snapshot(
  sourceSnapshotName = "string",
  targetSnapshotName = "string",
  sourceRegion = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
)
}
}

\keyword{internal}
