% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_carrier_gateway}
\alias{ec2_delete_carrier_gateway}
\title{Deletes a carrier gateway}
\usage{
ec2_delete_carrier_gateway(CarrierGatewayId, DryRun)
}
\arguments{
\item{CarrierGatewayId}{[required] The ID of the carrier gateway.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Deletes a carrier gateway.

If you do not delete the route that contains the carrier gateway as the
Target, the route is a blackhole route. For information about how to
delete a route, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html}{DeleteRoute}.
}
\section{Request syntax}{
\preformatted{svc$delete_carrier_gateway(
  CarrierGatewayId = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
