% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_enable_vpc_classic_link_dns_support}
\alias{ec2_enable_vpc_classic_link_dns_support}
\title{Enables a VPC to support DNS hostname resolution for ClassicLink}
\usage{
ec2_enable_vpc_classic_link_dns_support(VpcId)
}
\arguments{
\item{VpcId}{The ID of the VPC.}
}
\description{
Enables a VPC to support DNS hostname resolution for ClassicLink. If
enabled, the DNS hostname of a linked EC2-Classic instance resolves to
its private IP address when addressed from an instance in the VPC to
which it's linked. Similarly, the DNS hostname of an instance in a VPC
resolves to its private IP address when addressed from a linked
EC2-Classic instance. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html}{ClassicLink}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

You must specify a VPC ID in the request.
}
\section{Request syntax}{
\preformatted{svc$enable_vpc_classic_link_dns_support(
  VpcId = "string"
)
}
}

\keyword{internal}
