% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_snapshot_attribute}
\alias{ec2_modify_snapshot_attribute}
\title{Adds or removes permission settings for the specified snapshot}
\usage{
ec2_modify_snapshot_attribute(Attribute, CreateVolumePermission,
  GroupNames, OperationType, SnapshotId, UserIds, DryRun)
}
\arguments{
\item{Attribute}{The snapshot attribute to modify. Only volume creation permissions can
be modified.}

\item{CreateVolumePermission}{A JSON representation of the snapshot attribute modification.}

\item{GroupNames}{The group to modify for the snapshot.}

\item{OperationType}{The type of operation to perform to the attribute.}

\item{SnapshotId}{[required] The ID of the snapshot.}

\item{UserIds}{The account ID to modify for the snapshot.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Adds or removes permission settings for the specified snapshot. You may
add or remove specified AWS account IDs from a snapshot's list of create
volume permissions, but you cannot do both in a single operation. If you
need to both add and remove account IDs for a snapshot, you must use
multiple operations. You can make up to 500 modifications to a snapshot
in a single operation.

Encrypted snapshots and snapshots with AWS Marketplace product codes
cannot be made public. Snapshots encrypted with your default CMK cannot
be shared with other accounts.

For more information about modifying snapshot permissions, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html}{Sharing snapshots}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$modify_snapshot_attribute(
  Attribute = "productCodes"|"createVolumePermission",
  CreateVolumePermission = list(
    Add = list(
      list(
        Group = "all",
        UserId = "string"
      )
    ),
    Remove = list(
      list(
        Group = "all",
        UserId = "string"
      )
    )
  ),
  GroupNames = list(
    "string"
  ),
  OperationType = "add"|"remove",
  SnapshotId = "string",
  UserIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example modifies snapshot `snap-1234567890abcdef0` to remove the
# create volume permission for a user with the account ID
# `123456789012`. If the command succeeds, no output is returned.
svc$modify_snapshot_attribute(
  Attribute = "createVolumePermission",
  OperationType = "remove",
  SnapshotId = "snap-1234567890abcdef0",
  UserIds = list(
    "123456789012"
  )
)

# This example makes the snapshot `snap-1234567890abcdef0` public.
svc$modify_snapshot_attribute(
  Attribute = "createVolumePermission",
  GroupNames = list(
    "all"
  ),
  OperationType = "add",
  SnapshotId = "snap-1234567890abcdef0"
)
}

}
\keyword{internal}
