% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_byoip_cidrs}
\alias{ec2_describe_byoip_cidrs}
\title{Describes the IP address ranges that were specified in calls to
ProvisionByoipCidr}
\usage{
ec2_describe_byoip_cidrs(DryRun, MaxResults, NextToken)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{MaxResults}{[required] The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  ByoipCidrs = list(
    list(
      Cidr = "string",
      Description = "string",
      StatusMessage = "string",
      State = "advertised"|"deprovisioned"|"failed-deprovision"|"failed-provision"|"pending-deprovision"|"pending-provision"|"provisioned"|"provisioned-not-publicly-advertisable"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes the IP address ranges that were specified in calls to
\code{\link[=ec2_provision_byoip_cidr]{provision_byoip_cidr}}.

To describe the address pools that were created when you provisioned the
address ranges, use
\code{\link[=ec2_describe_public_ipv_4_pools]{describe_public_ipv_4_pools}} or
\code{\link[=ec2_describe_ipv_6_pools]{describe_ipv_6_pools}}.
}
\section{Request syntax}{
\preformatted{svc$describe_byoip_cidrs(
  DryRun = TRUE|FALSE,
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
