% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_revoke_client_vpn_ingress}
\alias{ec2_revoke_client_vpn_ingress}
\title{Removes an ingress authorization rule from a Client VPN endpoint}
\usage{
ec2_revoke_client_vpn_ingress(ClientVpnEndpointId, TargetNetworkCidr,
  AccessGroupId, RevokeAllGroups, DryRun)
}
\arguments{
\item{ClientVpnEndpointId}{[required] The ID of the Client VPN endpoint with which the authorization rule is
associated.}

\item{TargetNetworkCidr}{[required] The IPv4 address range, in CIDR notation, of the network for which
access is being removed.}

\item{AccessGroupId}{The ID of the Active Directory group for which to revoke access.}

\item{RevokeAllGroups}{Indicates whether access should be revoked for all clients.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Status = list(
    Code = "authorizing"|"active"|"failed"|"revoking",
    Message = "string"
  )
)
}
}
\description{
Removes an ingress authorization rule from a Client VPN endpoint.
}
\section{Request syntax}{
\preformatted{svc$revoke_client_vpn_ingress(
  ClientVpnEndpointId = "string",
  TargetNetworkCidr = "string",
  AccessGroupId = "string",
  RevokeAllGroups = TRUE|FALSE,
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
