% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_batch_delete_image}
\alias{ecr_batch_delete_image}
\title{Deletes a list of specified images within a specified repository}
\usage{
ecr_batch_delete_image(registryId, repositoryName, imageIds)
}
\arguments{
\item{registryId}{The AWS account ID associated with the registry that contains the image
to delete. If you do not specify a registry, the default registry is
assumed.}

\item{repositoryName}{[required] The repository that contains the image to delete.}

\item{imageIds}{[required] A list of image ID references that correspond to images to delete. The
format of the \code{imageIds} reference is \code{imageTag=tag} or
\code{imageDigest=digest}.}
}
\description{
Deletes a list of specified images within a specified repository. Images
are specified with either \code{imageTag} or \code{imageDigest}.
}
\details{
You can remove a tag from an image by specifying the image\'s tag in
your request. When you remove the last tag from an image, the image is
deleted from your repository.

You can completely delete an image (and all of its tags) by specifying
the image\'s digest in your request.
}
\section{Request syntax}{
\preformatted{svc$batch_delete_image(
  registryId = "string",
  repositoryName = "string",
  imageIds = list(
    list(
      imageDigest = "string",
      imageTag = "string"
    )
  )
)
}
}

\examples{
# This example deletes images with the tags precise and trusty in a
# repository called ubuntu in the default registry for an account.
\dontrun{svc$batch_delete_image(
  imageIds = list(
    list(
      imageTag = "precise"
    )
  ),
  repositoryName = "ubuntu"
)}

}
\keyword{internal}
