% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_disassociate_client_vpn_target_network}
\alias{ec2_disassociate_client_vpn_target_network}
\title{Disassociates a target network from the specified Client VPN endpoint}
\usage{
ec2_disassociate_client_vpn_target_network(ClientVpnEndpointId,
  AssociationId, DryRun)
}
\arguments{
\item{ClientVpnEndpointId}{[required] The ID of the Client VPN endpoint from which to disassociate the target
network.}

\item{AssociationId}{[required] The ID of the target network association.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Disassociates a target network from the specified Client VPN endpoint.
When you disassociate the last target network from a Client VPN, the
following happens:
}
\details{
\itemize{
\item The route that was automatically added for the VPC is deleted
\item All active client connections are terminated
\item New client connections are disallowed
\item The Client VPN endpoint\'s status changes to \code{pending-associate}
}
}
\section{Request syntax}{
\preformatted{svc$disassociate_client_vpn_target_network(
  ClientVpnEndpointId = "string",
  AssociationId = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
