# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon EMR Containers
#'
#' @description
#' Amazon EMR on EKS provides a deployment option for Amazon EMR that
#' allows you to run open-source big data frameworks on Amazon Elastic
#' Kubernetes Service (Amazon EKS). With this deployment option, you can
#' focus on running analytics workloads while Amazon EMR on EKS builds,
#' configures, and manages containers for open-source applications. For
#' more information about Amazon EMR on EKS concepts and tasks, see [What
#' is Amazon EMR on
#' EKS](https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/emr-eks.html).
#' 
#' *Amazon EMR containers* is the API name for Amazon EMR on EKS. The
#' `emr-containers` prefix is used in the following scenarios:
#' 
#' -   It is the prefix in the CLI commands for Amazon EMR on EKS. For
#'     example, `aws emr-containers start-job-run`.
#' 
#' -   It is the prefix before IAM policy actions for Amazon EMR on EKS.
#'     For example, `"Action": [ "emr-containers:StartJobRun"]`. For more
#'     information, see [Policy actions for Amazon EMR on
#'     EKS](https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-actions).
#' 
#' -   It is the prefix used in Amazon EMR on EKS service endpoints. For
#'     example, `emr-containers.us-east-2.amazonaws.com`. For more
#'     information, see [Amazon EMR on EKS Service
#'     Endpoints](https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/service-quotas.html#service-endpoints).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- emrcontainers(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- emrcontainers()
#' svc$cancel_job_run(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=emrcontainers_cancel_job_run]{cancel_job_run} \tab Cancels a job run\cr
#'  \link[=emrcontainers_create_managed_endpoint]{create_managed_endpoint} \tab Creates a managed endpoint\cr
#'  \link[=emrcontainers_create_virtual_cluster]{create_virtual_cluster} \tab Creates a virtual cluster\cr
#'  \link[=emrcontainers_delete_managed_endpoint]{delete_managed_endpoint} \tab Deletes a managed endpoint\cr
#'  \link[=emrcontainers_delete_virtual_cluster]{delete_virtual_cluster} \tab Deletes a virtual cluster\cr
#'  \link[=emrcontainers_describe_job_run]{describe_job_run} \tab Displays detailed information about a job run\cr
#'  \link[=emrcontainers_describe_managed_endpoint]{describe_managed_endpoint} \tab Displays detailed information about a managed endpoint\cr
#'  \link[=emrcontainers_describe_virtual_cluster]{describe_virtual_cluster} \tab Displays detailed information about a specified virtual cluster\cr
#'  \link[=emrcontainers_list_job_runs]{list_job_runs} \tab Lists job runs based on a set of parameters\cr
#'  \link[=emrcontainers_list_managed_endpoints]{list_managed_endpoints} \tab Lists managed endpoints based on a set of parameters\cr
#'  \link[=emrcontainers_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags assigned to the resources\cr
#'  \link[=emrcontainers_list_virtual_clusters]{list_virtual_clusters} \tab Lists information about the specified virtual cluster\cr
#'  \link[=emrcontainers_start_job_run]{start_job_run} \tab Starts a job run\cr
#'  \link[=emrcontainers_tag_resource]{tag_resource} \tab Assigns tags to resources\cr
#'  \link[=emrcontainers_untag_resource]{untag_resource} \tab Removes tags from resources
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname emrcontainers
#' @export
emrcontainers <- function(config = list()) {
  svc <- .emrcontainers$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.emrcontainers <- list()

.emrcontainers$operations <- list()

.emrcontainers$metadata <- list(
  service_name = "emrcontainers",
  endpoints = list("*" = list(endpoint = "emr-containers.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "emr-containers.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "emr-containers.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "emr-containers.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "EMR containers",
  api_version = "2020-10-01",
  signing_name = "emr-containers",
  json_version = "1.1",
  target_prefix = ""
)

.emrcontainers$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.emrcontainers$metadata, handlers, config)
}
