% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_customer_gateway}
\alias{ec2_create_customer_gateway}
\title{Provides information to Amazon Web Services about your customer gateway
device}
\usage{
ec2_create_customer_gateway(
  BgpAsn,
  PublicIp = NULL,
  CertificateArn = NULL,
  Type,
  TagSpecifications = NULL,
  DeviceName = NULL,
  IpAddress = NULL,
  DryRun = NULL
)
}
\arguments{
\item{BgpAsn}{[required] For devices that support BGP, the customer gateway's BGP ASN.

Default: 65000}

\item{PublicIp}{\emph{This member has been deprecated.} The Internet-routable IP address for
the customer gateway's outside interface. The address must be static.}

\item{CertificateArn}{The Amazon Resource Name (ARN) for the customer gateway certificate.}

\item{Type}{[required] The type of VPN connection that this customer gateway supports
(\code{ipsec.1}).}

\item{TagSpecifications}{The tags to apply to the customer gateway.}

\item{DeviceName}{A name for the customer gateway device.

Length Constraints: Up to 255 characters.}

\item{IpAddress}{IPv4 address for the customer gateway device's outside interface. The
address must be static.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Provides information to Amazon Web Services about your customer gateway device. The customer gateway device is the appliance at your end of the VPN connection. You must provide the IP address of the customer gateway device’s external interface. The IP address must be static and can be behind a device performing network address translation (NAT).

See \url{https://paws-r.github.io/docs/ec2/create_customer_gateway.html} for full documentation.
}
\keyword{internal}
