% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_register_image}
\alias{ec2_register_image}
\title{Registers an AMI}
\usage{
ec2_register_image(
  ImageLocation = NULL,
  Architecture = NULL,
  BlockDeviceMappings = NULL,
  Description = NULL,
  DryRun = NULL,
  EnaSupport = NULL,
  KernelId = NULL,
  Name,
  BillingProducts = NULL,
  RamdiskId = NULL,
  RootDeviceName = NULL,
  SriovNetSupport = NULL,
  VirtualizationType = NULL,
  BootMode = NULL,
  TpmSupport = NULL,
  UefiData = NULL
)
}
\arguments{
\item{ImageLocation}{The full path to your AMI manifest in Amazon S3 storage. The specified
bucket must have the \code{aws-exec-read} canned access control list (ACL) to
ensure that it can be accessed by Amazon EC2. For more information, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl}{Canned ACLs}
in the \emph{Amazon S3 Service Developer Guide}.}

\item{Architecture}{The architecture of the AMI.

Default: For Amazon EBS-backed AMIs, \code{i386}. For instance store-backed
AMIs, the architecture specified in the manifest file.}

\item{BlockDeviceMappings}{The block device mapping entries.

If you specify an Amazon EBS volume using the ID of an Amazon EBS
snapshot, you can't specify the encryption state of the volume.

If you create an AMI on an Outpost, then all backing snapshots must be
on the same Outpost or in the Region of that Outpost. AMIs on an Outpost
that include local snapshots can be used to launch instances on the same
Outpost only. For more information, \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami}{Amazon EBS local snapshots on Outposts}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{Description}{A description for your AMI.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{EnaSupport}{Set to \code{true} to enable enhanced networking with ENA for the AMI and any
instances that you launch from the AMI.

This option is supported only for HVM AMIs. Specifying this option with
a PV AMI can make instances launched from the AMI unreachable.}

\item{KernelId}{The ID of the kernel.}

\item{Name}{[required] A name for your AMI.

Constraints: 3-128 alphanumeric characters, parentheses (()), square
brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-),
single quotes ('), at-signs (@), or underscores(_)}

\item{BillingProducts}{The billing product codes. Your account must be authorized to specify
billing product codes. Otherwise, you can use the Amazon Web Services
Marketplace to bill for the use of an AMI.}

\item{RamdiskId}{The ID of the RAM disk.}

\item{RootDeviceName}{The device name of the root device volume (for example, \verb{/dev/sda1}).}

\item{SriovNetSupport}{Set to \code{simple} to enable enhanced networking with the Intel 82599
Virtual Function interface for the AMI and any instances that you launch
from the AMI.

There is no way to disable \code{sriovNetSupport} at this time.

This option is supported only for HVM AMIs. Specifying this option with
a PV AMI can make instances launched from the AMI unreachable.}

\item{VirtualizationType}{The type of virtualization (\code{hvm} | \code{paravirtual}).

Default: \code{paravirtual}}

\item{BootMode}{The boot mode of the AMI. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html}{Boot modes}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{TpmSupport}{Set to \code{v2.0} to enable Trusted Platform Module (TPM) support. For more
information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html}{NitroTPM}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{UefiData}{Base64 representation of the non-volatile UEFI variable store. To
retrieve the UEFI data, use the
\code{\link[=ec2_get_instance_uefi_data]{get_instance_uefi_data}} command. You can
inspect and modify the UEFI data by using the \href{https://github.com/awslabs/python-uefivars}{python-uefivars tool} on GitHub. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/uefi-secure-boot.html}{UEFI Secure Boot}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}
}
\description{
Registers an AMI. When you're creating an AMI, this is the final step you must complete before you can launch an instance from the AMI. For more information about creating AMIs, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIs.html#creating-an-ami}{Creating your own AMIs} in the \emph{Amazon Elastic Compute Cloud User Guide}.

See \url{https://paws-r.github.io/docs/ec2/register_image.html} for full documentation.
}
\keyword{internal}
