% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_revoke_security_group_ingress}
\alias{ec2_revoke_security_group_ingress}
\title{Removes the specified inbound (ingress) rules from a security group}
\usage{
ec2_revoke_security_group_ingress(
  CidrIp = NULL,
  FromPort = NULL,
  GroupId = NULL,
  GroupName = NULL,
  IpPermissions = NULL,
  IpProtocol = NULL,
  SourceSecurityGroupName = NULL,
  SourceSecurityGroupOwnerId = NULL,
  ToPort = NULL,
  DryRun = NULL,
  SecurityGroupRuleIds = NULL
)
}
\arguments{
\item{CidrIp}{The CIDR IP address range. You can't specify this parameter when
specifying a source security group.}

\item{FromPort}{The start of port range for the TCP and UDP protocols, or an ICMP type
number. For the ICMP type number, use \code{-1} to specify all ICMP types.}

\item{GroupId}{The ID of the security group. You must specify either the security group
ID or the security group name in the request. For security groups in a
nondefault VPC, you must specify the security group ID.}

\item{GroupName}{[EC2-Classic, default VPC] The name of the security group. You must
specify either the security group ID or the security group name in the
request.}

\item{IpPermissions}{The sets of IP permissions. You can't specify a source security group
and a CIDR IP address range in the same set of permissions.}

\item{IpProtocol}{The IP protocol name (\code{tcp}, \code{udp}, \code{icmp}) or number (see \href{http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml}{Protocol Numbers}).
Use \code{-1} to specify all.}

\item{SourceSecurityGroupName}{[EC2-Classic, default VPC] The name of the source security group. You
can't specify this parameter in combination with the following
parameters: the CIDR IP address range, the start of the port range, the
IP protocol, and the end of the port range. For EC2-VPC, the source
security group must be in the same VPC. To revoke a specific rule for an
IP protocol and port range, use a set of IP permissions instead.}

\item{SourceSecurityGroupOwnerId}{[EC2-Classic] The Amazon Web Services account ID of the source
security group, if the source security group is in a different account.
You can't specify this parameter in combination with the following
parameters: the CIDR IP address range, the IP protocol, the start of the
port range, and the end of the port range. To revoke a specific rule for
an IP protocol and port range, use a set of IP permissions instead.}

\item{ToPort}{The end of port range for the TCP and UDP protocols, or an ICMP code
number. For the ICMP code number, use \code{-1} to specify all ICMP codes for
the ICMP type.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{SecurityGroupRuleIds}{The IDs of the security group rules.}
}
\description{
Removes the specified inbound (ingress) rules from a security group.

See \url{https://paws-r.github.io/docs/ec2/revoke_security_group_ingress.html} for full documentation.
}
\keyword{internal}
