% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_client_vpn_route}
\alias{ec2_delete_client_vpn_route}
\title{Deletes a route from a Client VPN endpoint}
\usage{
ec2_delete_client_vpn_route(
  ClientVpnEndpointId,
  TargetVpcSubnetId = NULL,
  DestinationCidrBlock,
  DryRun = NULL
)
}
\arguments{
\item{ClientVpnEndpointId}{[required] The ID of the Client VPN endpoint from which the route is to be deleted.}

\item{TargetVpcSubnetId}{The ID of the target subnet used by the route.}

\item{DestinationCidrBlock}{[required] The IPv4 address range, in CIDR notation, of the route to be deleted.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using the \strong{CreateClientVpnRoute} action. You cannot delete routes that were automatically added when associating a subnet. To remove routes that have been automatically added, disassociate the target subnet from the Client VPN endpoint.

See \url{https://www.paws-r-sdk.com/docs/ec2_delete_client_vpn_route/} for full documentation.
}
\keyword{internal}
