% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_network_interface_permissions}
\alias{ec2_describe_network_interface_permissions}
\title{Describes the permissions for your network interfaces}
\usage{
ec2_describe_network_interface_permissions(
  NetworkInterfacePermissionIds = NULL,
  Filters = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{NetworkInterfacePermissionIds}{The network interface permission IDs.}

\item{Filters}{One or more filters.
\itemize{
\item \code{network-interface-permission.network-interface-permission-id} - The
ID of the permission.
\item \code{network-interface-permission.network-interface-id} - The ID of the
network interface.
\item \code{network-interface-permission.aws-account-id} - The Amazon Web
Services account ID.
\item \code{network-interface-permission.aws-service} - The Amazon Web Services
service.
\item \code{network-interface-permission.permission} - The type of permission
(\code{INSTANCE-ATTACH} | \code{EIP-ASSOCIATE}).
}}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. If this parameter is not specified, up to 50 results are
returned by default. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}
}
\description{
Describes the permissions for your network interfaces.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_network_interface_permissions/} for full documentation.
}
\keyword{internal}
