% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_verified_access_endpoint}
\alias{ec2_modify_verified_access_endpoint}
\title{Modifies the configuration of the specified Amazon Web Services Verified
Access endpoint}
\usage{
ec2_modify_verified_access_endpoint(
  VerifiedAccessEndpointId,
  VerifiedAccessGroupId = NULL,
  LoadBalancerOptions = NULL,
  NetworkInterfaceOptions = NULL,
  Description = NULL,
  ClientToken = NULL,
  DryRun = NULL
)
}
\arguments{
\item{VerifiedAccessEndpointId}{[required] The ID of the Verified Access endpoint.}

\item{VerifiedAccessGroupId}{The ID of the Verified Access group.}

\item{LoadBalancerOptions}{The load balancer details if creating the Verified Access endpoint as
\code{load-balancer}type.}

\item{NetworkInterfaceOptions}{The network interface options.}

\item{Description}{A description for the Verified Access endpoint.}

\item{ClientToken}{A unique, case-sensitive token that you provide to ensure idempotency of
your modification request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Modifies the configuration of the specified Amazon Web Services Verified Access endpoint.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_verified_access_endpoint/} for full documentation.
}
\keyword{internal}
