% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_move_capacity_reservation_instances}
\alias{ec2_move_capacity_reservation_instances}
\title{Move available capacity from a source Capacity Reservation to a
destination Capacity Reservation}
\usage{
ec2_move_capacity_reservation_instances(
  DryRun = NULL,
  ClientToken = NULL,
  SourceCapacityReservationId,
  DestinationCapacityReservationId,
  InstanceCount
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensure Idempotency}.}

\item{SourceCapacityReservationId}{[required] The ID of the Capacity Reservation from which you want to move capacity.}

\item{DestinationCapacityReservationId}{[required] The ID of the Capacity Reservation that you want to move capacity into.}

\item{InstanceCount}{[required] The number of instances that you want to move from the source Capacity
Reservation.}
}
\description{
Move available capacity from a source Capacity Reservation to a destination Capacity Reservation. The source Capacity Reservation and the destination Capacity Reservation must be \code{active}, owned by your Amazon Web Services account, and share the following:

See \url{https://www.paws-r-sdk.com/docs/ec2_move_capacity_reservation_instances/} for full documentation.
}
\keyword{internal}
