# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include marketplacemetering_service.R
NULL

#' BatchMeterUsage is called from a SaaS application listed on the AWS
#' Marketplace to post metering records for a set of customers
#'
#' @description
#' BatchMeterUsage is called from a SaaS application listed on the AWS
#' Marketplace to post metering records for a set of customers.
#' 
#' For identical requests, the API is idempotent; requests can be retried
#' with the same records or a subset of the input records.
#' 
#' Every request to BatchMeterUsage is for one product. If you need to
#' meter usage for multiple products, you must make multiple calls to
#' BatchMeterUsage.
#' 
#' BatchMeterUsage can process up to 25 UsageRecords at a time.
#' 
#' A UsageRecord can optionally include multiple usage allocations, to
#' provide customers with usagedata split into buckets by tags that you
#' define (or allow the customer to define).
#' 
#' BatchMeterUsage requests must be less than 1MB in size.
#'
#' @usage
#' marketplacemetering_batch_meter_usage(UsageRecords, ProductCode)
#'
#' @param UsageRecords &#91;required&#93; The set of UsageRecords to submit. BatchMeterUsage accepts up to 25
#' UsageRecords at a time.
#' @param ProductCode &#91;required&#93; Product code is used to uniquely identify a product in AWS Marketplace.
#' The product code should be the same as the one used during the
#' publishing of a new product.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Results = list(
#'     list(
#'       UsageRecord = list(
#'         Timestamp = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         CustomerIdentifier = "string",
#'         Dimension = "string",
#'         Quantity = 123,
#'         UsageAllocations = list(
#'           list(
#'             AllocatedUsageQuantity = 123,
#'             Tags = list(
#'               list(
#'                 Key = "string",
#'                 Value = "string"
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       MeteringRecordId = "string",
#'       Status = "Success"|"CustomerNotSubscribed"|"DuplicateRecord"
#'     )
#'   ),
#'   UnprocessedRecords = list(
#'     list(
#'       Timestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       CustomerIdentifier = "string",
#'       Dimension = "string",
#'       Quantity = 123,
#'       UsageAllocations = list(
#'         list(
#'           AllocatedUsageQuantity = 123,
#'           Tags = list(
#'             list(
#'               Key = "string",
#'               Value = "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_meter_usage(
#'   UsageRecords = list(
#'     list(
#'       Timestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       CustomerIdentifier = "string",
#'       Dimension = "string",
#'       Quantity = 123,
#'       UsageAllocations = list(
#'         list(
#'           AllocatedUsageQuantity = 123,
#'           Tags = list(
#'             list(
#'               Key = "string",
#'               Value = "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ProductCode = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname marketplacemetering_batch_meter_usage
marketplacemetering_batch_meter_usage <- function(UsageRecords, ProductCode) {
  op <- new_operation(
    name = "BatchMeterUsage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .marketplacemetering$batch_meter_usage_input(UsageRecords = UsageRecords, ProductCode = ProductCode)
  output <- .marketplacemetering$batch_meter_usage_output()
  config <- get_config()
  svc <- .marketplacemetering$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacemetering$operations$batch_meter_usage <- marketplacemetering_batch_meter_usage

#' API to emit metering records
#'
#' @description
#' API to emit metering records. For identical requests, the API is
#' idempotent. It simply returns the metering record ID.
#' 
#' MeterUsage is authenticated on the buyer's AWS account using credentials
#' from the EC2 instance, ECS task, or EKS pod.
#' 
#' MeterUsage can optionally include multiple usage allocations, to provide
#' customers with usage data split into buckets by tags that you define (or
#' allow the customer to define).
#'
#' @usage
#' marketplacemetering_meter_usage(ProductCode, Timestamp, UsageDimension,
#'   UsageQuantity, DryRun, UsageAllocations)
#'
#' @param ProductCode &#91;required&#93; Product code is used to uniquely identify a product in AWS Marketplace.
#' The product code should be the same as the one used during the
#' publishing of a new product.
#' @param Timestamp &#91;required&#93; Timestamp, in UTC, for which the usage is being reported. Your
#' application can meter usage for up to one hour in the past. Make sure
#' the timestamp value is not before the start of the software usage.
#' @param UsageDimension &#91;required&#93; It will be one of the fcp dimension name provided during the publishing
#' of the product.
#' @param UsageQuantity Consumption value for the hour. Defaults to `0` if not specified.
#' @param DryRun Checks whether you have the permissions required for the action, but
#' does not make the request. If you have the permissions, the request
#' returns DryRunOperation; otherwise, it returns UnauthorizedException.
#' Defaults to `false` if not specified.
#' @param UsageAllocations The set of UsageAllocations to submit.
#' 
#' The sum of all UsageAllocation quantities must equal the UsageQuantity
#' of the MeterUsage request, and each UsageAllocation must have a unique
#' set of tags (include no tags).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   MeteringRecordId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$meter_usage(
#'   ProductCode = "string",
#'   Timestamp = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   UsageDimension = "string",
#'   UsageQuantity = 123,
#'   DryRun = TRUE|FALSE,
#'   UsageAllocations = list(
#'     list(
#'       AllocatedUsageQuantity = 123,
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname marketplacemetering_meter_usage
marketplacemetering_meter_usage <- function(ProductCode, Timestamp, UsageDimension, UsageQuantity = NULL, DryRun = NULL, UsageAllocations = NULL) {
  op <- new_operation(
    name = "MeterUsage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .marketplacemetering$meter_usage_input(ProductCode = ProductCode, Timestamp = Timestamp, UsageDimension = UsageDimension, UsageQuantity = UsageQuantity, DryRun = DryRun, UsageAllocations = UsageAllocations)
  output <- .marketplacemetering$meter_usage_output()
  config <- get_config()
  svc <- .marketplacemetering$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacemetering$operations$meter_usage <- marketplacemetering_meter_usage

#' Paid container software products sold through AWS Marketplace must
#' integrate with the AWS Marketplace Metering Service and call the
#' RegisterUsage operation for software entitlement and metering
#'
#' @description
#' Paid container software products sold through AWS Marketplace must
#' integrate with the AWS Marketplace Metering Service and call the
#' RegisterUsage operation for software entitlement and metering. Free and
#' BYOL products for Amazon ECS or Amazon EKS aren't required to call
#' RegisterUsage, but you may choose to do so if you would like to receive
#' usage data in your seller reports. The sections below explain the
#' behavior of RegisterUsage. RegisterUsage performs two primary functions:
#' metering and entitlement.
#' 
#' -   *Entitlement*: RegisterUsage allows you to verify that the customer
#'     running your paid software is subscribed to your product on AWS
#'     Marketplace, enabling you to guard against unauthorized use. Your
#'     container image that integrates with RegisterUsage is only required
#'     to guard against unauthorized use at container startup, as such a
#'     CustomerNotSubscribedException/PlatformNotSupportedException will
#'     only be thrown on the initial call to RegisterUsage. Subsequent
#'     calls from the same Amazon ECS task instance (e.g. task-id) or
#'     Amazon EKS pod will not throw a CustomerNotSubscribedException, even
#'     if the customer unsubscribes while the Amazon ECS task or Amazon EKS
#'     pod is still running.
#' 
#' -   *Metering*: RegisterUsage meters software use per ECS task, per
#'     hour, or per pod for Amazon EKS with usage prorated to the second. A
#'     minimum of 1 minute of usage applies to tasks that are short lived.
#'     For example, if a customer has a 10 node Amazon ECS or Amazon EKS
#'     cluster and a service configured as a Daemon Set, then Amazon ECS or
#'     Amazon EKS will launch a task on all 10 cluster nodes and the
#'     customer will be charged: (10 * hourly_rate). Metering for
#'     software use is automatically handled by the AWS Marketplace
#'     Metering Control Plane -- your software is not required to perform
#'     any metering specific actions, other than call RegisterUsage once
#'     for metering of software use to commence. The AWS Marketplace
#'     Metering Control Plane will also continue to bill customers for
#'     running ECS tasks and Amazon EKS pods, regardless of the customers
#'     subscription state, removing the need for your software to perform
#'     entitlement checks at runtime.
#'
#' @usage
#' marketplacemetering_register_usage(ProductCode, PublicKeyVersion, Nonce)
#'
#' @param ProductCode &#91;required&#93; Product code is used to uniquely identify a product in AWS Marketplace.
#' The product code should be the same as the one used during the
#' publishing of a new product.
#' @param PublicKeyVersion &#91;required&#93; Public Key Version provided by AWS Marketplace
#' @param Nonce (Optional) To scope down the registration to a specific running software
#' instance and guard against replay attacks.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PublicKeyRotationTimestamp = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Signature = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$register_usage(
#'   ProductCode = "string",
#'   PublicKeyVersion = 123,
#'   Nonce = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname marketplacemetering_register_usage
marketplacemetering_register_usage <- function(ProductCode, PublicKeyVersion, Nonce = NULL) {
  op <- new_operation(
    name = "RegisterUsage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .marketplacemetering$register_usage_input(ProductCode = ProductCode, PublicKeyVersion = PublicKeyVersion, Nonce = Nonce)
  output <- .marketplacemetering$register_usage_output()
  config <- get_config()
  svc <- .marketplacemetering$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacemetering$operations$register_usage <- marketplacemetering_register_usage

#' ResolveCustomer is called by a SaaS application during the registration
#' process
#'
#' @description
#' ResolveCustomer is called by a SaaS application during the registration
#' process. When a buyer visits your website during the registration
#' process, the buyer submits a registration token through their browser.
#' The registration token is resolved through this API to obtain a
#' CustomerIdentifier and product code.
#'
#' @usage
#' marketplacemetering_resolve_customer(RegistrationToken)
#'
#' @param RegistrationToken &#91;required&#93; When a buyer visits your website during the registration process, the
#' buyer submits a registration token through the browser. The registration
#' token is resolved to obtain a CustomerIdentifier and product code.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CustomerIdentifier = "string",
#'   ProductCode = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$resolve_customer(
#'   RegistrationToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname marketplacemetering_resolve_customer
marketplacemetering_resolve_customer <- function(RegistrationToken) {
  op <- new_operation(
    name = "ResolveCustomer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .marketplacemetering$resolve_customer_input(RegistrationToken = RegistrationToken)
  output <- .marketplacemetering$resolve_customer_output()
  config <- get_config()
  svc <- .marketplacemetering$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacemetering$operations$resolve_customer <- marketplacemetering_resolve_customer
