% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/budgets_operations.R
\name{budgets_create_budget_action}
\alias{budgets_create_budget_action}
\title{Creates a budget action}
\usage{
budgets_create_budget_action(AccountId, BudgetName, NotificationType,
  ActionType, ActionThreshold, Definition, ExecutionRoleArn,
  ApprovalModel, Subscribers)
}
\arguments{
\item{AccountId}{[required]}

\item{BudgetName}{[required]}

\item{NotificationType}{[required]}

\item{ActionType}{[required] The type of action. This defines the type of tasks that can be carried
out by this action. This field also determines the format for
definition.}

\item{ActionThreshold}{[required]}

\item{Definition}{[required]}

\item{ExecutionRoleArn}{[required] The role passed for action execution and reversion. Roles and actions
must be in the same account.}

\item{ApprovalModel}{[required] This specifies if the action needs manual or automatic approval.}

\item{Subscribers}{[required]}
}
\value{
A list with the following syntax:\preformatted{list(
  AccountId = "string",
  BudgetName = "string",
  ActionId = "string"
)
}
}
\description{
Creates a budget action.
}
\section{Request syntax}{
\preformatted{svc$create_budget_action(
  AccountId = "string",
  BudgetName = "string",
  NotificationType = "ACTUAL"|"FORECASTED",
  ActionType = "APPLY_IAM_POLICY"|"APPLY_SCP_POLICY"|"RUN_SSM_DOCUMENTS",
  ActionThreshold = list(
    ActionThresholdValue = 123.0,
    ActionThresholdType = "PERCENTAGE"|"ABSOLUTE_VALUE"
  ),
  Definition = list(
    IamActionDefinition = list(
      PolicyArn = "string",
      Roles = list(
        "string"
      ),
      Groups = list(
        "string"
      ),
      Users = list(
        "string"
      )
    ),
    ScpActionDefinition = list(
      PolicyId = "string",
      TargetIds = list(
        "string"
      )
    ),
    SsmActionDefinition = list(
      ActionSubType = "STOP_EC2_INSTANCES"|"STOP_RDS_INSTANCES",
      Region = "string",
      InstanceIds = list(
        "string"
      )
    )
  ),
  ExecutionRoleArn = "string",
  ApprovalModel = "AUTOMATIC"|"MANUAL",
  Subscribers = list(
    list(
      SubscriptionType = "SNS"|"EMAIL",
      Address = "string"
    )
  )
)
}
}

\keyword{internal}
