# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include costandusagereportservice_service.R
NULL

#' Deletes the specified report
#'
#' Deletes the specified report.
#'
#' @usage
#' costandusagereportservice_delete_report_definition(ReportName)
#'
#' @param ReportName 
#'
#' @section Request syntax:
#' ```
#' svc$delete_report_definition(
#'   ReportName = "string"
#' )
#' ```
#'
#' @examples
#' # The following example deletes the AWS Cost and Usage report named
#' # ExampleReport.
#' \donttest{svc$delete_report_definition(
#'   ReportName = "ExampleReport"
#' )}
#'
#' @keywords internal
#'
#' @rdname costandusagereportservice_delete_report_definition
costandusagereportservice_delete_report_definition <- function(ReportName = NULL) {
  op <- new_operation(
    name = "DeleteReportDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costandusagereportservice$delete_report_definition_input(ReportName = ReportName)
  output <- .costandusagereportservice$delete_report_definition_output()
  svc <- .costandusagereportservice$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costandusagereportservice$operations$delete_report_definition <- costandusagereportservice_delete_report_definition

#' Lists the AWS Cost and Usage reports available to this account
#'
#' Lists the AWS Cost and Usage reports available to this account.
#'
#' @usage
#' costandusagereportservice_describe_report_definitions(MaxResults,
#'   NextToken)
#'
#' @param MaxResults 
#' @param NextToken 
#'
#' @section Request syntax:
#' ```
#' svc$describe_report_definitions(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # The following example lists the AWS Cost and Usage reports for the
#' # account.
#' \donttest{svc$describe_report_definitions(
#'   MaxResults = 5L
#' )}
#'
#' @keywords internal
#'
#' @rdname costandusagereportservice_describe_report_definitions
costandusagereportservice_describe_report_definitions <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeReportDefinitions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costandusagereportservice$describe_report_definitions_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .costandusagereportservice$describe_report_definitions_output()
  svc <- .costandusagereportservice$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costandusagereportservice$operations$describe_report_definitions <- costandusagereportservice_describe_report_definitions

#' Creates a new report using the description that you provide
#'
#' Creates a new report using the description that you provide.
#'
#' @usage
#' costandusagereportservice_put_report_definition(ReportDefinition)
#'
#' @param ReportDefinition &#91;required&#93; Represents the output of the PutReportDefinition operation. The content
#' consists of the detailed metadata and data file information.
#'
#' @section Request syntax:
#' ```
#' svc$put_report_definition(
#'   ReportDefinition = list(
#'     ReportName = "string",
#'     TimeUnit = "HOURLY"|"DAILY",
#'     Format = "textORcsv"|"Parquet",
#'     Compression = "ZIP"|"GZIP"|"Parquet",
#'     AdditionalSchemaElements = list(
#'       "RESOURCES"
#'     ),
#'     S3Bucket = "string",
#'     S3Prefix = "string",
#'     S3Region = "us-east-1"|"us-west-1"|"us-west-2"|"eu-central-1"|"eu-west-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"eu-north-1"|"ap-northeast-3",
#'     AdditionalArtifacts = list(
#'       "REDSHIFT"|"QUICKSIGHT"|"ATHENA"
#'     ),
#'     RefreshClosedReports = TRUE|FALSE,
#'     ReportVersioning = "CREATE_NEW_REPORT"|"OVERWRITE_REPORT"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example creates a AWS Cost and Usage report named
#' # ExampleReport.
#' \donttest{svc$put_report_definition(
#'   ReportDefinition = list(
#'     AdditionalArtifacts = list(
#'       "REDSHIFT",
#'       "QUICKSIGHT"
#'     ),
#'     AdditionalSchemaElements = list(
#'       "RESOURCES"
#'     ),
#'     Compression = "ZIP",
#'     Format = "textORcsv",
#'     ReportName = "ExampleReport",
#'     S3Bucket = "example-s3-bucket",
#'     S3Prefix = "exampleprefix",
#'     S3Region = "us-east-1",
#'     TimeUnit = "DAILY"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname costandusagereportservice_put_report_definition
costandusagereportservice_put_report_definition <- function(ReportDefinition) {
  op <- new_operation(
    name = "PutReportDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costandusagereportservice$put_report_definition_input(ReportDefinition = ReportDefinition)
  output <- .costandusagereportservice$put_report_definition_output()
  svc <- .costandusagereportservice$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costandusagereportservice$operations$put_report_definition <- costandusagereportservice_put_report_definition
