% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costandusagereportservice_operations.R
\name{costandusagereportservice_put_report_definition}
\alias{costandusagereportservice_put_report_definition}
\title{Creates a new report using the description that you provide}
\usage{
costandusagereportservice_put_report_definition(ReportDefinition)
}
\arguments{
\item{ReportDefinition}{[required] Represents the output of the PutReportDefinition operation. The content
consists of the detailed metadata and data file information.}
}
\description{
Creates a new report using the description that you provide.
}
\section{Request syntax}{
\preformatted{svc$put_report_definition(
  ReportDefinition = list(
    ReportName = "string",
    TimeUnit = "HOURLY"|"DAILY",
    Format = "textORcsv"|"Parquet",
    Compression = "ZIP"|"GZIP"|"Parquet",
    AdditionalSchemaElements = list(
      "RESOURCES"
    ),
    S3Bucket = "string",
    S3Prefix = "string",
    S3Region = "us-east-1"|"us-west-1"|"us-west-2"|"eu-central-1"|"eu-west-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"eu-north-1"|"ap-northeast-3"|"ap-east-1",
    AdditionalArtifacts = list(
      "REDSHIFT"|"QUICKSIGHT"|"ATHENA"
    ),
    RefreshClosedReports = TRUE|FALSE,
    ReportVersioning = "CREATE_NEW_REPORT"|"OVERWRITE_REPORT"
  )
)
}
}

\examples{
# The following example creates a AWS Cost and Usage report named
# ExampleReport.
\donttest{svc$put_report_definition(
  ReportDefinition = list(
    AdditionalArtifacts = list(
      "REDSHIFT",
      "QUICKSIGHT"
    ),
    AdditionalSchemaElements = list(
      "RESOURCES"
    ),
    Compression = "ZIP",
    Format = "textORcsv",
    ReportName = "ExampleReport",
    S3Bucket = "example-s3-bucket",
    S3Prefix = "exampleprefix",
    S3Region = "us-east-1",
    TimeUnit = "DAILY"
  )
)}

}
\keyword{internal}
