% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pricing_operations.R
\name{pricing_get_products}
\alias{pricing_get_products}
\title{Returns a list of all products that match the filter criteria}
\usage{
pricing_get_products(ServiceCode, Filters, FormatVersion, NextToken,
  MaxResults)
}
\arguments{
\item{ServiceCode}{The code for the service whose products you want to retrieve.}

\item{Filters}{The list of filters that limit the returned products. only products that
match all filters are returned.}

\item{FormatVersion}{The format version that you want the response to be in.

Valid values are: \code{aws_v1}}

\item{NextToken}{The pagination token that indicates the next set of results that you
want to retrieve.}

\item{MaxResults}{The maximum number of results to return in the response.}
}
\description{
Returns a list of all products that match the filter criteria.
}
\section{Request syntax}{
\preformatted{svc$get_products(
  ServiceCode = "string",
  Filters = list(
    list(
      Type = "TERM_MATCH",
      Field = "string",
      Value = "string"
    )
  ),
  FormatVersion = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\examples{
\dontrun{
# This operation returns a list of products that match the given criteria.
svc$get_products(
  Filters = list(
    list(
      Field = "ServiceCode",
      Type = "TERM_MATCH",
      Value = "AmazonEC2"
    ),
    list(
      Field = "volumeType",
      Type = "TERM_MATCH",
      Value = "Provisioned IOPS"
    )
  ),
  FormatVersion = "aws_v1",
  MaxResults = 1L
)
}

}
\keyword{internal}
