% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketplacecatalog_operations.R
\name{marketplacecatalog_list_entities}
\alias{marketplacecatalog_list_entities}
\title{Provides the list of entities of a given type}
\usage{
marketplacecatalog_list_entities(
  Catalog,
  EntityType,
  FilterList = NULL,
  Sort = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{Catalog}{[required] The catalog related to the request. Fixed value: \code{AWSMarketplace}}

\item{EntityType}{[required] The type of entities to retrieve.}

\item{FilterList}{An array of filter objects. Each filter object contains two attributes,
\code{filterName} and \code{filterValues}.}

\item{Sort}{An object that contains two attributes, \code{SortBy} and \code{SortOrder}.}

\item{NextToken}{The value of the next token, if it exists. Null if there are no more
results.}

\item{MaxResults}{Specifies the upper limit of the elements on a single page. If a value
isn't provided, the default value is 20.}
}
\description{
Provides the list of entities of a given type.

See \url{https://paws-r.github.io/docs/marketplacecatalog/list_entities.html} for full documentation.
}
\keyword{internal}
