% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_set_identity_feedback_forwarding_enabled}
\alias{ses_set_identity_feedback_forwarding_enabled}
\title{Given an identity (an email address or a domain), enables or disables
whether Amazon SES forwards bounce and complaint notifications as email}
\usage{
ses_set_identity_feedback_forwarding_enabled(Identity,
  ForwardingEnabled)
}
\arguments{
\item{Identity}{[required] The identity for which to set bounce and complaint notification
forwarding. Examples: \code{user@example.com}, \code{example.com}.}

\item{ForwardingEnabled}{[required] Sets whether Amazon SES will forward bounce and complaint notifications
as email. \code{true} specifies that Amazon SES will forward bounce and
complaint notifications as email, in addition to any Amazon SNS topic
publishing otherwise specified. \code{false} specifies that Amazon SES will
publish bounce and complaint notifications only through Amazon SNS. This
value can only be set to \code{false} when Amazon SNS topics are set for both
\code{Bounce} and \code{Complaint} notification types.}
}
\description{
Given an identity (an email address or a domain), enables or disables
whether Amazon SES forwards bounce and complaint notifications as email.
Feedback forwarding can only be disabled when Amazon Simple Notification
Service (Amazon SNS) topics are specified for both bounces and
complaints.
}
\details{
Feedback forwarding does not apply to delivery notifications. Delivery
notifications are only available through Amazon SNS.

You can execute this operation no more than once per second.

For more information about using notifications with Amazon SES, see the
\href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html}{Amazon SES Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$set_identity_feedback_forwarding_enabled(
  Identity = "string",
  ForwardingEnabled = TRUE|FALSE
)
}
}

\examples{
# The following example configures Amazon SES to forward an identity's
# bounces and complaints via email:
\donttest{svc$set_identity_feedback_forwarding_enabled(
  ForwardingEnabled = TRUE,
  Identity = "user@example.com"
)}

}
\keyword{internal}
