% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_contact_flow}
\alias{connect_create_contact_flow}
\title{Creates a contact flow for the specified Amazon Connect instance}
\usage{
connect_create_contact_flow(InstanceId, Name, Type, Description,
  Content, Tags)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{Name}{[required] The name of the contact flow.}

\item{Type}{[required] The type of the contact flow. For descriptions of the available types,
see \href{https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types}{Choose a Contact Flow Type}
in the \emph{Amazon Connect Administrator Guide}.}

\item{Description}{The description of the contact flow.}

\item{Content}{[required] The content of the contact flow.}

\item{Tags}{One or more tags.}
}
\description{
Creates a contact flow for the specified Amazon Connect instance.

You can also create and update contact flows using the \href{https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html}{Amazon Connect Flow language}.
}
\section{Request syntax}{
\preformatted{svc$create_contact_flow(
  InstanceId = "string",
  Name = "string",
  Type = "CONTACT_FLOW"|"CUSTOMER_QUEUE"|"CUSTOMER_HOLD"|"CUSTOMER_WHISPER"|"AGENT_HOLD"|"AGENT_WHISPER"|"OUTBOUND_WHISPER"|"AGENT_TRANSFER"|"QUEUE_TRANSFER",
  Description = "string",
  Content = "string",
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
