% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_update_user_identity_info}
\alias{connect_update_user_identity_info}
\title{Updates the identity information for the specified user}
\usage{
connect_update_user_identity_info(IdentityInfo, UserId, InstanceId)
}
\arguments{
\item{IdentityInfo}{[required] The identity information for the user.}

\item{UserId}{[required] The identifier of the user account.}

\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}
}
\description{
Updates the identity information for the specified user.

Someone with the ability to invoke \code{UpdateUserIndentityInfo} can change
the login credentials of other users by changing their email address.
This poses a security risk to your organization. They can change the
email address of a user to the attacker's email address, and then reset
the password through email. We strongly recommend limiting who has the
ability to invoke \code{UpdateUserIndentityInfo}. For more information, see
\href{https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html}{Best Practices for Security Profiles}
in the \emph{Amazon Connect Administrator Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_user_identity_info(
  IdentityInfo = list(
    FirstName = "string",
    LastName = "string",
    Email = "string"
  ),
  UserId = "string",
  InstanceId = "string"
)
}
}

\keyword{internal}
