% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_list_user_hierarchy_groups}
\alias{connect_list_user_hierarchy_groups}
\title{Provides summary information about the hierarchy groups for the
specified Amazon Connect instance}
\usage{
connect_list_user_hierarchy_groups(InstanceId, NextToken, MaxResults)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{MaxResults}{The maximimum number of results to return per page.}
}
\value{
A list with the following syntax:\preformatted{list(
  UserHierarchyGroupSummaryList = list(
    list(
      Id = "string",
      Arn = "string",
      Name = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Provides summary information about the hierarchy groups for the
specified Amazon Connect instance.

For more information about agent hierarchies, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html}{Set Up Agent Hierarchies}
in the \emph{Amazon Connect Administrator Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_user_hierarchy_groups(
  InstanceId = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
