% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_start_chat_contact}
\alias{connect_start_chat_contact}
\title{Initiates a contact flow to start a new chat for the customer}
\usage{
connect_start_chat_contact(InstanceId, ContactFlowId, Attributes,
  ParticipantDetails, InitialMessage, ClientToken)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{ContactFlowId}{[required] The identifier of the contact flow for the chat.}

\item{Attributes}{A custom key-value pair using an attribute map. The attributes are
standard Amazon Connect attributes, and can be accessed in contact flows
just like any other contact attributes.

There can be up to 32,768 UTF-8 bytes across all key-value pairs per
contact. Attribute keys can include only alphanumeric, dash, and
underscore characters.}

\item{ParticipantDetails}{[required] Information identifying the participant.}

\item{InitialMessage}{The initial message to be sent to the newly created chat.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\description{
Initiates a contact flow to start a new chat for the customer. Response
of this API provides a token required to obtain credentials from the
\href{https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html}{CreateParticipantConnection}
API in the Amazon Connect Participant Service.
}
\details{
When a new chat contact is successfully created, clients need to
subscribe to the participant's connection for the created chat within 5
minutes. This is achieved by invoking
\href{https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html}{CreateParticipantConnection}
with WEBSOCKET and CONNECTION\\_CREDENTIALS.
}
\section{Request syntax}{
\preformatted{svc$start_chat_contact(
  InstanceId = "string",
  ContactFlowId = "string",
  Attributes = list(
    "string"
  ),
  ParticipantDetails = list(
    DisplayName = "string"
  ),
  InitialMessage = list(
    ContentType = "string",
    Content = "string"
  ),
  ClientToken = "string"
)
}
}

\keyword{internal}
