% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_suspend_contact_recording}
\alias{connect_suspend_contact_recording}
\title{When a contact is being recorded, this API suspends recording the call}
\usage{
connect_suspend_contact_recording(InstanceId, ContactId,
  InitialContactId)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{ContactId}{[required] The identifier of the contact.}

\item{InitialContactId}{[required] The identifier of the contact. This is the identifier of the contact
associated with the first interaction with the contact center.}
}
\description{
When a contact is being recorded, this API suspends recording the call.
For example, you might suspend the call recording while collecting
sensitive information, such as a credit card number. Then use
ResumeContactRecording to restart recording.
}
\details{
The period of time that the recording is suspended is filled with
silence in the final recording.

Only voice recordings are supported at this time.
}
\section{Request syntax}{
\preformatted{svc$suspend_contact_recording(
  InstanceId = "string",
  ContactId = "string",
  InitialContactId = "string"
)
}
}

\keyword{internal}
