# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Connect Contact Lens
#'
#' @description
#' Contact Lens for Amazon Connect enables you to analyze conversations
#' between customer and agents, by using speech transcription, natural
#' language processing, and intelligent search capabilities. It performs
#' sentiment analysis, detects issues, and enables you to automatically
#' categorize contacts.
#' 
#' Contact Lens for Amazon Connect provides both real-time and post-call
#' analytics of customer-agent conversations. For more information, see
#' [Analyze conversations using Contact
#' Lens](https://docs.aws.amazon.com/connect/latest/adminguide/analyze-conversations.html)
#' in the *Amazon Connect Administrator Guide*.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- connectcontactlens(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- connectcontactlens()
#' svc$list_realtime_contact_analysis_segments(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=connectcontactlens_list_realtime_contact_analysis_segments]{list_realtime_contact_analysis_segments} \tab Provides a list of analysis segments for a real-time analysis session
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname connectcontactlens
#' @export
connectcontactlens <- function(config = list()) {
  svc <- .connectcontactlens$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.connectcontactlens <- list()

.connectcontactlens$operations <- list()

.connectcontactlens$metadata <- list(
  service_name = "connectcontactlens",
  endpoints = list("*" = list(endpoint = "contact-lens.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "contact-lens.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "contact-lens.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "contact-lens.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Connect Contact Lens",
  api_version = "2020-08-21",
  signing_name = "connect",
  json_version = "1.1",
  target_prefix = ""
)

.connectcontactlens$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.connectcontactlens$metadata, handlers, config)
}
