% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_disassociate_flow}
\alias{connect_disassociate_flow}
\title{Disassociates a connect resource from a flow}
\usage{
connect_disassociate_flow(InstanceId, ResourceId, ResourceType)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{ResourceId}{[required] The identifier of the resource.
\itemize{
\item Amazon Web Services End User Messaging SMS phone number ARN when
using \code{SMS_PHONE_NUMBER}
\item Amazon Web Services End User Messaging Social phone number ARN when
using \code{WHATSAPP_MESSAGING_PHONE_NUMBER}
}}

\item{ResourceType}{[required] A valid resource type.}
}
\description{
Disassociates a connect resource from a flow.

See \url{https://www.paws-r-sdk.com/docs/connect_disassociate_flow/} for full documentation.
}
\keyword{internal}
