% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_update_continuous_backups}
\alias{dynamodb_update_continuous_backups}
\title{UpdateContinuousBackups enables or disables point in time recovery for
the specified table}
\usage{
dynamodb_update_continuous_backups(TableName,
  PointInTimeRecoverySpecification)
}
\arguments{
\item{TableName}{[required] The name of the table.}

\item{PointInTimeRecoverySpecification}{[required] Represents the settings used to enable point in time recovery.}
}
\description{
\code{UpdateContinuousBackups} enables or disables point in time recovery for
the specified table. A successful \code{UpdateContinuousBackups} call returns
the current \code{ContinuousBackupsDescription}. Continuous backups are
\code{ENABLED} on all tables at table creation. If point in time recovery is
enabled, \code{PointInTimeRecoveryStatus} will be set to ENABLED.

Once continuous backups and point in time recovery are enabled, you can
restore to any point in time within \code{EarliestRestorableDateTime} and
\code{LatestRestorableDateTime}.

\code{LatestRestorableDateTime} is typically 5 minutes before the current
time. You can restore your table to any point in time during the last 35
days.
}
\section{Request syntax}{
\preformatted{svc$update_continuous_backups(
  TableName = "string",
  PointInTimeRecoverySpecification = list(
    PointInTimeRecoveryEnabled = TRUE|FALSE
  )
)
}
}

\keyword{internal}
