% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_list_tags_for_resource}
\alias{rds_list_tags_for_resource}
\title{Lists all tags on an Amazon RDS resource}
\usage{
rds_list_tags_for_resource(ResourceName, Filters)
}
\arguments{
\item{ResourceName}{[required] The Amazon RDS resource with tags to be listed. This value is an Amazon
Resource Name (ARN). For information about creating an ARN, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing}{Constructing an ARN for Amazon RDS}
in the \emph{Amazon RDS User Guide}.}

\item{Filters}{This parameter isn't currently supported.}
}
\description{
Lists all tags on an Amazon RDS resource.

For an overview on tagging an Amazon RDS resource, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html}{Tagging Amazon RDS Resources}
in the \emph{Amazon RDS User Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  ResourceName = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
