% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_describe_global_table_settings}
\alias{dynamodb_describe_global_table_settings}
\title{Describes Region-specific settings for a global table}
\usage{
dynamodb_describe_global_table_settings(GlobalTableName)
}
\arguments{
\item{GlobalTableName}{[required] The name of the global table to describe.}
}
\value{
A list with the following syntax:\preformatted{list(
  GlobalTableName = "string",
  ReplicaSettings = list(
    list(
      RegionName = "string",
      ReplicaStatus = "CREATING"|"CREATION_FAILED"|"UPDATING"|"DELETING"|"ACTIVE"|"REGION_DISABLED"|"INACCESSIBLE_ENCRYPTION_CREDENTIALS",
      ReplicaBillingModeSummary = list(
        BillingMode = "PROVISIONED"|"PAY_PER_REQUEST",
        LastUpdateToPayPerRequestDateTime = as.POSIXct(
          "2015-01-01"
        )
      ),
      ReplicaProvisionedReadCapacityUnits = 123,
      ReplicaProvisionedReadCapacityAutoScalingSettings = list(
        MinimumUnits = 123,
        MaximumUnits = 123,
        AutoScalingDisabled = TRUE|FALSE,
        AutoScalingRoleArn = "string",
        ScalingPolicies = list(
          list(
            PolicyName = "string",
            TargetTrackingScalingPolicyConfiguration = list(
              DisableScaleIn = TRUE|FALSE,
              ScaleInCooldown = 123,
              ScaleOutCooldown = 123,
              TargetValue = 123.0
            )
          )
        )
      ),
      ReplicaProvisionedWriteCapacityUnits = 123,
      ReplicaProvisionedWriteCapacityAutoScalingSettings = list(
        MinimumUnits = 123,
        MaximumUnits = 123,
        AutoScalingDisabled = TRUE|FALSE,
        AutoScalingRoleArn = "string",
        ScalingPolicies = list(
          list(
            PolicyName = "string",
            TargetTrackingScalingPolicyConfiguration = list(
              DisableScaleIn = TRUE|FALSE,
              ScaleInCooldown = 123,
              ScaleOutCooldown = 123,
              TargetValue = 123.0
            )
          )
        )
      ),
      ReplicaGlobalSecondaryIndexSettings = list(
        list(
          IndexName = "string",
          IndexStatus = "CREATING"|"UPDATING"|"DELETING"|"ACTIVE",
          ProvisionedReadCapacityUnits = 123,
          ProvisionedReadCapacityAutoScalingSettings = list(
            MinimumUnits = 123,
            MaximumUnits = 123,
            AutoScalingDisabled = TRUE|FALSE,
            AutoScalingRoleArn = "string",
            ScalingPolicies = list(
              list(
                PolicyName = "string",
                TargetTrackingScalingPolicyConfiguration = list(
                  DisableScaleIn = TRUE|FALSE,
                  ScaleInCooldown = 123,
                  ScaleOutCooldown = 123,
                  TargetValue = 123.0
                )
              )
            )
          ),
          ProvisionedWriteCapacityUnits = 123,
          ProvisionedWriteCapacityAutoScalingSettings = list(
            MinimumUnits = 123,
            MaximumUnits = 123,
            AutoScalingDisabled = TRUE|FALSE,
            AutoScalingRoleArn = "string",
            ScalingPolicies = list(
              list(
                PolicyName = "string",
                TargetTrackingScalingPolicyConfiguration = list(
                  DisableScaleIn = TRUE|FALSE,
                  ScaleInCooldown = 123,
                  ScaleOutCooldown = 123,
                  TargetValue = 123.0
                )
              )
            )
          )
        )
      )
    )
  )
)
}
}
\description{
Describes Region-specific settings for a global table.

This operation only applies to \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html}{Version 2017.11.29}
of global tables.
}
\section{Request syntax}{
\preformatted{svc$describe_global_table_settings(
  GlobalTableName = "string"
)
}
}

\keyword{internal}
