% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_copy_db_snapshot}
\alias{rds_copy_db_snapshot}
\title{Copies the specified DB snapshot}
\usage{
rds_copy_db_snapshot(SourceDBSnapshotIdentifier,
  TargetDBSnapshotIdentifier, KmsKeyId, Tags, CopyTags, PreSignedUrl,
  OptionGroupName, SourceRegion)
}
\arguments{
\item{SourceDBSnapshotIdentifier}{[required] The identifier for the source DB snapshot.

If the source snapshot is in the same AWS Region as the copy, specify a
valid DB snapshot identifier. For example, you might specify
\code{rds:mysql-instance1-snapshot-20130805}.

If the source snapshot is in a different AWS Region than the copy,
specify a valid DB snapshot ARN. For example, you might specify
\code{arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805}.

If you are copying from a shared manual DB snapshot, this parameter must
be the Amazon Resource Name (ARN) of the shared DB snapshot.

If you are copying an encrypted snapshot this parameter must be in the
ARN format for the source AWS Region, and must match the
\code{SourceDBSnapshotIdentifier} in the \code{PreSignedUrl} parameter.

Constraints:
\itemize{
\item Must specify a valid system snapshot in the "available" state.
}

Example: \code{rds:mydb-2012-04-02-00-01}

Example:
\code{arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805}}

\item{TargetDBSnapshotIdentifier}{[required] The identifier for the copy of the snapshot.

Constraints:
\itemize{
\item Can't be null, empty, or blank
\item Must contain from 1 to 255 letters, numbers, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-db-snapshot}}

\item{KmsKeyId}{The AWS KMS key ID for an encrypted DB snapshot. The KMS key ID is the
Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for
the KMS encryption key.

If you copy an encrypted DB snapshot from your AWS account, you can
specify a value for this parameter to encrypt the copy with a new KMS
encryption key. If you don't specify a value for this parameter, then
the copy of the DB snapshot is encrypted with the same KMS key as the
source DB snapshot.

If you copy an encrypted DB snapshot that is shared from another AWS
account, then you must specify a value for this parameter.

If you specify this parameter when you copy an unencrypted snapshot, the
copy is encrypted.

If you copy an encrypted snapshot to a different AWS Region, then you
must specify a KMS key for the destination AWS Region. KMS encryption
keys are specific to the AWS Region that they are created in, and you
can't use encryption keys from one AWS Region in another AWS Region.}

\item{Tags}{}

\item{CopyTags}{A value that indicates whether to copy all tags from the source DB
snapshot to the target DB snapshot. By default, tags are not copied.}

\item{PreSignedUrl}{The URL that contains a Signature Version 4 signed request for the
\code{CopyDBSnapshot} API action in the source AWS Region that contains the
source DB snapshot to copy.

You must specify this parameter when you copy an encrypted DB snapshot
from another AWS Region by using the Amazon RDS API. You can specify the
\code{--source-region} option instead of this parameter when you copy an
encrypted DB snapshot from another AWS Region by using the AWS CLI.

The presigned URL must be a valid request for the \code{CopyDBSnapshot} API
action that can be executed in the source AWS Region that contains the
encrypted DB snapshot to be copied. The presigned URL request must
contain the following parameter values:
\itemize{
\item \code{DestinationRegion} - The AWS Region that the encrypted DB snapshot
is copied to. This AWS Region is the same one where the
\code{CopyDBSnapshot} action is called that contains this presigned URL.

For example, if you copy an encrypted DB snapshot from the us-west-2
AWS Region to the us-east-1 AWS Region, then you call the
\code{CopyDBSnapshot} action in the us-east-1 AWS Region and provide a
presigned URL that contains a call to the \code{CopyDBSnapshot} action in
the us-west-2 AWS Region. For this example, the \code{DestinationRegion}
in the presigned URL must be set to the us-east-1 AWS Region.
\item \code{KmsKeyId} - The AWS KMS key identifier for the key to use to
encrypt the copy of the DB snapshot in the destination AWS Region.
This is the same identifier for both the \code{CopyDBSnapshot} action
that is called in the destination AWS Region, and the action
contained in the presigned URL.
\item \code{SourceDBSnapshotIdentifier} - The DB snapshot identifier for the
encrypted snapshot to be copied. This identifier must be in the
Amazon Resource Name (ARN) format for the source AWS Region. For
example, if you are copying an encrypted DB snapshot from the
us-west-2 AWS Region, then your \code{SourceDBSnapshotIdentifier} looks
like the following example:
\code{arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115}.
}

To learn how to generate a Signature Version 4 signed request, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html}{Authenticating Requests: Using Query Parameters (AWS Signature Version 4)}
and \href{https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html}{Signature Version 4 Signing Process}.

If you supply a value for this operation's \code{SourceRegion} parameter, a
pre-signed URL will be calculated on your behalf.}

\item{OptionGroupName}{The name of an option group to associate with the copy of the snapshot.

Specify this option if you are copying a snapshot from one AWS Region to
another, and your DB instance uses a nondefault option group. If your
source DB instance uses Transparent Data Encryption for Oracle or
Microsoft SQL Server, you must specify this option when copying across
AWS Regions. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options}{Option Group Considerations}
in the \emph{Amazon RDS User Guide.}}

\item{SourceRegion}{The ID of the region that contains the snapshot to be copied.}
}
\description{
Copies the specified DB snapshot. The source DB snapshot must be in the
"available" state.
}
\details{
You can copy a snapshot from one AWS Region to another. In that case,
the AWS Region where you call the \code{CopyDBSnapshot} action is the
destination AWS Region for the DB snapshot copy.

For more information about copying snapshots, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopyDBSnapshot.html}{Copying a DB Snapshot}
in the \emph{Amazon RDS User Guide.}
}
\section{Request syntax}{
\preformatted{svc$copy_db_snapshot(
  SourceDBSnapshotIdentifier = "string",
  TargetDBSnapshotIdentifier = "string",
  KmsKeyId = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  CopyTags = TRUE|FALSE,
  PreSignedUrl = "string",
  OptionGroupName = "string",
  SourceRegion = "string"
)
}
}

\keyword{internal}
